/*
 * Decompiled with CFR 0.152.
 */
package com.bestvike.linq.util.lang;

import com.bestvike.linq.util.lang.IStringSpan;
import com.bestvike.linq.util.lang.StringSpan;

public final class StringSubSpan
implements IStringSpan {
    private final CharSequence value;
    private final int offset;
    private final int length;

    StringSubSpan(CharSequence value, int offset, int length) {
        this.value = value;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public CharSequence raw() {
        return this.value;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(this.offset + index);
    }

    @Override
    public IStringSpan trim() {
        int start;
        CharSequence value = this.value;
        int length = this.length;
        int end = this.offset + length - 1;
        for (start = this.offset; start <= end && Character.isWhitespace(value.charAt(start)); ++start) {
        }
        while (end >= start && Character.isWhitespace(value.charAt(end))) {
            --end;
        }
        int len = end - start + 1;
        return len == length ? this : (len == 0 ? StringSpan.Empty : new StringSubSpan(this.value, start, len));
    }

    @Override
    public IStringSpan subSequence(int start) {
        return this.subSequence(start, this.length);
    }

    @Override
    public IStringSpan subSequence(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        int length = this.length;
        if (end > length) {
            throw new StringIndexOutOfBoundsException(end);
        }
        int subLen = end - start;
        if (subLen < 0) {
            throw new StringIndexOutOfBoundsException(subLen);
        }
        return start == 0 && end == length ? this : new StringSubSpan(this.value, this.offset + start, subLen);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof IStringSpan)) {
            return false;
        }
        IStringSpan thatSpan = (IStringSpan)that;
        int n = this.length();
        if (n != thatSpan.length()) {
            return false;
        }
        int i = 0;
        while (n-- != 0) {
            if (this.charAt(i) != thatSpan.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        int length = this.length();
        for (int i = 0; i < length; ++i) {
            result = 31 * result + this.charAt(i);
        }
        return result;
    }

    @Override
    public String toString() {
        return this.value.subSequence(this.offset, this.offset + this.length).toString();
    }
}

