/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.scim2.server;

import com.bettercloud.scim2.common.GenericScimResource;
import com.bettercloud.scim2.common.Path;
import com.bettercloud.scim2.common.ScimResource;
import com.bettercloud.scim2.common.exceptions.BadRequestException;
import com.bettercloud.scim2.common.messages.PatchOperation;
import com.bettercloud.scim2.common.types.Meta;
import com.bettercloud.scim2.common.utils.StaticUtils;
import com.bettercloud.scim2.server.ResourceTypeDefinition;
import com.bettercloud.scim2.server.ScimResourceTrimmer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.web.util.UriComponentsBuilder;

public class ResourcePreparer<T extends ScimResource> {
    private final ResourceTypeDefinition resourceType;
    private final URI baseUri;
    private final Set<Path> queryAttributes;
    private final boolean excluded;

    public ResourcePreparer(ResourceTypeDefinition resourceType, String attributesString, String excludedAttributesString, URI baseUri) throws BadRequestException {
        if (attributesString != null && !attributesString.isEmpty()) {
            Set attributeSet = StaticUtils.arrayToSet((Object[])StaticUtils.splitCommaSeparatedString((String)attributesString));
            this.queryAttributes = new LinkedHashSet<Path>(attributeSet.size());
            for (String attribute : attributeSet) {
                Path normalizedPath;
                try {
                    normalizedPath = resourceType.normalizePath(Path.fromString((String)attribute)).withoutFilters();
                }
                catch (BadRequestException e) {
                    throw BadRequestException.invalidValue((String)("'" + attribute + "' is not a valid value for the attributes parameter: " + e.getMessage()));
                }
                this.queryAttributes.add(normalizedPath);
            }
            this.excluded = false;
        } else if (excludedAttributesString != null && !excludedAttributesString.isEmpty()) {
            Set attributeSet = StaticUtils.arrayToSet((Object[])StaticUtils.splitCommaSeparatedString((String)excludedAttributesString));
            this.queryAttributes = new LinkedHashSet<Path>(attributeSet.size());
            for (String attribute : attributeSet) {
                Path normalizedPath;
                try {
                    normalizedPath = resourceType.normalizePath(Path.fromString((String)attribute)).withoutFilters();
                }
                catch (BadRequestException e) {
                    throw BadRequestException.invalidValue((String)("'" + attribute + "' is not a valid value for the excludedAttributes parameter: " + e.getMessage()));
                }
                this.queryAttributes.add(normalizedPath);
            }
            this.excluded = true;
        } else {
            this.queryAttributes = Collections.emptySet();
            this.excluded = true;
        }
        this.resourceType = resourceType;
        this.baseUri = baseUri;
    }

    public GenericScimResource trimRetrievedResource(T returnedResource) {
        return this.trimReturned(returnedResource, null, null);
    }

    public GenericScimResource trimCreatedResource(T returnedResource, T requestResource) {
        return this.trimReturned(returnedResource, requestResource, null);
    }

    public GenericScimResource trimReplacedResource(T returnedResource, T requestResource) {
        return this.trimReturned(returnedResource, requestResource, null);
    }

    public GenericScimResource trimModifiedResource(T returnedResource, Iterable<PatchOperation> patchOperations) {
        return this.trimReturned(returnedResource, null, patchOperations);
    }

    public void setResourceTypeAndLocation(T returnedResource) {
        Meta meta = returnedResource.getMeta();
        boolean metaUpdated = false;
        if (meta == null) {
            meta = new Meta();
        }
        if (meta.getResourceType() == null) {
            meta.setResourceType(this.resourceType.getName());
            metaUpdated = true;
        }
        if (meta.getLocation() == null) {
            String id = returnedResource.getId();
            if (id != null) {
                UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)this.baseUri);
                builder.path("/");
                builder.path(id);
                meta.setLocation(builder.build().toUri());
            } else {
                meta.setLocation(this.baseUri);
            }
            metaUpdated = true;
        }
        if (metaUpdated) {
            returnedResource.setMeta(meta);
        }
    }

    private GenericScimResource trimReturned(T returnedResource, T requestResource, Iterable<PatchOperation> patchOperations) {
        Set<Path> requestAttributes = Collections.emptySet();
        if (requestResource != null) {
            ObjectNode requestObject = requestResource.asGenericScimResource().getObjectNode();
            requestAttributes = new LinkedHashSet();
            this.collectAttributes(Path.root(), requestAttributes, requestObject);
        }
        if (patchOperations != null) {
            requestAttributes = new LinkedHashSet();
            this.collectAttributes(requestAttributes, patchOperations);
        }
        this.setResourceTypeAndLocation(returnedResource);
        GenericScimResource genericReturnedResource = returnedResource.asGenericScimResource();
        ScimResourceTrimmer trimmer = new ScimResourceTrimmer(this.resourceType, requestAttributes, this.queryAttributes, this.excluded);
        return new GenericScimResource(trimmer.trimObjectNode(genericReturnedResource.getObjectNode()));
    }

    private void collectAttributes(Path parentPath, Set<Path> paths, ObjectNode objectNode) {
        Iterator i = objectNode.fields();
        while (i.hasNext()) {
            Map.Entry field = (Map.Entry)i.next();
            Path path = parentPath.attribute((String)field.getKey());
            if (path.size() > 1 || path.getSchemaUrn() == null) {
                paths.add(path);
            }
            if (((JsonNode)field.getValue()).isArray()) {
                this.collectAttributes(path, paths, (ArrayNode)field.getValue());
                continue;
            }
            if (!((JsonNode)field.getValue()).isObject()) continue;
            this.collectAttributes(path, paths, (ObjectNode)field.getValue());
        }
    }

    private void collectAttributes(Path parentPath, Set<Path> paths, ArrayNode arrayNode) {
        for (JsonNode value : arrayNode) {
            if (value.isArray()) {
                this.collectAttributes(parentPath, paths, (ArrayNode)value);
                continue;
            }
            if (!value.isObject()) continue;
            this.collectAttributes(parentPath, paths, (ObjectNode)value);
        }
    }

    private void collectAttributes(Set<Path> paths, Iterable<PatchOperation> patchOperations) {
        for (PatchOperation patchOperation : patchOperations) {
            Path path = Path.root();
            if (patchOperation.getPath() != null) {
                path = this.resourceType.normalizePath(patchOperation.getPath()).withoutFilters();
                paths.add(path);
            }
            if (patchOperation.getJsonNode() == null) continue;
            if (patchOperation.getJsonNode().isArray()) {
                this.collectAttributes(path, paths, (ArrayNode)patchOperation.getJsonNode());
                continue;
            }
            if (!patchOperation.getJsonNode().isObject()) continue;
            this.collectAttributes(path, paths, (ObjectNode)patchOperation.getJsonNode());
        }
    }
}

