/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.scim2.server;

import com.bettercloud.scim2.common.Path;
import com.bettercloud.scim2.common.utils.JsonUtils;
import com.bettercloud.scim2.common.utils.SchemaUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.Map;

public abstract class ResourceTrimmer {
    public ObjectNode trimObjectNode(ObjectNode objectNode) {
        return this.trimObjectNode(objectNode, Path.root());
    }

    private ObjectNode trimObjectNode(ObjectNode objectNode, Path parentPath) {
        ObjectNode objectToReturn = JsonUtils.getJsonNodeFactory().objectNode();
        Iterator i = objectNode.fields();
        while (i.hasNext()) {
            Map.Entry field = (Map.Entry)i.next();
            this.processEntry(parentPath, objectToReturn, field);
        }
        return objectToReturn;
    }

    private void processEntry(Path parentPath, ObjectNode objectToReturn, Map.Entry<String, JsonNode> field) {
        Path path = parentPath.isRoot() && parentPath.getSchemaUrn() == null && SchemaUtils.isUrn((String)field.getKey()) ? Path.root((String)field.getKey()) : parentPath.attribute(field.getKey());
        if (path.isRoot() || this.shouldReturn(path)) {
            if (field.getValue().isArray()) {
                ArrayNode trimmedNode = this.trimArrayNode((ArrayNode)field.getValue(), path);
                if (trimmedNode.size() > 0) {
                    objectToReturn.set(field.getKey(), (JsonNode)trimmedNode);
                }
            } else if (field.getValue().isObject()) {
                ObjectNode trimmedNode = this.trimObjectNode((ObjectNode)field.getValue(), path);
                if (trimmedNode.size() > 0) {
                    objectToReturn.set(field.getKey(), (JsonNode)trimmedNode);
                }
            } else {
                objectToReturn.set(field.getKey(), field.getValue());
            }
        }
    }

    protected ArrayNode trimArrayNode(ArrayNode arrayNode, Path parentPath) {
        ArrayNode arrayToReturn = JsonUtils.getJsonNodeFactory().arrayNode();
        for (JsonNode value : arrayNode) {
            ArrayNode trimmedNode;
            if (value.isArray()) {
                trimmedNode = this.trimArrayNode((ArrayNode)value, parentPath);
                if (trimmedNode.size() <= 0) continue;
                arrayToReturn.add((JsonNode)trimmedNode);
                continue;
            }
            if (value.isObject()) {
                trimmedNode = this.trimObjectNode((ObjectNode)value, parentPath);
                if (trimmedNode.size() <= 0) continue;
                arrayToReturn.add((JsonNode)trimmedNode);
                continue;
            }
            arrayToReturn.add(value);
        }
        return arrayToReturn;
    }

    public abstract boolean shouldReturn(Path var1);
}

