/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.scim2.server;

import com.bettercloud.scim2.common.Path;
import com.bettercloud.scim2.common.types.AttributeDefinition;
import com.bettercloud.scim2.common.types.ResourceTypeResource;
import com.bettercloud.scim2.common.types.SchemaResource;
import com.bettercloud.scim2.common.utils.SchemaUtils;
import com.bettercloud.scim2.server.annotation.ScimResource;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;

public final class ResourceTypeDefinition {
    private static final Logger log = LoggerFactory.getLogger(ResourceTypeDefinition.class);
    private final String id;
    private final String name;
    private final String description;
    private final String endpoint;
    private final SchemaResource coreSchema;
    private final Map<SchemaResource, Boolean> schemaExtensions;
    private final Map<Path, AttributeDefinition> attributeNotationMap;
    private final boolean discoverable;

    public ResourceTypeDefinition(String id, String name, String description, String endpoint, SchemaResource coreSchema, Map<SchemaResource, Boolean> schemaExtensions, boolean discoverable) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (endpoint == null) {
            throw new IllegalArgumentException("endpoint must not be null");
        }
        this.name = name;
        this.endpoint = endpoint;
        this.id = id;
        this.description = description;
        this.coreSchema = coreSchema;
        this.schemaExtensions = Collections.unmodifiableMap(schemaExtensions);
        this.discoverable = discoverable;
        this.attributeNotationMap = new HashMap<Path, AttributeDefinition>();
        this.buildAttributeNotationMap(Path.root(), SchemaUtils.COMMON_ATTRIBUTE_DEFINITIONS);
        if (coreSchema != null) {
            this.buildAttributeNotationMap(Path.root(), coreSchema.getAttributes());
        }
        for (SchemaResource schemaExtension : schemaExtensions.keySet()) {
            this.buildAttributeNotationMap(Path.root((String)schemaExtension.getId()), schemaExtension.getAttributes());
        }
    }

    void buildAttributeNotationMap(Path parentPath, Collection<AttributeDefinition> attributes) {
        for (AttributeDefinition attribute : attributes) {
            Path path = parentPath.attribute(attribute.getName());
            this.attributeNotationMap.put(path, attribute);
            if (attribute.getSubAttributes() == null) continue;
            this.buildAttributeNotationMap(path, attribute.getSubAttributes());
        }
    }

    public AttributeDefinition getAttributeDefinition(Path path) {
        return this.attributeNotationMap.get(this.normalizePath(path).withoutFilters());
    }

    public Path normalizePath(Path path) {
        if (path.getSchemaUrn() != null && this.coreSchema != null && path.getSchemaUrn().equalsIgnoreCase(this.coreSchema.getId())) {
            return Path.root().attribute(path);
        }
        return path;
    }

    public ResourceTypeResource toScimResource() {
        URI coreSchemaUri = null;
        if (this.coreSchema != null) {
            try {
                coreSchemaUri = new URI(this.coreSchema.getId());
            }
            catch (URISyntaxException e) {
                log.error("Core schema id is not a valid URI", (Throwable)e);
            }
        }
        ArrayList<ResourceTypeResource.SchemaExtension> schemaExtensionList = null;
        if (this.schemaExtensions.size() > 0) {
            schemaExtensionList = new ArrayList<ResourceTypeResource.SchemaExtension>(this.schemaExtensions.size());
            for (Map.Entry<SchemaResource, Boolean> schemaExtension : this.schemaExtensions.entrySet()) {
                schemaExtensionList.add(new ResourceTypeResource.SchemaExtension(URI.create(schemaExtension.getKey().getId()), schemaExtension.getValue().booleanValue()));
            }
        }
        return new ResourceTypeResource(this.id == null ? this.name : this.id, this.name, this.description, URI.create(this.endpoint), coreSchemaUri, schemaExtensionList);
    }

    public static ResourceTypeDefinition fromScimResource(Class<?> scimResource) {
        RequestMapping mapping;
        ScimResource resourceType;
        Class<?> c = scimResource;
        do {
            resourceType = c.getAnnotation(ScimResource.class);
        } while ((c = c.getSuperclass()) != null && resourceType == null);
        c = scimResource;
        do {
            mapping = c.getAnnotation(RequestMapping.class);
        } while ((c = c.getSuperclass()) != null && mapping == null);
        if (resourceType == null || mapping == null) {
            return null;
        }
        try {
            HashMap<SchemaResource, Boolean> schemaExtensions = new HashMap<SchemaResource, Boolean>();
            for (Class<?> optionalSchemaExtension : resourceType.optionalSchemaExtensions()) {
                schemaExtensions.put(SchemaUtils.getSchema(optionalSchemaExtension), false);
            }
            for (Class<?> requiredSchemaExtension : resourceType.requiredSchemaExtensions()) {
                schemaExtensions.put(SchemaUtils.getSchema(requiredSchemaExtension), true);
            }
            return new ResourceTypeDefinition(null, resourceType.name(), resourceType.description(), mapping.value()[0], SchemaUtils.getSchema(resourceType.schema()), schemaExtensions, resourceType.discoverable());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ResourceTypeDefinition fromScimResource(ScimResource resourceType, RequestMapping mapping) {
        if (resourceType == null || mapping == null) {
            return null;
        }
        try {
            HashMap<SchemaResource, Boolean> schemaExtensions = new HashMap<SchemaResource, Boolean>();
            for (Class<?> optionalSchemaExtension : resourceType.optionalSchemaExtensions()) {
                schemaExtensions.put(SchemaUtils.getSchema(optionalSchemaExtension), false);
            }
            for (Class<?> requiredSchemaExtension : resourceType.requiredSchemaExtensions()) {
                schemaExtensions.put(SchemaUtils.getSchema(requiredSchemaExtension), true);
            }
            return new ResourceTypeDefinition(null, resourceType.name(), resourceType.description(), mapping.value()[0], SchemaUtils.getSchema(resourceType.schema()), schemaExtensions, resourceType.discoverable());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public SchemaResource getCoreSchema() {
        return this.coreSchema;
    }

    public Map<SchemaResource, Boolean> getSchemaExtensions() {
        return this.schemaExtensions;
    }

    public Map<Path, AttributeDefinition> getAttributeNotationMap() {
        return this.attributeNotationMap;
    }

    public boolean isDiscoverable() {
        return this.discoverable;
    }
}

