/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.scim2.server;

import com.bettercloud.scim2.common.Path;
import com.bettercloud.scim2.common.types.AttributeDefinition;
import com.bettercloud.scim2.server.ResourceTrimmer;
import com.bettercloud.scim2.server.ResourceTypeDefinition;
import java.util.Set;

public class ScimResourceTrimmer
extends ResourceTrimmer {
    private final ResourceTypeDefinition resourceType;
    private final Set<Path> requestAttributes;
    private final Set<Path> queryAttributes;
    private final boolean excluded;

    public ScimResourceTrimmer(ResourceTypeDefinition resourceType, Set<Path> requestAttributes, Set<Path> queryAttributes, boolean excluded) {
        this.resourceType = resourceType;
        this.requestAttributes = requestAttributes;
        this.queryAttributes = queryAttributes;
        this.excluded = excluded;
    }

    @Override
    public boolean shouldReturn(Path path) {
        AttributeDefinition attributeDefinition = this.resourceType.getAttributeDefinition(path);
        AttributeDefinition.Returned returned = attributeDefinition == null ? AttributeDefinition.Returned.DEFAULT : attributeDefinition.getReturned();
        switch (returned) {
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return false;
            }
            case REQUEST: {
                return this.pathContains(this.requestAttributes, path) || this.requestAttributes.isEmpty() && !this.excluded && this.pathContains(this.queryAttributes, path);
            }
        }
        if (this.excluded) {
            return !this.pathContains(this.queryAttributes, path);
        }
        return this.queryAttributes.isEmpty() || this.pathContains(this.queryAttributes, path);
    }

    private boolean pathContains(Set<Path> paths, Path path) {
        if (paths.contains(path)) {
            return true;
        }
        if (!this.excluded) {
            for (Path p : paths) {
                if (p.size() <= path.size() || !path.equals((Object)p.subPath(path.size()))) continue;
                return true;
            }
        }
        Path p = path;
        while (p.size() > 0) {
            if (paths.contains(p)) {
                return true;
            }
            p = p.subPath(p.size() - 1);
        }
        return false;
    }
}

