/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.scim2.server.config;

import com.bettercloud.scim2.server.ResourceTypeDefinition;
import com.bettercloud.scim2.server.annotation.ScimResource;
import com.bettercloud.scim2.server.config.Scim2Properties;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.web.bind.annotation.RequestMapping;

@Configuration
public class ResourceTypeRegistry {
    private static final Logger log = LoggerFactory.getLogger(ResourceTypeRegistry.class);

    @Bean
    public Set<ResourceTypeDefinition> getResourceDefinitions(Scim2Properties scim2Properties) throws ClassNotFoundException {
        AnnotationTypeFilter scimResourceFilter = new AnnotationTypeFilter(ScimResource.class);
        AnnotationTypeFilter requestMappingFilter = new AnnotationTypeFilter(RequestMapping.class);
        TypeFilter andFilter = (arg_0, arg_1) -> ResourceTypeRegistry.lambda$getResourceDefinitions$0((TypeFilter)scimResourceFilter, (TypeFilter)requestMappingFilter, arg_0, arg_1);
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter(andFilter);
        HashSet<ResourceTypeDefinition> resourceTypeDefinitions = new HashSet<ResourceTypeDefinition>();
        for (BeanDefinition beanDefinition : provider.findCandidateComponents(scim2Properties.getResourcesPackage())) {
            Class<?> className = Class.forName(beanDefinition.getBeanClassName());
            resourceTypeDefinitions.add(ResourceTypeDefinition.fromScimResource(className.getAnnotation(ScimResource.class), className.getAnnotation(RequestMapping.class)));
        }
        return resourceTypeDefinitions;
    }

    private static /* synthetic */ boolean lambda$getResourceDefinitions$0(TypeFilter scimResourceFilter, TypeFilter requestMappingFilter, MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
        return scimResourceFilter.match(metadataReader, metadataReaderFactory) && requestMappingFilter.match(metadataReader, metadataReaderFactory);
    }
}

