/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.scim2.server.config;

import com.bettercloud.scim2.common.types.AuthenticationScheme;
import com.bettercloud.scim2.common.types.BulkConfig;
import com.bettercloud.scim2.common.types.ChangePasswordConfig;
import com.bettercloud.scim2.common.types.ETagConfig;
import com.bettercloud.scim2.common.types.FilterConfig;
import com.bettercloud.scim2.common.types.PatchConfig;
import com.bettercloud.scim2.common.types.ServiceProviderConfigResource;
import com.bettercloud.scim2.common.types.SortConfig;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="scim2")
public class Scim2Properties {
    private static final Logger log = LoggerFactory.getLogger(Scim2Properties.class);
    @NotNull
    private String resourcesPackage;
    @NotBlank
    private String baseUrl;
    @NotNull
    private ServiceProviderConfigProperties serviceProviderConfig;

    public void setResourcesPackage(String resourcesPackage) {
        if (StringUtils.isEmpty((Object)resourcesPackage)) {
            log.warn("scim2.resourcesPackage was not set. This can slow down server initialization significantly.");
        }
        this.resourcesPackage = resourcesPackage;
    }

    public String getResourcesPackage() {
        return this.resourcesPackage;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public ServiceProviderConfigProperties getServiceProviderConfig() {
        return this.serviceProviderConfig;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setServiceProviderConfig(ServiceProviderConfigProperties serviceProviderConfig) {
        this.serviceProviderConfig = serviceProviderConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Scim2Properties)) {
            return false;
        }
        Scim2Properties other = (Scim2Properties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$resourcesPackage = this.getResourcesPackage();
        String other$resourcesPackage = other.getResourcesPackage();
        if (this$resourcesPackage == null ? other$resourcesPackage != null : !this$resourcesPackage.equals(other$resourcesPackage)) {
            return false;
        }
        String this$baseUrl = this.getBaseUrl();
        String other$baseUrl = other.getBaseUrl();
        if (this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl)) {
            return false;
        }
        ServiceProviderConfigProperties this$serviceProviderConfig = this.getServiceProviderConfig();
        ServiceProviderConfigProperties other$serviceProviderConfig = other.getServiceProviderConfig();
        return !(this$serviceProviderConfig == null ? other$serviceProviderConfig != null : !((Object)this$serviceProviderConfig).equals(other$serviceProviderConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Scim2Properties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $resourcesPackage = this.getResourcesPackage();
        result = result * 59 + ($resourcesPackage == null ? 43 : $resourcesPackage.hashCode());
        String $baseUrl = this.getBaseUrl();
        result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
        ServiceProviderConfigProperties $serviceProviderConfig = this.getServiceProviderConfig();
        result = result * 59 + ($serviceProviderConfig == null ? 43 : ((Object)$serviceProviderConfig).hashCode());
        return result;
    }

    public String toString() {
        return "Scim2Properties(resourcesPackage=" + this.getResourcesPackage() + ", baseUrl=" + this.getBaseUrl() + ", serviceProviderConfig=" + this.getServiceProviderConfig() + ")";
    }

    public Scim2Properties() {
    }

    public Scim2Properties(String resourcesPackage, String baseUrl, ServiceProviderConfigProperties serviceProviderConfig) {
        this.resourcesPackage = resourcesPackage;
        this.baseUrl = baseUrl;
        this.serviceProviderConfig = serviceProviderConfig;
    }

    public static class ServiceProviderConfigProperties {
        private String documentationUri;
        @NotNull
        private PatchConfigProperties patch;
        @NotNull
        private BulkConfigProperties bulk;
        @NotNull
        private FilterConfigProperties filter;
        @NotNull
        private ChangePasswordConfigProperties changePassword;
        @NotNull
        private SortConfigProperties sort;
        @NotNull
        private ETagConfigProperties etag;
        private List<AuthenticationSchemeProperties> authenticationSchemes = new ArrayList<AuthenticationSchemeProperties>();

        public ServiceProviderConfigResource getServiceProviderConfiguration() {
            return new ServiceProviderConfigResource(this.getDocumentationUri(), this.getPatch().getPatchConfig(), this.getBulk().getBulkConfig(), this.getFilter().getFilterConfig(), this.getChangePassword().getChangePasswordConfig(), this.getSort().getSortConfig(), this.getEtag().getETagConfig(), this.authenticationSchemes.stream().map(AuthenticationSchemeProperties::getAuthenticationScheme).collect(Collectors.toList()));
        }

        public String getDocumentationUri() {
            return this.documentationUri;
        }

        public PatchConfigProperties getPatch() {
            return this.patch;
        }

        public BulkConfigProperties getBulk() {
            return this.bulk;
        }

        public FilterConfigProperties getFilter() {
            return this.filter;
        }

        public ChangePasswordConfigProperties getChangePassword() {
            return this.changePassword;
        }

        public SortConfigProperties getSort() {
            return this.sort;
        }

        public ETagConfigProperties getEtag() {
            return this.etag;
        }

        public List<AuthenticationSchemeProperties> getAuthenticationSchemes() {
            return this.authenticationSchemes;
        }

        public void setDocumentationUri(String documentationUri) {
            this.documentationUri = documentationUri;
        }

        public void setPatch(PatchConfigProperties patch) {
            this.patch = patch;
        }

        public void setBulk(BulkConfigProperties bulk) {
            this.bulk = bulk;
        }

        public void setFilter(FilterConfigProperties filter) {
            this.filter = filter;
        }

        public void setChangePassword(ChangePasswordConfigProperties changePassword) {
            this.changePassword = changePassword;
        }

        public void setSort(SortConfigProperties sort) {
            this.sort = sort;
        }

        public void setEtag(ETagConfigProperties etag) {
            this.etag = etag;
        }

        public void setAuthenticationSchemes(List<AuthenticationSchemeProperties> authenticationSchemes) {
            this.authenticationSchemes = authenticationSchemes;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServiceProviderConfigProperties)) {
                return false;
            }
            ServiceProviderConfigProperties other = (ServiceProviderConfigProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$documentationUri = this.getDocumentationUri();
            String other$documentationUri = other.getDocumentationUri();
            if (this$documentationUri == null ? other$documentationUri != null : !this$documentationUri.equals(other$documentationUri)) {
                return false;
            }
            PatchConfigProperties this$patch = this.getPatch();
            PatchConfigProperties other$patch = other.getPatch();
            if (this$patch == null ? other$patch != null : !((Object)this$patch).equals(other$patch)) {
                return false;
            }
            BulkConfigProperties this$bulk = this.getBulk();
            BulkConfigProperties other$bulk = other.getBulk();
            if (this$bulk == null ? other$bulk != null : !((Object)this$bulk).equals(other$bulk)) {
                return false;
            }
            FilterConfigProperties this$filter = this.getFilter();
            FilterConfigProperties other$filter = other.getFilter();
            if (this$filter == null ? other$filter != null : !((Object)this$filter).equals(other$filter)) {
                return false;
            }
            ChangePasswordConfigProperties this$changePassword = this.getChangePassword();
            ChangePasswordConfigProperties other$changePassword = other.getChangePassword();
            if (this$changePassword == null ? other$changePassword != null : !((Object)this$changePassword).equals(other$changePassword)) {
                return false;
            }
            SortConfigProperties this$sort = this.getSort();
            SortConfigProperties other$sort = other.getSort();
            if (this$sort == null ? other$sort != null : !((Object)this$sort).equals(other$sort)) {
                return false;
            }
            ETagConfigProperties this$etag = this.getEtag();
            ETagConfigProperties other$etag = other.getEtag();
            if (this$etag == null ? other$etag != null : !((Object)this$etag).equals(other$etag)) {
                return false;
            }
            List<AuthenticationSchemeProperties> this$authenticationSchemes = this.getAuthenticationSchemes();
            List<AuthenticationSchemeProperties> other$authenticationSchemes = other.getAuthenticationSchemes();
            return !(this$authenticationSchemes == null ? other$authenticationSchemes != null : !((Object)this$authenticationSchemes).equals(other$authenticationSchemes));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ServiceProviderConfigProperties;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $documentationUri = this.getDocumentationUri();
            result = result * 59 + ($documentationUri == null ? 43 : $documentationUri.hashCode());
            PatchConfigProperties $patch = this.getPatch();
            result = result * 59 + ($patch == null ? 43 : ((Object)$patch).hashCode());
            BulkConfigProperties $bulk = this.getBulk();
            result = result * 59 + ($bulk == null ? 43 : ((Object)$bulk).hashCode());
            FilterConfigProperties $filter = this.getFilter();
            result = result * 59 + ($filter == null ? 43 : ((Object)$filter).hashCode());
            ChangePasswordConfigProperties $changePassword = this.getChangePassword();
            result = result * 59 + ($changePassword == null ? 43 : ((Object)$changePassword).hashCode());
            SortConfigProperties $sort = this.getSort();
            result = result * 59 + ($sort == null ? 43 : ((Object)$sort).hashCode());
            ETagConfigProperties $etag = this.getEtag();
            result = result * 59 + ($etag == null ? 43 : ((Object)$etag).hashCode());
            List<AuthenticationSchemeProperties> $authenticationSchemes = this.getAuthenticationSchemes();
            result = result * 59 + ($authenticationSchemes == null ? 43 : ((Object)$authenticationSchemes).hashCode());
            return result;
        }

        public String toString() {
            return "Scim2Properties.ServiceProviderConfigProperties(documentationUri=" + this.getDocumentationUri() + ", patch=" + this.getPatch() + ", bulk=" + this.getBulk() + ", filter=" + this.getFilter() + ", changePassword=" + this.getChangePassword() + ", sort=" + this.getSort() + ", etag=" + this.getEtag() + ", authenticationSchemes=" + this.getAuthenticationSchemes() + ")";
        }

        public ServiceProviderConfigProperties() {
        }

        public ServiceProviderConfigProperties(String documentationUri, PatchConfigProperties patch, BulkConfigProperties bulk, FilterConfigProperties filter, ChangePasswordConfigProperties changePassword, SortConfigProperties sort, ETagConfigProperties etag, List<AuthenticationSchemeProperties> authenticationSchemes) {
            this.documentationUri = documentationUri;
            this.patch = patch;
            this.bulk = bulk;
            this.filter = filter;
            this.changePassword = changePassword;
            this.sort = sort;
            this.etag = etag;
            this.authenticationSchemes = authenticationSchemes;
        }

        public static class AuthenticationSchemeProperties {
            @NotBlank
            private String name;
            @NotBlank
            private String description;
            private URI specUri;
            private URI documentationUri;
            private String type;
            private boolean primary = false;

            public AuthenticationScheme getAuthenticationScheme() {
                return new AuthenticationScheme(this.name, this.description, this.specUri, this.documentationUri, this.type, this.primary);
            }

            public String getName() {
                return this.name;
            }

            public String getDescription() {
                return this.description;
            }

            public URI getSpecUri() {
                return this.specUri;
            }

            public URI getDocumentationUri() {
                return this.documentationUri;
            }

            public String getType() {
                return this.type;
            }

            public boolean isPrimary() {
                return this.primary;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setDescription(String description) {
                this.description = description;
            }

            public void setSpecUri(URI specUri) {
                this.specUri = specUri;
            }

            public void setDocumentationUri(URI documentationUri) {
                this.documentationUri = documentationUri;
            }

            public void setType(String type) {
                this.type = type;
            }

            public void setPrimary(boolean primary) {
                this.primary = primary;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AuthenticationSchemeProperties)) {
                    return false;
                }
                AuthenticationSchemeProperties other = (AuthenticationSchemeProperties)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$description = this.getDescription();
                String other$description = other.getDescription();
                if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                    return false;
                }
                URI this$specUri = this.getSpecUri();
                URI other$specUri = other.getSpecUri();
                if (this$specUri == null ? other$specUri != null : !((Object)this$specUri).equals(other$specUri)) {
                    return false;
                }
                URI this$documentationUri = this.getDocumentationUri();
                URI other$documentationUri = other.getDocumentationUri();
                if (this$documentationUri == null ? other$documentationUri != null : !((Object)this$documentationUri).equals(other$documentationUri)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                    return false;
                }
                return this.isPrimary() == other.isPrimary();
            }

            protected boolean canEqual(Object other) {
                return other instanceof AuthenticationSchemeProperties;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $description = this.getDescription();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                URI $specUri = this.getSpecUri();
                result = result * 59 + ($specUri == null ? 43 : ((Object)$specUri).hashCode());
                URI $documentationUri = this.getDocumentationUri();
                result = result * 59 + ($documentationUri == null ? 43 : ((Object)$documentationUri).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                result = result * 59 + (this.isPrimary() ? 79 : 97);
                return result;
            }

            public String toString() {
                return "Scim2Properties.ServiceProviderConfigProperties.AuthenticationSchemeProperties(name=" + this.getName() + ", description=" + this.getDescription() + ", specUri=" + this.getSpecUri() + ", documentationUri=" + this.getDocumentationUri() + ", type=" + this.getType() + ", primary=" + this.isPrimary() + ")";
            }

            public AuthenticationSchemeProperties() {
            }

            public AuthenticationSchemeProperties(String name, String description, URI specUri, URI documentationUri, String type, boolean primary) {
                this.name = name;
                this.description = description;
                this.specUri = specUri;
                this.documentationUri = documentationUri;
                this.type = type;
                this.primary = primary;
            }
        }

        public static class ETagConfigProperties {
            private boolean supported = false;

            public ETagConfig getETagConfig() {
                return new ETagConfig(this.supported);
            }

            public boolean isSupported() {
                return this.supported;
            }

            public void setSupported(boolean supported) {
                this.supported = supported;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ETagConfigProperties)) {
                    return false;
                }
                ETagConfigProperties other = (ETagConfigProperties)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return this.isSupported() == other.isSupported();
            }

            protected boolean canEqual(Object other) {
                return other instanceof ETagConfigProperties;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isSupported() ? 79 : 97);
                return result;
            }

            public String toString() {
                return "Scim2Properties.ServiceProviderConfigProperties.ETagConfigProperties(supported=" + this.isSupported() + ")";
            }

            public ETagConfigProperties() {
            }

            public ETagConfigProperties(boolean supported) {
                this.supported = supported;
            }
        }

        public static class SortConfigProperties {
            private boolean supported = false;

            public SortConfig getSortConfig() {
                return new SortConfig(this.supported);
            }

            public boolean isSupported() {
                return this.supported;
            }

            public void setSupported(boolean supported) {
                this.supported = supported;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SortConfigProperties)) {
                    return false;
                }
                SortConfigProperties other = (SortConfigProperties)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return this.isSupported() == other.isSupported();
            }

            protected boolean canEqual(Object other) {
                return other instanceof SortConfigProperties;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isSupported() ? 79 : 97);
                return result;
            }

            public String toString() {
                return "Scim2Properties.ServiceProviderConfigProperties.SortConfigProperties(supported=" + this.isSupported() + ")";
            }

            public SortConfigProperties() {
            }

            public SortConfigProperties(boolean supported) {
                this.supported = supported;
            }
        }

        public static class ChangePasswordConfigProperties {
            private boolean supported = false;

            public ChangePasswordConfig getChangePasswordConfig() {
                return new ChangePasswordConfig(this.supported);
            }

            public boolean isSupported() {
                return this.supported;
            }

            public void setSupported(boolean supported) {
                this.supported = supported;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ChangePasswordConfigProperties)) {
                    return false;
                }
                ChangePasswordConfigProperties other = (ChangePasswordConfigProperties)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return this.isSupported() == other.isSupported();
            }

            protected boolean canEqual(Object other) {
                return other instanceof ChangePasswordConfigProperties;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isSupported() ? 79 : 97);
                return result;
            }

            public String toString() {
                return "Scim2Properties.ServiceProviderConfigProperties.ChangePasswordConfigProperties(supported=" + this.isSupported() + ")";
            }

            public ChangePasswordConfigProperties() {
            }

            public ChangePasswordConfigProperties(boolean supported) {
                this.supported = supported;
            }
        }

        public static class FilterConfigProperties {
            private boolean supported = true;
            @Min(value=0L)
            private @Min(value=0L) int maxResults = 100;

            public FilterConfig getFilterConfig() {
                return new FilterConfig(this.supported, this.maxResults);
            }

            public boolean isSupported() {
                return this.supported;
            }

            public int getMaxResults() {
                return this.maxResults;
            }

            public void setSupported(boolean supported) {
                this.supported = supported;
            }

            public void setMaxResults(int maxResults) {
                this.maxResults = maxResults;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FilterConfigProperties)) {
                    return false;
                }
                FilterConfigProperties other = (FilterConfigProperties)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.isSupported() != other.isSupported()) {
                    return false;
                }
                return this.getMaxResults() == other.getMaxResults();
            }

            protected boolean canEqual(Object other) {
                return other instanceof FilterConfigProperties;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isSupported() ? 79 : 97);
                result = result * 59 + this.getMaxResults();
                return result;
            }

            public String toString() {
                return "Scim2Properties.ServiceProviderConfigProperties.FilterConfigProperties(supported=" + this.isSupported() + ", maxResults=" + this.getMaxResults() + ")";
            }

            public FilterConfigProperties() {
            }

            public FilterConfigProperties(boolean supported, int maxResults) {
                this.supported = supported;
                this.maxResults = maxResults;
            }
        }

        public static class BulkConfigProperties {
            private boolean supported = false;
            @Min(value=0L)
            private @Min(value=0L) int maxOperations = 0;
            @Min(value=0L)
            private @Min(value=0L) int maxPayloadSize = 0;

            public BulkConfig getBulkConfig() {
                return new BulkConfig(this.supported, this.maxOperations, this.maxPayloadSize);
            }

            public boolean isSupported() {
                return this.supported;
            }

            public int getMaxOperations() {
                return this.maxOperations;
            }

            public int getMaxPayloadSize() {
                return this.maxPayloadSize;
            }

            public void setSupported(boolean supported) {
                this.supported = supported;
            }

            public void setMaxOperations(int maxOperations) {
                this.maxOperations = maxOperations;
            }

            public void setMaxPayloadSize(int maxPayloadSize) {
                this.maxPayloadSize = maxPayloadSize;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BulkConfigProperties)) {
                    return false;
                }
                BulkConfigProperties other = (BulkConfigProperties)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.isSupported() != other.isSupported()) {
                    return false;
                }
                if (this.getMaxOperations() != other.getMaxOperations()) {
                    return false;
                }
                return this.getMaxPayloadSize() == other.getMaxPayloadSize();
            }

            protected boolean canEqual(Object other) {
                return other instanceof BulkConfigProperties;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isSupported() ? 79 : 97);
                result = result * 59 + this.getMaxOperations();
                result = result * 59 + this.getMaxPayloadSize();
                return result;
            }

            public String toString() {
                return "Scim2Properties.ServiceProviderConfigProperties.BulkConfigProperties(supported=" + this.isSupported() + ", maxOperations=" + this.getMaxOperations() + ", maxPayloadSize=" + this.getMaxPayloadSize() + ")";
            }

            public BulkConfigProperties() {
            }

            public BulkConfigProperties(boolean supported, int maxOperations, int maxPayloadSize) {
                this.supported = supported;
                this.maxOperations = maxOperations;
                this.maxPayloadSize = maxPayloadSize;
            }
        }

        public static class PatchConfigProperties {
            private boolean supported = false;

            public PatchConfig getPatchConfig() {
                return new PatchConfig(this.supported);
            }

            public boolean isSupported() {
                return this.supported;
            }

            public void setSupported(boolean supported) {
                this.supported = supported;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PatchConfigProperties)) {
                    return false;
                }
                PatchConfigProperties other = (PatchConfigProperties)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return this.isSupported() == other.isSupported();
            }

            protected boolean canEqual(Object other) {
                return other instanceof PatchConfigProperties;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isSupported() ? 79 : 97);
                return result;
            }

            public String toString() {
                return "Scim2Properties.ServiceProviderConfigProperties.PatchConfigProperties(supported=" + this.isSupported() + ")";
            }

            public PatchConfigProperties() {
            }

            public PatchConfigProperties(boolean supported) {
                this.supported = supported;
            }
        }
    }
}

