/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.scim2.server.controller;

import com.bettercloud.scim2.common.ScimResource;
import com.bettercloud.scim2.common.types.AttributeDefinition;
import com.bettercloud.scim2.server.ResourceTypeDefinition;
import com.bettercloud.scim2.server.config.Scim2Properties;
import com.bettercloud.scim2.server.converter.GenericScimResourceConverter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class BaseResourceController<RESOURCE extends ScimResource> {
    protected final ResourceTypeDefinition resourceTypeDefinition = ResourceTypeDefinition.fromScimResource(this.getClass());
    protected GenericScimResourceConverter<RESOURCE> genericScimResourceConverter;

    public BaseResourceController(Scim2Properties scim2Properties) {
        this.genericScimResourceConverter = new GenericScimResourceConverter(this.resourceTypeDefinition, scim2Properties.getBaseUrl());
    }

    protected Set<String> getValidSortPaths() {
        Set<String> validSorts = this.resourceTypeDefinition.getCoreSchema().getAttributes().stream().map(attributeDefinition -> this.getValidSortPaths(null, (AttributeDefinition)attributeDefinition)).flatMap(Collection::stream).collect(Collectors.toSet());
        validSorts.add("id");
        return validSorts;
    }

    private Set<String> getValidSortPaths(String string, AttributeDefinition attributeDefinition) {
        HashSet<String> results = new HashSet<String>();
        if (CollectionUtils.isEmpty((Collection)attributeDefinition.getSubAttributes())) {
            String basePath = StringUtils.isEmpty((Object)string) ? "" : string + ".";
            results.add(basePath + attributeDefinition.getName());
        } else {
            attributeDefinition.getSubAttributes().forEach(subAttribute -> results.addAll(this.getValidSortPaths(string, (AttributeDefinition)subAttribute)));
        }
        return results;
    }
}

