/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.scim2.server.controller.discovery;

import com.bettercloud.scim2.common.GenericScimResource;
import com.bettercloud.scim2.common.ScimResource;
import com.bettercloud.scim2.common.exceptions.ResourceNotFoundException;
import com.bettercloud.scim2.common.exceptions.ScimException;
import com.bettercloud.scim2.common.filters.Filter;
import com.bettercloud.scim2.common.filters.FilterVisitor;
import com.bettercloud.scim2.common.messages.ListResponse;
import com.bettercloud.scim2.server.ResourceTypeDefinition;
import com.bettercloud.scim2.server.config.Scim2Properties;
import com.bettercloud.scim2.server.controller.BaseResourceController;
import com.bettercloud.scim2.server.evaluator.SchemaAwareFilterEvaluator;
import com.google.common.base.Throwables;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

public abstract class SchemaAwareController
extends BaseResourceController<GenericScimResource> {
    private List<GenericScimResource> resources;
    private final SchemaAwareFilterEvaluator filterEvaluator;
    protected Set<ResourceTypeDefinition> resourceDefinitions;

    protected abstract List<GenericScimResource> getResources(Set<ResourceTypeDefinition> var1);

    @Autowired
    public SchemaAwareController(Scim2Properties scim2Properties, Set<ResourceTypeDefinition> resourceDefinitions) {
        super(scim2Properties);
        this.filterEvaluator = new SchemaAwareFilterEvaluator(this.resourceTypeDefinition);
        this.resourceDefinitions = resourceDefinitions;
        this.resources = this.getResources(resourceDefinitions);
    }

    @GetMapping
    public ListResponse<GenericScimResource> search(@RequestParam(value="filter", required=false) String filterString) throws ScimException {
        List<GenericScimResource> filteredResources = StringUtils.isEmpty((Object)filterString) ? this.resources : this.filterResources(Filter.fromString((String)filterString));
        List<GenericScimResource> preparedResources = this.genericScimResourceConverter.convert((String)null, (String)null, filteredResources);
        return new ListResponse(preparedResources.size(), preparedResources, Integer.valueOf(1), Integer.valueOf(preparedResources.size()));
    }

    @GetMapping(value={"/{id}"})
    public ScimResource get(@PathVariable(value="id") String id) throws ScimException {
        Filter filter = Filter.eq((String)"id", (String)id);
        return (ScimResource)this.filterResources(filter).stream().findFirst().orElseThrow(() -> new ResourceNotFoundException(id));
    }

    private List<GenericScimResource> filterResources(Filter filter) {
        return this.resources.stream().filter(genericScimResource -> {
            try {
                return (Boolean)filter.visit((FilterVisitor)this.filterEvaluator, (Object)genericScimResource.getObjectNode());
            }
            catch (ScimException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }).collect(Collectors.toList());
    }
}

