/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.scim2.server.controller.discovery;

import com.bettercloud.scim2.common.BaseScimResource;
import com.bettercloud.scim2.common.GenericScimResource;
import com.bettercloud.scim2.common.types.SchemaResource;
import com.bettercloud.scim2.server.ResourceTypeDefinition;
import com.bettercloud.scim2.server.annotation.ScimResource;
import com.bettercloud.scim2.server.config.Scim2Properties;
import com.bettercloud.scim2.server.controller.discovery.SchemaAwareController;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ScimResource(description="SCIM 2.0 Schema", name="Schema", schema=SchemaResource.class, discoverable=false)
@RestController
@RequestMapping(value={"/Schemas"})
public class SchemasController
extends SchemaAwareController {
    @Autowired
    public SchemasController(Scim2Properties scim2Properties, Set<ResourceTypeDefinition> resourceDefinitions) {
        super(scim2Properties, resourceDefinitions);
    }

    @Override
    protected List<GenericScimResource> getResources(Set<ResourceTypeDefinition> resourceDefinitions) {
        return resourceDefinitions.stream().filter(ResourceTypeDefinition::isDiscoverable).map(resourceTypeDefinition -> {
            if (resourceTypeDefinition.getCoreSchema() != null) {
                return Collections.singletonList(resourceTypeDefinition.getCoreSchema());
            }
            return resourceTypeDefinition.getSchemaExtensions().keySet();
        }).flatMap(Collection::stream).map(BaseScimResource::asGenericScimResource).collect(Collectors.toList());
    }
}

