/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.scim2.server.converter;

import com.bettercloud.scim2.common.GenericScimResource;
import com.bettercloud.scim2.common.ScimResource;
import com.bettercloud.scim2.common.exceptions.BadRequestException;
import com.bettercloud.scim2.common.types.Meta;
import com.bettercloud.scim2.server.ResourcePreparer;
import com.bettercloud.scim2.server.ResourceTypeDefinition;
import java.net.URI;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.UriComponentsBuilder;

public class GenericScimResourceConverter<RESOURCE extends ScimResource> {
    private final ResourceTypeDefinition resourceTypeDefinition;
    private final String baseUrl;

    public GenericScimResource convert(RESOURCE resource) throws BadRequestException {
        return this.convert(null, null, resource, (RESOURCE r, URI u) -> {});
    }

    public GenericScimResource convert(RESOURCE resource, BiConsumer<RESOURCE, URI> prepareResource) throws BadRequestException {
        return this.convert(null, null, resource, prepareResource);
    }

    public GenericScimResource convert(String attributes, String excludedAttributes, RESOURCE resource) throws BadRequestException {
        return this.convert(attributes, excludedAttributes, resource, (RESOURCE r, URI u) -> {});
    }

    public GenericScimResource convert(String attributes, String excludedAttributes, RESOURCE resource, BiConsumer<RESOURCE, URI> prepareResource) throws BadRequestException {
        ResourcePreparer<GenericScimResource> resourcePreparer = this.prepare(attributes, excludedAttributes);
        prepareResource.accept(resource, this.getBaseUri());
        GenericScimResource genericScimResource = resource.asGenericScimResource();
        if (genericScimResource.getMeta() == null) {
            genericScimResource.setMeta(new Meta());
        }
        genericScimResource.getMeta().setLocation(this.getLocationUri());
        resourcePreparer.setResourceTypeAndLocation(genericScimResource);
        return resourcePreparer.trimRetrievedResource(genericScimResource);
    }

    public List<GenericScimResource> convert(String attributes, String excludedAttributes, List<RESOURCE> resourceList) throws BadRequestException {
        return this.convert(attributes, excludedAttributes, resourceList, (RESOURCE r, URI u) -> {});
    }

    public List<GenericScimResource> convert(String attributes, String excludedAttributes, List<RESOURCE> resourceList, BiConsumer<RESOURCE, URI> prepareResource) throws BadRequestException {
        ResourcePreparer<GenericScimResource> resourcePreparer = this.prepare(attributes, excludedAttributes);
        return resourceList.stream().map(resource -> {
            prepareResource.accept(resource, this.getBaseUri());
            GenericScimResource genericScimResource = resource.asGenericScimResource();
            resourcePreparer.setResourceTypeAndLocation(genericScimResource);
            return resourcePreparer.trimRetrievedResource(genericScimResource);
        }).collect(Collectors.toList());
    }

    private ResourcePreparer<GenericScimResource> prepare(String attributes, String excludedAttributes) throws BadRequestException {
        return new ResourcePreparer<GenericScimResource>(this.resourceTypeDefinition, attributes, excludedAttributes, this.getLocationUri());
    }

    private URI getBaseUri() {
        return UriComponentsBuilder.fromHttpUrl((String)this.baseUrl).pathSegment(new String[]{this.getCurrentRequest().getContextPath()}).build().toUri();
    }

    private URI getLocationUri() {
        HttpServletRequest request = this.getCurrentRequest();
        return UriComponentsBuilder.fromHttpUrl((String)this.baseUrl).pathSegment(new String[]{request.getContextPath()}).pathSegment(new String[]{request.getServletPath()}).build().toUri();
    }

    private HttpServletRequest getCurrentRequest() {
        RequestAttributes attrs = RequestContextHolder.getRequestAttributes();
        Assert.state((boolean)(attrs instanceof ServletRequestAttributes), (String)"No current ServletRequestAttributes");
        return ((ServletRequestAttributes)attrs).getRequest();
    }

    public GenericScimResourceConverter(ResourceTypeDefinition resourceTypeDefinition, String baseUrl) {
        this.resourceTypeDefinition = resourceTypeDefinition;
        this.baseUrl = baseUrl;
    }
}

