/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.vault;

import com.bettercloud.vault.EnvironmentLoader;
import com.bettercloud.vault.SslConfig;
import com.bettercloud.vault.VaultException;
import java.io.Serializable;

public class VaultConfig
implements Serializable {
    protected static final String VAULT_TOKEN = "VAULT_TOKEN";
    private static final String VAULT_ADDR = "VAULT_ADDR";
    private static final String VAULT_OPEN_TIMEOUT = "VAULT_OPEN_TIMEOUT";
    private static final String VAULT_READ_TIMEOUT = "VAULT_READ_TIMEOUT";
    private String address;
    private String token;
    private SslConfig sslConfig;
    private Integer openTimeout;
    private Integer readTimeout;
    private int maxRetries;
    private int retryIntervalMilliseconds;
    private EnvironmentLoader environmentLoader;

    protected VaultConfig environmentLoader(EnvironmentLoader environmentLoader) {
        this.environmentLoader = environmentLoader;
        return this;
    }

    public VaultConfig address(String address) {
        this.address = address;
        return this;
    }

    public VaultConfig token(String token) {
        this.token = token;
        return this;
    }

    public VaultConfig sslConfig(SslConfig sslConfig) {
        this.sslConfig = sslConfig;
        return this;
    }

    public VaultConfig openTimeout(Integer openTimeout) {
        this.openTimeout = openTimeout;
        return this;
    }

    public VaultConfig readTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    protected void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    protected void setRetryIntervalMilliseconds(int retryIntervalMilliseconds) {
        this.retryIntervalMilliseconds = retryIntervalMilliseconds;
    }

    public VaultConfig build() throws VaultException {
        if (this.environmentLoader == null) {
            this.environmentLoader = new EnvironmentLoader();
        }
        if (this.address == null) {
            String addressFromEnv = this.environmentLoader.loadVariable(VAULT_ADDR);
            if (addressFromEnv != null) {
                this.address = addressFromEnv;
            } else {
                throw new VaultException("No address is set");
            }
        }
        if (this.token == null && this.environmentLoader.loadVariable(VAULT_TOKEN) != null) {
            this.token = this.environmentLoader.loadVariable(VAULT_TOKEN);
        }
        if (this.openTimeout == null && this.environmentLoader.loadVariable(VAULT_OPEN_TIMEOUT) != null) {
            try {
                this.openTimeout = Integer.valueOf(this.environmentLoader.loadVariable(VAULT_OPEN_TIMEOUT));
            }
            catch (NumberFormatException e) {
                System.err.printf("The VAULT_OPEN_TIMEOUT environment variable contains value \"%s\", which cannot be parsed as an integer timeout period.%n", this.environmentLoader.loadVariable(VAULT_OPEN_TIMEOUT));
            }
        }
        if (this.readTimeout == null && this.environmentLoader.loadVariable(VAULT_READ_TIMEOUT) != null) {
            try {
                this.readTimeout = Integer.valueOf(this.environmentLoader.loadVariable(VAULT_READ_TIMEOUT));
            }
            catch (NumberFormatException e) {
                System.err.printf("The VAULT_READ_TIMEOUT environment variable contains value \"%s\", which cannot be parsed as an integer timeout period.%n", this.environmentLoader.loadVariable(VAULT_READ_TIMEOUT));
            }
        }
        if (this.sslConfig == null) {
            this.sslConfig = new SslConfig().environmentLoader(this.environmentLoader).build();
        }
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public String getToken() {
        return this.token;
    }

    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    public Integer getOpenTimeout() {
        return this.openTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getRetryIntervalMilliseconds() {
        return this.retryIntervalMilliseconds;
    }
}

