/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.vault.api;

import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import com.bettercloud.vault.json.Json;
import com.bettercloud.vault.json.JsonObject;
import com.bettercloud.vault.response.AuthResponse;
import com.bettercloud.vault.response.LookupResponse;
import com.bettercloud.vault.rest.Rest;
import com.bettercloud.vault.rest.RestResponse;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Auth {
    private final VaultConfig config;

    public Auth(VaultConfig config) {
        this.config = config;
    }

    public AuthResponse createToken(TokenRequest tokenRequest) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                String mimeType;
                String url;
                RestResponse restResponse;
                JsonObject jsonObject = Json.object();
                if (tokenRequest.id != null) {
                    jsonObject.add("id", tokenRequest.id.toString());
                }
                if (tokenRequest.polices != null && !tokenRequest.polices.isEmpty()) {
                    jsonObject.add("policies", Json.array(tokenRequest.polices.toArray(new String[tokenRequest.polices.size()])));
                }
                if (tokenRequest.meta != null && !tokenRequest.meta.isEmpty()) {
                    JsonObject metaMap = Json.object();
                    for (Map.Entry entry : tokenRequest.meta.entrySet()) {
                        metaMap.add((String)entry.getKey(), (String)entry.getValue());
                    }
                    jsonObject.add("meta", metaMap);
                }
                if (tokenRequest.noParent != null) {
                    jsonObject.add("no_parent", tokenRequest.noParent);
                }
                if (tokenRequest.noDefaultPolicy != null) {
                    jsonObject.add("no_default_policy", tokenRequest.noDefaultPolicy);
                }
                if (tokenRequest.ttl != null) {
                    jsonObject.add("ttl", tokenRequest.ttl);
                }
                if (tokenRequest.displayName != null) {
                    jsonObject.add("display_name", tokenRequest.displayName);
                }
                if (tokenRequest.numUses != null) {
                    jsonObject.add("num_uses", tokenRequest.numUses);
                }
                String requestJson = jsonObject.toString();
                StringBuilder urlBuilder = new StringBuilder(this.config.getAddress()).append("/v1/auth/token/create");
                if (tokenRequest.role != null) {
                    urlBuilder.append("/").append(tokenRequest.role);
                }
                if ((restResponse = new Rest().url(url = urlBuilder.toString()).header("X-Vault-Token", this.config.getToken()).body(requestJson.getBytes("UTF-8")).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post()).getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
                if (!mimeType.equals("application/json")) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new AuthResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    @Deprecated
    public AuthResponse loginByAppID(String path, String appId, String userId) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                String mimeType;
                String requestJson = Json.object().add("app_id", appId).add("user_id", userId).toString();
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + path).body(requestJson.getBytes("UTF-8")).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
                if (!mimeType.equals("application/json")) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new AuthResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public AuthResponse loginByAppRole(String path, String roleId, String secretId) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                String mimeType;
                String requestJson = Json.object().add("role_id", roleId).add("secret_id", secretId).toString();
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + path + "/login").body(requestJson.getBytes("UTF-8")).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
                if (!mimeType.equals("application/json")) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new AuthResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public AuthResponse loginByUserPass(String username, String password) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                String mimeType;
                String requestJson = Json.object().add("password", password).toString();
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/userpass/login/" + username).body(requestJson.getBytes("UTF-8")).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
                if (!mimeType.equals("application/json")) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new AuthResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public AuthResponse loginByGithub(String githubToken) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                String mimeType;
                String requestJson = Json.object().add("token", githubToken).toString();
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/github/login").body(requestJson.getBytes("UTF-8")).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
                if (!mimeType.equals("application/json")) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new AuthResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public AuthResponse loginByCert() throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                String mimeType;
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/cert/login").connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
                if (!mimeType.equals("application/json")) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new AuthResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public AuthResponse renewSelf() throws VaultException {
        return this.renewSelf(-1L);
    }

    public AuthResponse renewSelf(long increment) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                String mimeType;
                String requestJson = Json.object().add("increment", increment).toString();
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/token/renew-self").header("X-Vault-Token", this.config.getToken()).body(increment < 0L ? null : requestJson.getBytes("UTF-8")).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
                if (!mimeType.equals("application/json")) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new AuthResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public LookupResponse lookupSelf() throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/token/lookup-self").header("X-Vault-Token", this.config.getToken()).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).get();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String mimeType = restResponse.getMimeType();
                if (mimeType == null || !"application/json".equals(mimeType)) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new LookupResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public static class TokenRequest
    implements Serializable {
        private UUID id;
        private List<String> polices;
        private Map<String, String> meta;
        private Boolean noParent;
        private Boolean noDefaultPolicy;
        private String ttl;
        private String displayName;
        private Long numUses;
        private String role;

        public TokenRequest id(UUID id) {
            this.id = id;
            return this;
        }

        public TokenRequest polices(List<String> polices) {
            this.polices = polices;
            return this;
        }

        public TokenRequest meta(Map<String, String> meta) {
            this.meta = meta;
            return this;
        }

        public TokenRequest noParent(Boolean noParent) {
            this.noParent = noParent;
            return this;
        }

        public TokenRequest noDefaultPolicy(Boolean noDefaultPolicy) {
            this.noDefaultPolicy = noDefaultPolicy;
            return this;
        }

        public TokenRequest ttl(String ttl) {
            this.ttl = ttl;
            return this;
        }

        public TokenRequest displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public TokenRequest numUses(Long numUses) {
            this.numUses = numUses;
            return this;
        }

        public TokenRequest role(String role) {
            this.role = role;
            return this;
        }

        public UUID getId() {
            return this.id;
        }

        public List<String> getPolices() {
            return this.polices;
        }

        public Map<String, String> getMeta() {
            return this.meta;
        }

        public Boolean getNoParent() {
            return this.noParent;
        }

        public Boolean getNoDefaultPolicy() {
            return this.noDefaultPolicy;
        }

        public String getTtl() {
            return this.ttl;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Long getNumUses() {
            return this.numUses;
        }

        public String getRole() {
            return this.role;
        }
    }
}

