/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.vault.api;

import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import com.bettercloud.vault.json.Json;
import com.bettercloud.vault.json.JsonArray;
import com.bettercloud.vault.json.JsonObject;
import com.bettercloud.vault.response.LogicalResponse;
import com.bettercloud.vault.rest.Rest;
import com.bettercloud.vault.rest.RestException;
import com.bettercloud.vault.rest.RestResponse;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Logical {
    private final VaultConfig config;

    public Logical(VaultConfig config) {
        this.config = config;
    }

    public LogicalResponse read(String path) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/" + path).header("X-Vault-Token", this.config.getToken()).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).get();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), "UTF-8"), restResponse.getStatus());
                }
                return new LogicalResponse(restResponse, retryCount);
            }
            catch (VaultException | RestException | UnsupportedEncodingException | RuntimeException e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public LogicalResponse write(String path, Map<String, Object> nameValuePairs) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                RestResponse restResponse;
                int restStatus;
                JsonObject requestJson = Json.object();
                if (nameValuePairs != null) {
                    for (Map.Entry<String, Object> pair : nameValuePairs.entrySet()) {
                        Object value = pair.getValue();
                        if (value == null) {
                            requestJson = requestJson.add(pair.getKey(), (String)null);
                            continue;
                        }
                        if (value instanceof Boolean) {
                            requestJson = requestJson.add(pair.getKey(), (Boolean)pair.getValue());
                            continue;
                        }
                        if (value instanceof Integer) {
                            requestJson = requestJson.add(pair.getKey(), (Integer)pair.getValue());
                            continue;
                        }
                        if (value instanceof Long) {
                            requestJson = requestJson.add(pair.getKey(), (Long)pair.getValue());
                            continue;
                        }
                        if (value instanceof Float) {
                            requestJson = requestJson.add(pair.getKey(), ((Float)pair.getValue()).floatValue());
                            continue;
                        }
                        if (value instanceof Double) {
                            requestJson = requestJson.add(pair.getKey(), (Double)pair.getValue());
                            continue;
                        }
                        requestJson = requestJson.add(pair.getKey(), pair.getValue().toString());
                    }
                }
                if ((restStatus = (restResponse = new Rest().url(this.config.getAddress() + "/v1/" + path).body(requestJson.toString().getBytes("UTF-8")).header("X-Vault-Token", this.config.getToken()).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post()).getStatus()) == 200 || restStatus == 204) {
                    return new LogicalResponse(restResponse, retryCount);
                }
                throw new VaultException("Expecting HTTP status 204 or 200, but instead receiving " + restStatus + "\nResponse body: " + new String(restResponse.getBody(), "UTF-8"), restStatus);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public List<String> list(String path) throws VaultException {
        LogicalResponse response;
        block4: {
            String fullPath = path == null ? "list=true" : path + "?list=true";
            response = null;
            try {
                response = this.read(fullPath);
            }
            catch (VaultException e) {
                if (e.getHttpStatusCode() == 404) break block4;
                throw e;
            }
        }
        ArrayList<String> returnValues = new ArrayList<String>();
        if (response != null && response.getRestResponse().getStatus() != 404 && response.getData() != null && response.getData().get("keys") != null) {
            JsonArray keys = Json.parse(response.getData().get("keys")).asArray();
            for (int index = 0; index < keys.size(); ++index) {
                returnValues.add(keys.get(index).asString());
            }
        }
        return returnValues;
    }

    public LogicalResponse delete(String path) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/" + path).header("X-Vault-Token", this.config.getToken()).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).delete();
                if (restResponse.getStatus() != 204) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + "\nResponse body: " + new String(restResponse.getBody(), "UTF-8"), restResponse.getStatus());
                }
                return new LogicalResponse(restResponse, retryCount);
            }
            catch (VaultException | RestException | UnsupportedEncodingException | RuntimeException e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }
}

