/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.vault.api.pki;

import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import com.bettercloud.vault.api.pki.CredentialFormat;
import com.bettercloud.vault.api.pki.RoleOptions;
import com.bettercloud.vault.json.Json;
import com.bettercloud.vault.json.JsonObject;
import com.bettercloud.vault.response.PkiResponse;
import com.bettercloud.vault.rest.Rest;
import com.bettercloud.vault.rest.RestResponse;
import java.util.List;

public class Pki {
    private final VaultConfig config;
    private final String mountPath;

    public Pki(VaultConfig config) {
        this.config = config;
        this.mountPath = "pki";
    }

    public Pki(VaultConfig config, String mountPath) {
        this.config = config;
        this.mountPath = mountPath;
    }

    public PkiResponse createOrUpdateRole(String roleName) throws VaultException {
        return this.createOrUpdateRole(roleName, null);
    }

    public PkiResponse createOrUpdateRole(String roleName, RoleOptions options) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                String requestJson = this.roleOptionsToJson(options);
                RestResponse restResponse = new Rest().url(String.format("%s/v1/%s/roles/%s", this.config.getAddress(), this.mountPath, roleName)).header("X-Vault-Token", this.config.getToken()).body(requestJson.getBytes("UTF-8")).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 204) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                return new PkiResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public PkiResponse getRole(String roleName) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                RestResponse restResponse = new Rest().url(String.format("%s/v1/%s/roles/%s", this.config.getAddress(), this.mountPath, roleName)).header("X-Vault-Token", this.config.getToken()).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).get();
                if (restResponse.getStatus() != 200 && restResponse.getStatus() != 404) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                return new PkiResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public PkiResponse deleteRole(String roleName) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                RestResponse restResponse = new Rest().url(String.format("%s/v1/%s/roles/%s", this.config.getAddress(), this.mountPath, roleName)).header("X-Vault-Token", this.config.getToken()).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).delete();
                if (restResponse.getStatus() != 204) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                return new PkiResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public PkiResponse issue(String roleName, String commonName, List<String> altNames, List<String> ipSans, String ttl, CredentialFormat format) throws VaultException {
        int retryCount = 0;
        while (true) {
            int index;
            JsonObject jsonObject = Json.object();
            if (commonName != null) {
                jsonObject.add("common_name", commonName);
            }
            if (altNames != null && !altNames.isEmpty()) {
                StringBuilder altNamesCsv = new StringBuilder();
                for (index = 0; index < altNames.size(); ++index) {
                    altNamesCsv.append(altNames.get(index));
                    if (index + 1 >= altNames.size()) continue;
                    altNamesCsv.append(',');
                }
                jsonObject.add("alt_names", altNamesCsv.toString());
            }
            if (ipSans != null && !ipSans.isEmpty()) {
                StringBuilder ipSansCsv = new StringBuilder();
                for (index = 0; index < ipSans.size(); ++index) {
                    ipSansCsv.append(ipSans.get(index));
                    if (index + 1 >= ipSans.size()) continue;
                    ipSansCsv.append(',');
                }
                jsonObject.add("ip_sans", ipSansCsv.toString());
            }
            if (ttl != null) {
                jsonObject.add("ttl", ttl);
            }
            if (format != null) {
                jsonObject.add("format", format.toString());
            }
            String requestJson = jsonObject.toString();
            try {
                RestResponse restResponse = new Rest().url(String.format("%s/v1/%s/issue/%s", this.config.getAddress(), this.mountPath, roleName)).header("X-Vault-Token", this.config.getToken()).body(requestJson.getBytes("UTF-8")).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 200 && restResponse.getStatus() != 404) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                return new PkiResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    private String roleOptionsToJson(RoleOptions options) {
        JsonObject jsonObject = Json.object();
        if (options != null) {
            this.addJsonFieldIfNotNull(jsonObject, "ttl", options.getTtl());
            this.addJsonFieldIfNotNull(jsonObject, "max_ttl", options.getMaxTtl());
            this.addJsonFieldIfNotNull(jsonObject, "allow_localhost", options.getAllowLocalhost());
            if (options.getAllowedDomains() != null && options.getAllowedDomains().size() > 0) {
                StringBuilder allowedDomains = new StringBuilder();
                for (int index = 0; index < options.getAllowedDomains().size(); ++index) {
                    allowedDomains.append(options.getAllowedDomains().get(index));
                    if (index + 1 >= options.getAllowedDomains().size()) continue;
                    allowedDomains.append(',');
                }
                this.addJsonFieldIfNotNull(jsonObject, "allowed_domains", allowedDomains.toString());
            }
            this.addJsonFieldIfNotNull(jsonObject, "allow_bare_domains", options.getAllowBareDomains());
            this.addJsonFieldIfNotNull(jsonObject, "allow_subdomains", options.getAllowSubdomains());
            this.addJsonFieldIfNotNull(jsonObject, "allow_any_name", options.getAllowAnyName());
            this.addJsonFieldIfNotNull(jsonObject, "enforce_hostnames", options.getEnforceHostnames());
            this.addJsonFieldIfNotNull(jsonObject, "allow_ip_sans", options.getAllowIpSans());
            this.addJsonFieldIfNotNull(jsonObject, "server_flag", options.getServerFlag());
            this.addJsonFieldIfNotNull(jsonObject, "client_flag", options.getClientFlag());
            this.addJsonFieldIfNotNull(jsonObject, "code_signing_flag", options.getCodeSigningFlag());
            this.addJsonFieldIfNotNull(jsonObject, "email_protection_flag", options.getEmailProtectionFlag());
            this.addJsonFieldIfNotNull(jsonObject, "key_type", options.getKeyType());
            this.addJsonFieldIfNotNull(jsonObject, "key_bits", options.getKeyBits());
            this.addJsonFieldIfNotNull(jsonObject, "use_csr_common_name", options.getUseCsrCommonName());
        }
        return jsonObject.toString();
    }

    private JsonObject addJsonFieldIfNotNull(JsonObject jsonObject, String name, Object value) {
        if (value == null) {
            return jsonObject;
        }
        if (value instanceof String) {
            jsonObject.add(name, (String)value);
        } else if (value instanceof Boolean) {
            jsonObject.add(name, (Boolean)value);
        } else if (value instanceof Long) {
            jsonObject.add(name, (Long)value);
        }
        return jsonObject;
    }
}

