/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.vault.api;

import com.bettercloud.vault.api.Logical;
import com.bettercloud.vault.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class LogicalUtilities {
    private static List<String> getPathSegments(String path) {
        ArrayList<String> segments = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(path, "/");
        while (tokenizer.hasMoreTokens()) {
            segments.add(tokenizer.nextToken());
        }
        return segments;
    }

    public static String addQualifierToPath(List<String> segments, String qualifier) {
        StringBuilder adjustedPath = new StringBuilder(segments.get(0)).append('/').append(qualifier).append('/');
        for (int index = 1; index < segments.size(); ++index) {
            adjustedPath.append(segments.get(index));
            if (index + 1 >= segments.size()) continue;
            adjustedPath.append('/');
        }
        return adjustedPath.toString();
    }

    public static String adjustPathForReadOrWrite(String path, Logical.logicalOperations operation) {
        List<String> pathSegments = LogicalUtilities.getPathSegments(path);
        if (operation.equals((Object)Logical.logicalOperations.readV2) || operation.equals((Object)Logical.logicalOperations.writeV2)) {
            StringBuilder adjustedPath = new StringBuilder(LogicalUtilities.addQualifierToPath(pathSegments, "data"));
            if (path.endsWith("/")) {
                adjustedPath.append("/");
            }
            return adjustedPath.toString();
        }
        return path;
    }

    public static String adjustPathForList(String path, Logical.logicalOperations operation) {
        List<String> pathSegments = LogicalUtilities.getPathSegments(path);
        StringBuilder adjustedPath = new StringBuilder();
        if (operation.equals((Object)Logical.logicalOperations.listV2)) {
            adjustedPath.append(LogicalUtilities.addQualifierToPath(pathSegments, "metadata"));
            if (path.endsWith("/")) {
                adjustedPath.append("/");
            }
        } else {
            adjustedPath.append(path);
        }
        adjustedPath.append("?list=true");
        return adjustedPath.toString();
    }

    public static String adjustPathForDelete(String path, Logical.logicalOperations operation) {
        List<String> pathSegments = LogicalUtilities.getPathSegments(path);
        if (operation.equals((Object)Logical.logicalOperations.deleteV2)) {
            StringBuilder adjustedPath = new StringBuilder(LogicalUtilities.addQualifierToPath(pathSegments, "metadata"));
            if (path.endsWith("/")) {
                adjustedPath.append("/");
            }
            return adjustedPath.toString();
        }
        return path;
    }

    public static String adjustPathForVersionDelete(String path) {
        List<String> pathSegments = LogicalUtilities.getPathSegments(path);
        StringBuilder adjustedPath = new StringBuilder(LogicalUtilities.addQualifierToPath(pathSegments, "delete"));
        if (path.endsWith("/")) {
            adjustedPath.append("/");
        }
        return adjustedPath.toString();
    }

    public static String adjustPathForVersionUnDelete(String path) {
        List<String> pathSegments = LogicalUtilities.getPathSegments(path);
        StringBuilder adjustedPath = new StringBuilder(LogicalUtilities.addQualifierToPath(pathSegments, "undelete"));
        if (path.endsWith("/")) {
            adjustedPath.append("/");
        }
        return adjustedPath.toString();
    }

    public static String adjustPathForVersionDestroy(String path) {
        List<String> pathSegments = LogicalUtilities.getPathSegments(path);
        StringBuilder adjustedPath = new StringBuilder(LogicalUtilities.addQualifierToPath(pathSegments, "destroy"));
        if (path.endsWith("/")) {
            adjustedPath.append("/");
        }
        return adjustedPath.toString();
    }

    public static JsonObject jsonObjectToWriteFromEngineVersion(Logical.logicalOperations operation, JsonObject jsonObject) {
        if (operation.equals((Object)Logical.logicalOperations.writeV2)) {
            JsonObject wrappedJson = new JsonObject();
            wrappedJson.add("data", jsonObject);
            return wrappedJson;
        }
        return jsonObject;
    }
}

