/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.vault.api;

import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import com.bettercloud.vault.api.Logical;
import com.bettercloud.vault.json.Json;
import com.bettercloud.vault.json.JsonObject;
import com.bettercloud.vault.response.AuthResponse;
import com.bettercloud.vault.response.LogicalResponse;
import com.bettercloud.vault.response.LookupResponse;
import com.bettercloud.vault.rest.Rest;
import com.bettercloud.vault.rest.RestResponse;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Auth {
    private final VaultConfig config;
    private String nameSpace;

    public Auth(VaultConfig config) {
        this.config = config;
        if (this.config.getNameSpace() != null && !this.config.getNameSpace().isEmpty()) {
            this.nameSpace = this.config.getNameSpace();
        }
    }

    public Auth withNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
        return this;
    }

    public AuthResponse createToken(TokenRequest tokenRequest) throws VaultException {
        return this.createToken(tokenRequest, "token");
    }

    public AuthResponse createToken(TokenRequest tokenRequest, String tokenAuthMount) throws VaultException {
        int retryCount = 0;
        String mount = tokenAuthMount != null ? tokenAuthMount : "token";
        while (true) {
            try {
                String mimeType;
                String url;
                RestResponse restResponse;
                JsonObject jsonObject = Json.object();
                if (tokenRequest.id != null) {
                    jsonObject.add("id", tokenRequest.id.toString());
                }
                if (tokenRequest.polices != null && !tokenRequest.polices.isEmpty()) {
                    jsonObject.add("policies", Json.array(tokenRequest.polices.toArray(new String[tokenRequest.polices.size()])));
                }
                if (tokenRequest.meta != null && !tokenRequest.meta.isEmpty()) {
                    JsonObject metaMap = Json.object();
                    for (Map.Entry entry : tokenRequest.meta.entrySet()) {
                        metaMap.add((String)entry.getKey(), (String)entry.getValue());
                    }
                    jsonObject.add("meta", metaMap);
                }
                if (tokenRequest.noParent != null) {
                    jsonObject.add("no_parent", tokenRequest.noParent);
                }
                if (tokenRequest.noDefaultPolicy != null) {
                    jsonObject.add("no_default_policy", tokenRequest.noDefaultPolicy);
                }
                if (tokenRequest.ttl != null) {
                    jsonObject.add("ttl", tokenRequest.ttl);
                }
                if (tokenRequest.displayName != null) {
                    jsonObject.add("display_name", tokenRequest.displayName);
                }
                if (tokenRequest.numUses != null) {
                    jsonObject.add("num_uses", tokenRequest.numUses);
                }
                String requestJson = jsonObject.toString();
                StringBuilder urlBuilder = new StringBuilder(this.config.getAddress()).append("/v1/auth/" + mount + "/create");
                if (tokenRequest.role != null) {
                    urlBuilder.append("/").append(tokenRequest.role);
                }
                if ((restResponse = new Rest().url(url = urlBuilder.toString()).header("X-Vault-Token", this.config.getToken()).optionalHeader("X-Vault-Namespace", this.nameSpace).body(requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post()).getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
                if (!mimeType.equals("application/json")) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new AuthResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    @Deprecated
    public AuthResponse loginByAppID(String path, String appId, String userId) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                String mimeType;
                String requestJson = Json.object().add("app_id", appId).add("user_id", userId).toString();
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + path).optionalHeader("X-Vault-Namespace", this.nameSpace).body(requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
                if (!mimeType.equals("application/json")) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new AuthResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public AuthResponse loginByAppRole(String roleId, String secretId) throws VaultException {
        return this.loginByAppRole("approle", roleId, secretId);
    }

    public AuthResponse loginByAppRole(String path, String roleId, String secretId) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                String mimeType;
                String requestJson = Json.object().add("role_id", roleId).add("secret_id", secretId).toString();
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + path + "/login").optionalHeader("X-Vault-Namespace", this.nameSpace).body(requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
                if (!mimeType.equals("application/json")) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new AuthResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public AuthResponse loginByUserPass(String username, String password) throws VaultException {
        return this.loginByUserPass(username, password, "userpass");
    }

    public AuthResponse loginByUserPass(String username, String password, String userpassAuthMount) throws VaultException {
        int retryCount = 0;
        String mount = userpassAuthMount != null ? userpassAuthMount : "userpass";
        while (true) {
            try {
                String mimeType;
                String requestJson = Json.object().add("password", password).toString();
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + mount + "/login/" + username).optionalHeader("X-Vault-Namespace", this.nameSpace).body(requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
                if (!mimeType.equals("application/json")) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new AuthResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public AuthResponse loginByLDAP(String username, String password) throws VaultException {
        return this.loginByLDAP(username, password, "ldap");
    }

    public AuthResponse loginByLDAP(String username, String password, String ldapAuthMount) throws VaultException {
        String mount = ldapAuthMount != null ? ldapAuthMount : "ldap";
        return this.loginByUserPass(username, password, mount);
    }

    public AuthResponse loginByAwsEc2(String role, String identity, String signature, String nonce, String awsAuthMount) throws VaultException {
        int retryCount = 0;
        String mount = awsAuthMount != null ? awsAuthMount : "aws";
        while (true) {
            try {
                String mimeType;
                JsonObject request = Json.object().add("identity", identity).add("signature", signature);
                if (role != null) {
                    request.add("role", role);
                }
                if (nonce != null) {
                    request.add("nonce", nonce);
                }
                String requestJson = request.toString();
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + mount + "/login").body(requestJson.getBytes(StandardCharsets.UTF_8)).optionalHeader("X-Vault-Namespace", this.nameSpace).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
                if (!mimeType.equals("application/json")) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new AuthResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public AuthResponse loginByAwsEc2(String role, String pkcs7, String nonce, String awsAuthMount) throws VaultException {
        int retryCount = 0;
        String mount = awsAuthMount != null ? awsAuthMount : "aws";
        while (true) {
            try {
                String mimeType;
                JsonObject request = Json.object().add("pkcs7", pkcs7);
                if (role != null) {
                    request.add("role", role);
                }
                if (nonce != null) {
                    request.add("nonce", nonce);
                }
                String requestJson = request.toString();
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + mount + "/login").optionalHeader("X-Vault-Namespace", this.nameSpace).body(requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
                if (!mimeType.equals("application/json")) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new AuthResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public AuthResponse loginByAwsIam(String role, String iamRequestUrl, String iamRequestBody, String iamRequestHeaders, String awsAuthMount) throws VaultException {
        int retryCount = 0;
        String mount = awsAuthMount != null ? awsAuthMount : "aws";
        while (true) {
            try {
                String mimeType;
                JsonObject request = Json.object().add("iam_request_url", iamRequestUrl).add("iam_request_body", iamRequestBody).add("iam_request_headers", iamRequestHeaders).add("iam_http_request_method", "POST");
                if (role != null) {
                    request.add("role", role);
                }
                String requestJson = request.toString();
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + mount + "/login").optionalHeader("X-Vault-Namespace", this.nameSpace).body(requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
                if (!mimeType.equals("application/json")) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new AuthResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public AuthResponse loginByGithub(String githubToken) throws VaultException {
        return this.loginByGithub(githubToken, "github");
    }

    public AuthResponse loginByGithub(String githubToken, String githubAuthMount) throws VaultException {
        int retryCount = 0;
        String mount = githubAuthMount != null ? githubAuthMount : "github";
        while (true) {
            try {
                String mimeType;
                String requestJson = Json.object().add("token", githubToken).toString();
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + mount + "/login").optionalHeader("X-Vault-Namespace", this.nameSpace).body(requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
                if (!mimeType.equals("application/json")) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new AuthResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public AuthResponse loginByJwt(String provider, String role, String jwt) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                String mimeType;
                String requestJson = Json.object().add("role", role).add("jwt", jwt).toString();
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + provider + "/login").optionalHeader("X-Vault-Namespace", this.nameSpace).body(requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
                if (!mimeType.equals("application/json")) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new AuthResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public AuthResponse loginByGCP(String role, String jwt) throws VaultException {
        return this.loginByJwt("gcp", role, jwt);
    }

    public AuthResponse loginByKubernetes(String role, String jwt) throws VaultException {
        return this.loginByJwt("kubernetes", role, jwt);
    }

    public AuthResponse loginByCert() throws VaultException {
        return this.loginByCert("cert");
    }

    public AuthResponse loginByCert(String certAuthMount) throws VaultException {
        int retryCount = 0;
        String mount = certAuthMount != null ? certAuthMount : "cert";
        while (true) {
            try {
                String mimeType;
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + mount + "/login").optionalHeader("X-Vault-Namespace", this.nameSpace).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
                if (!mimeType.equals("application/json")) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new AuthResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public AuthResponse renewSelf() throws VaultException {
        return this.renewSelf(-1L);
    }

    public AuthResponse renewSelf(long increment) throws VaultException {
        return this.renewSelf(increment, "token");
    }

    public AuthResponse renewSelf(long increment, String tokenAuthMount) throws VaultException {
        int retryCount = 0;
        String mount = tokenAuthMount != null ? tokenAuthMount : "token";
        while (true) {
            try {
                String mimeType;
                String requestJson = Json.object().add("increment", increment).toString();
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + mount + "/renew-self").header("X-Vault-Token", this.config.getToken()).optionalHeader("X-Vault-Namespace", this.nameSpace).body(increment < 0L ? null : requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
                if (!mimeType.equals("application/json")) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new AuthResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public LookupResponse lookupSelf() throws VaultException {
        return this.lookupSelf("token");
    }

    public LookupResponse lookupSelf(String tokenAuthMount) throws VaultException {
        int retryCount = 0;
        String mount = tokenAuthMount != null ? tokenAuthMount : "token";
        while (true) {
            try {
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + mount + "/lookup-self").header("X-Vault-Token", this.config.getToken()).optionalHeader("X-Vault-Namespace", this.nameSpace).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).get();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String mimeType = restResponse.getMimeType();
                if (mimeType == null || !"application/json".equals(mimeType)) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new LookupResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public LogicalResponse lookupWrap() throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/sys/wrapping/lookup").header("X-Vault-Token", this.config.getToken()).optionalHeader("X-Vault-Namespace", this.nameSpace).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).get();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String mimeType = restResponse.getMimeType();
                if (mimeType == null || !"application/json".equals(mimeType)) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new LogicalResponse(restResponse, retryCount, Logical.logicalOperations.authentication);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public void revokeSelf() throws VaultException {
        this.revokeSelf("token");
    }

    public void revokeSelf(String tokenAuthMount) throws VaultException {
        int retryCount = 0;
        String mount = tokenAuthMount != null ? tokenAuthMount : "token";
        while (true) {
            try {
                RestResponse restResponse = new Rest().url(this.config.getAddress() + "/v1/auth/" + mount + "/revoke-self").header("X-Vault-Token", this.config.getToken()).optionalHeader("X-Vault-Namespace", this.nameSpace).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 204) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                return;
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public AuthResponse unwrap() throws VaultException {
        return this.unwrap(null);
    }

    public AuthResponse unwrap(String wrappedToken) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                String mimeType;
                JsonObject jsonObject = Json.object();
                if (wrappedToken != null) {
                    jsonObject.add("token", wrappedToken);
                }
                String requestJson = jsonObject.toString();
                String url = this.config.getAddress() + "/v1/sys/wrapping/unwrap";
                RestResponse restResponse = new Rest().url(url).header("X-Vault-Token", this.config.getToken()).optionalHeader("X-Vault-Namespace", this.nameSpace).body(requestJson.getBytes(StandardCharsets.UTF_8)).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 200) {
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus(), restResponse.getStatus());
                }
                String string = mimeType = restResponse.getMimeType() == null ? "null" : restResponse.getMimeType();
                if (!mimeType.equals("application/json")) {
                    throw new VaultException("Vault responded with MIME type: " + mimeType, restResponse.getStatus());
                }
                return new AuthResponse(restResponse, retryCount);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public static class TokenRequest
    implements Serializable {
        private UUID id;
        private List<String> polices;
        private Map<String, String> meta;
        private Boolean noParent;
        private Boolean noDefaultPolicy;
        private String ttl;
        private String displayName;
        private Long numUses;
        private String role;

        public TokenRequest id(UUID id) {
            this.id = id;
            return this;
        }

        public TokenRequest polices(List<String> polices) {
            this.polices = polices;
            return this;
        }

        public TokenRequest meta(Map<String, String> meta) {
            this.meta = meta;
            return this;
        }

        public TokenRequest noParent(Boolean noParent) {
            this.noParent = noParent;
            return this;
        }

        public TokenRequest noDefaultPolicy(Boolean noDefaultPolicy) {
            this.noDefaultPolicy = noDefaultPolicy;
            return this;
        }

        public TokenRequest ttl(String ttl) {
            this.ttl = ttl;
            return this;
        }

        public TokenRequest displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public TokenRequest numUses(Long numUses) {
            this.numUses = numUses;
            return this;
        }

        public TokenRequest role(String role) {
            this.role = role;
            return this;
        }

        public UUID getId() {
            return this.id;
        }

        public List<String> getPolices() {
            return this.polices;
        }

        public Map<String, String> getMeta() {
            return this.meta;
        }

        public Boolean getNoParent() {
            return this.noParent;
        }

        public Boolean getNoDefaultPolicy() {
            return this.noDefaultPolicy;
        }

        public String getTtl() {
            return this.ttl;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Long getNumUses() {
            return this.numUses;
        }

        public String getRole() {
            return this.role;
        }
    }
}

