/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.vault.api.mounts;

import java.util.Arrays;
import java.util.function.Predicate;

public enum MountType {
    AWS("aws"),
    CONSUL("consul"),
    CUBBYHOLE("cubbyhole"),
    DATABASE("database"),
    KEY_VALUE("kv"),
    IDENTITY("identity"),
    NOMAD("nomad"),
    PKI("pki"),
    RABBITMQ("rabbitmq"),
    SSH("ssh"),
    SYSTEM("system"),
    TOTP("totp"),
    TRANSIT("transit");

    private final String value;

    private MountType(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public static MountType of(final String value) {
        if (value == null) {
            return null;
        }
        return Arrays.asList(MountType.values()).stream().filter(new Predicate<MountType>(){

            @Override
            public boolean test(MountType type) {
                return type.value.equals(value);
            }
        }).findFirst().orElse(null);
    }
}

