/*
 * Decompiled with CFR 0.152.
 */
package com.bettercloud.vault.api.mounts;

import com.bettercloud.vault.VaultConfig;
import com.bettercloud.vault.VaultException;
import com.bettercloud.vault.api.mounts.MountPayload;
import com.bettercloud.vault.api.mounts.MountType;
import com.bettercloud.vault.response.MountResponse;
import com.bettercloud.vault.rest.Rest;
import com.bettercloud.vault.rest.RestResponse;

public class Mounts {
    private final VaultConfig config;

    public Mounts(VaultConfig config) {
        this.config = config;
    }

    public MountResponse list() throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                RestResponse restResponse = new Rest().url(String.format("%s/v1/sys/mounts", this.config.getAddress())).header("X-Vault-Token", this.config.getToken()).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).get();
                if (restResponse.getStatus() != 200) {
                    String body = restResponse.getBody() != null ? new String(restResponse.getBody()) : "(no body)";
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + " " + body, restResponse.getStatus());
                }
                return new MountResponse(restResponse, retryCount, true);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public MountResponse enable(String path, MountType type, MountPayload payload) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                if (type == null) {
                    throw new VaultException("Mount type is missing");
                }
                if (payload == null) {
                    throw new VaultException("MountPayload is missing");
                }
                String requestJson = payload.toEnableJson(type).toString();
                RestResponse restResponse = new Rest().url(String.format("%s/v1/sys/mounts/%s", this.config.getAddress(), path)).header("X-Vault-Token", this.config.getToken()).body(requestJson.getBytes("UTF-8")).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 204) {
                    String body = restResponse.getBody() != null ? new String(restResponse.getBody()) : "(no body)";
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + " " + body, restResponse.getStatus());
                }
                return new MountResponse(restResponse, retryCount, false);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public MountResponse disable(String path) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                RestResponse restResponse = new Rest().url(String.format("%s/v1/sys/mounts/%s", this.config.getAddress(), path)).header("X-Vault-Token", this.config.getToken()).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).delete();
                if (restResponse.getStatus() != 204) {
                    String body = restResponse.getBody() != null ? new String(restResponse.getBody()) : "(no body)";
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + " " + body, restResponse.getStatus());
                }
                return new MountResponse(restResponse, retryCount, false);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public MountResponse read(String path) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                RestResponse restResponse = new Rest().url(String.format("%s/v1/sys/mounts/%s/tune", this.config.getAddress(), path)).header("X-Vault-Token", this.config.getToken()).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).get();
                if (restResponse.getStatus() != 200 && restResponse.getStatus() != 404) {
                    String body = restResponse.getBody() != null ? new String(restResponse.getBody()) : "(no body)";
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + " " + body, restResponse.getStatus());
                }
                return new MountResponse(restResponse, retryCount, false);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }

    public MountResponse tune(String path, MountPayload payload) throws VaultException {
        int retryCount = 0;
        while (true) {
            try {
                if (payload == null) {
                    throw new VaultException("MountPayload is missing");
                }
                String requestJson = payload.toTuneJson().toString();
                RestResponse restResponse = new Rest().url(String.format("%s/v1/sys/mounts/%s/tune", this.config.getAddress(), path)).header("X-Vault-Token", this.config.getToken()).body(requestJson.getBytes("UTF-8")).connectTimeoutSeconds(this.config.getOpenTimeout()).readTimeoutSeconds(this.config.getReadTimeout()).sslVerification(this.config.getSslConfig().isVerify()).sslContext(this.config.getSslConfig().getSslContext()).post();
                if (restResponse.getStatus() != 204) {
                    String body = restResponse.getBody() != null ? new String(restResponse.getBody()) : "(no body)";
                    throw new VaultException("Vault responded with HTTP status code: " + restResponse.getStatus() + " " + body, restResponse.getStatus());
                }
                return new MountResponse(restResponse, retryCount, false);
            }
            catch (Exception e) {
                if (retryCount < this.config.getMaxRetries()) {
                    ++retryCount;
                    try {
                        int retryIntervalMilliseconds = this.config.getRetryIntervalMilliseconds();
                        Thread.sleep(retryIntervalMilliseconds);
                    }
                    catch (InterruptedException e1) {
                        e1.printStackTrace();
                    }
                    continue;
                }
                if (e instanceof VaultException) {
                    throw (VaultException)e;
                }
                throw new VaultException(e);
            }
            break;
        }
    }
}

