/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander.defaultprovider;

import com.beust.jcommander.IDefaultProvider;
import com.beust.jcommander.ParameterException;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;

public class PropertyFileDefaultProvider
implements IDefaultProvider {
    public static final String DEFAULT_FILE_NAME = "jcommander.properties";
    private Properties m_properties;

    public PropertyFileDefaultProvider() {
        this.init(DEFAULT_FILE_NAME);
    }

    public PropertyFileDefaultProvider(String string) {
        this.init(string);
    }

    private void init(String string) {
        try {
            this.m_properties = new Properties();
            URL uRL = ClassLoader.getSystemResource(string);
            if (uRL == null) {
                throw new ParameterException("Could not find property file: " + string + " on the class path");
            }
            this.m_properties.load(uRL.openStream());
        }
        catch (IOException iOException) {
            throw new ParameterException("Could not open property file: " + string);
        }
    }

    @Override
    public String getDefaultValueFor(String string) {
        int n;
        for (n = 0; n < string.length() && !Character.isLetterOrDigit(string.charAt(n)); ++n) {
        }
        String string2 = string.substring(n);
        return this.m_properties.getProperty(string2);
    }
}

