/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander;

import com.beust.jcommander.DynamicParameter;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.ParametersDelegate;
import com.beust.jcommander.WrappedParameter;
import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Sets;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class Parameterized {
    private Field m_field;
    private Method m_method;
    private Method m_getter;
    private WrappedParameter m_wrappedParameter;
    private ParametersDelegate m_parametersDelegate;

    public Parameterized(WrappedParameter wrappedParameter, ParametersDelegate parametersDelegate, Field field, Method method) {
        this.m_wrappedParameter = wrappedParameter;
        this.m_method = method;
        this.m_field = field;
        if (this.m_field != null) {
            Parameterized.setFieldAccessible(this.m_field);
        }
        this.m_parametersDelegate = parametersDelegate;
    }

    private static void describeClassTree(Class<?> clazz, Set<Class<?>> set) {
        if (clazz == null) {
            return;
        }
        if (Object.class.equals(clazz) || set.contains(clazz)) {
            return;
        }
        set.add(clazz);
        Parameterized.describeClassTree(clazz.getSuperclass(), set);
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            Parameterized.describeClassTree(clazz2, set);
        }
    }

    private static Set<Class<?>> describeClassTree(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptySet();
        }
        Set<Class<?>> set = Sets.newLinkedHashSet();
        Parameterized.describeClassTree(clazz, set);
        return set;
    }

    public static List<Parameterized> parseArg(Object object) {
        List<Parameterized> list = Lists.newArrayList();
        Class<?> clazz = object.getClass();
        Set<Class<?>> set = Parameterized.describeClassTree(clazz);
        for (Class<?> clazz2 : set) {
            DynamicParameter dynamicParameter;
            ParametersDelegate parametersDelegate;
            Parameter parameter;
            for (Field field : clazz2.getDeclaredFields()) {
                parameter = field.getAnnotation(Parameter.class);
                parametersDelegate = field.getAnnotation(ParametersDelegate.class);
                dynamicParameter = field.getAnnotation(DynamicParameter.class);
                if (parameter != null) {
                    list.add(new Parameterized(new WrappedParameter(parameter), null, field, null));
                    continue;
                }
                if (dynamicParameter != null) {
                    list.add(new Parameterized(new WrappedParameter(dynamicParameter), null, field, null));
                    continue;
                }
                if (parametersDelegate == null) continue;
                list.add(new Parameterized(null, parametersDelegate, field, null));
            }
            for (AccessibleObject accessibleObject : clazz2.getDeclaredMethods()) {
                ((Method)accessibleObject).setAccessible(true);
                parameter = ((Method)accessibleObject).getAnnotation(Parameter.class);
                parametersDelegate = ((Method)accessibleObject).getAnnotation(ParametersDelegate.class);
                dynamicParameter = ((Method)accessibleObject).getAnnotation(DynamicParameter.class);
                if (parameter != null) {
                    list.add(new Parameterized(new WrappedParameter(parameter), null, null, (Method)accessibleObject));
                    continue;
                }
                if (dynamicParameter != null) {
                    list.add(new Parameterized(new WrappedParameter(dynamicParameter), null, null, (Method)accessibleObject));
                    continue;
                }
                if (parametersDelegate == null) continue;
                list.add(new Parameterized(null, parametersDelegate, null, (Method)accessibleObject));
            }
        }
        return list;
    }

    public WrappedParameter getWrappedParameter() {
        return this.m_wrappedParameter;
    }

    public Class<?> getType() {
        if (this.m_method != null) {
            return this.m_method.getParameterTypes()[0];
        }
        return this.m_field.getType();
    }

    public String getName() {
        if (this.m_method != null) {
            return this.m_method.getName();
        }
        return this.m_field.getName();
    }

    public Object get(Object object) {
        try {
            if (this.m_method != null) {
                if (this.m_getter == null) {
                    this.m_getter = this.m_method.getDeclaringClass().getMethod("g" + this.m_method.getName().substring(1), new Class[0]);
                }
                return this.m_getter.invoke(object, new Object[0]);
            }
            return this.m_field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
            throw new ParameterException(exception);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            String string = this.m_method.getName();
            String string2 = Character.toLowerCase(string.charAt(3)) + string.substring(4);
            Object object2 = null;
            try {
                Field field = this.m_method.getDeclaringClass().getDeclaredField(string2);
                if (field != null) {
                    Parameterized.setFieldAccessible(field);
                    object2 = field.get(object);
                }
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
            return object2;
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.m_field == null ? 0 : this.m_field.hashCode());
        n = 31 * n + (this.m_method == null ? 0 : this.m_method.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Parameterized parameterized = (Parameterized)object;
        if (this.m_field == null ? parameterized.m_field != null : !this.m_field.equals(parameterized.m_field)) {
            return false;
        }
        return !(this.m_method == null ? parameterized.m_method != null : !this.m_method.equals(parameterized.m_method));
    }

    public boolean isDynamicParameter(Field field) {
        if (this.m_method != null) {
            return this.m_method.getAnnotation(DynamicParameter.class) != null;
        }
        return this.m_field.getAnnotation(DynamicParameter.class) != null;
    }

    private static void setFieldAccessible(Field field) {
        if (Modifier.isFinal(field.getModifiers())) {
            throw new ParameterException("Cannot use final field " + field.getDeclaringClass().getName() + "#" + field.getName() + " as a parameter; compile-time constant inlining may hide new values written to it.");
        }
        field.setAccessible(true);
    }

    private static String errorMessage(Method method, Exception exception) {
        return "Could not invoke " + method + "\n    Reason: " + exception.getMessage();
    }

    public void set(Object object, Object object2) {
        try {
            if (this.m_method != null) {
                this.m_method.invoke(object, object2);
            } else {
                this.m_field.set(object, object2);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            throw new ParameterException(Parameterized.errorMessage(this.m_method, exception));
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof ParameterException) {
                throw (ParameterException)invocationTargetException.getTargetException();
            }
            throw new ParameterException(Parameterized.errorMessage(this.m_method, invocationTargetException));
        }
    }

    public ParametersDelegate getDelegateAnnotation() {
        return this.m_parametersDelegate;
    }

    public Type getGenericType() {
        if (this.m_method != null) {
            return this.m_method.getGenericParameterTypes()[0];
        }
        return this.m_field.getGenericType();
    }

    public Parameter getParameter() {
        return this.m_wrappedParameter.getParameter();
    }

    public Type findFieldGenericType() {
        ParameterizedType parameterizedType;
        Type type;
        if (this.m_method != null) {
            return null;
        }
        if (this.m_field.getGenericType() instanceof ParameterizedType && (type = (parameterizedType = (ParameterizedType)this.m_field.getGenericType()).getActualTypeArguments()[0]) instanceof Class) {
            return type;
        }
        return null;
    }

    public boolean isDynamicParameter() {
        return this.m_wrappedParameter.getDynamicParameter() != null;
    }
}

