/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.helper.StringHelpers;
import com.github.kongchen.swagger.docgen.EnhancedSwaggerModule;
import com.github.kongchen.swagger.docgen.GenerateException;
import com.github.kongchen.swagger.docgen.Output;
import com.github.kongchen.swagger.docgen.PropertyExampleMixIn;
import com.github.kongchen.swagger.docgen.TemplatePath;
import com.github.kongchen.swagger.docgen.Utils;
import com.github.kongchen.swagger.docgen.mavenplugin.ApiSource;
import com.github.kongchen.swagger.docgen.mavenplugin.SecurityDefinition;
import com.github.kongchen.swagger.docgen.reader.AbstractReader;
import com.github.kongchen.swagger.docgen.reader.ClassSwaggerReader;
import com.github.kongchen.swagger.docgen.reader.ModelModifier;
import io.swagger.annotations.Api;
import io.swagger.config.FilterFactory;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverters;
import io.swagger.core.filter.SpecFilter;
import io.swagger.core.filter.SwaggerSpecFilter;
import io.swagger.jaxrs.ext.SwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtensions;
import io.swagger.models.Path;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.properties.Property;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public abstract class AbstractDocumentSource<D extends AbstractReader> {
    protected final ApiSource apiSource;
    protected final Log LOG;
    protected final List<Type> typesToSkip = new ArrayList<Type>();
    protected Swagger swagger;
    protected String swaggerSchemaConverter;
    private final String outputPath;
    private final String templatePath;
    private final String swaggerPath;
    private final String modelSubstitute;
    private final boolean jsonExampleValues;
    private ObjectMapper mapper = Json.mapper();
    private boolean isSorted = false;
    protected String encoding = "UTF-8";

    public AbstractDocumentSource(Log log, ApiSource apiSource, String encoding) throws MojoFailureException {
        this.LOG = log;
        this.outputPath = apiSource.getOutputPath();
        this.templatePath = apiSource.getTemplatePath();
        this.swaggerPath = apiSource.getSwaggerDirectory();
        this.modelSubstitute = apiSource.getModelSubstitute();
        this.jsonExampleValues = apiSource.isJsonExampleValues();
        this.swagger = new Swagger();
        if (apiSource.getSchemes() != null) {
            for (String scheme : apiSource.getSchemes()) {
                this.swagger.scheme(Scheme.forValue((String)scheme));
            }
        }
        if (apiSource.getDescriptionFile() != null) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(apiSource.getDescriptionFile());
                apiSource.getInfo().setDescription(IOUtils.toString((InputStream)is));
            }
            catch (IOException e) {
                try {
                    throw new MojoFailureException(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        this.swagger.setHost(apiSource.getHost());
        this.swagger.setInfo(apiSource.getInfo());
        this.swagger.setBasePath(apiSource.getBasePath());
        this.swagger.setExternalDocs(apiSource.getExternalDocs());
        this.apiSource = apiSource;
        if (encoding != null) {
            this.encoding = encoding;
        }
    }

    public void loadDocuments() throws GenerateException {
        ClassSwaggerReader reader = this.resolveApiReader();
        this.loadSwaggerExtensions(this.apiSource);
        this.swagger = reader.read(this.getValidClasses());
        this.swagger = this.removeBasePathFromEndpoints(this.swagger, this.apiSource.getRemoveBasePathFromEndpoints());
        this.swagger = this.addSecurityDefinitions(this.swagger, this.apiSource);
        this.swagger = this.doFilter(this.swagger);
    }

    private Swagger doFilter(Swagger swagger) throws GenerateException {
        SwaggerSpecFilter filter;
        String filterClassName = this.apiSource.getSwaggerInternalFilter();
        if (filterClassName != null) {
            try {
                this.LOG.debug((CharSequence)String.format("Setting filter configuration: %s", filterClassName));
                FilterFactory.setFilter((SwaggerSpecFilter)((SwaggerSpecFilter)Class.forName(filterClassName).newInstance()));
            }
            catch (Exception e) {
                throw new GenerateException("Cannot load: " + filterClassName, e);
            }
        }
        if ((filter = FilterFactory.getFilter()) == null) {
            return swagger;
        }
        return new SpecFilter().filter(swagger, filter, new HashMap(), new HashMap(), new HashMap());
    }

    private Swagger addSecurityDefinitions(Swagger swagger, ApiSource apiSource) throws GenerateException {
        Swagger result = swagger;
        if (apiSource.getSecurityDefinitions() == null) {
            return result;
        }
        TreeMap<String, SecuritySchemeDefinition> definitions = new TreeMap<String, SecuritySchemeDefinition>();
        for (SecurityDefinition sd : apiSource.getSecurityDefinitions()) {
            for (Map.Entry<String, SecuritySchemeDefinition> entry : sd.generateSecuritySchemeDefinitions().entrySet()) {
                definitions.put(entry.getKey(), entry.getValue());
            }
        }
        result.setSecurityDefinitions(definitions);
        return result;
    }

    private void loadSwaggerExtensions(ApiSource apiSource) throws GenerateException {
        if (apiSource.getSwaggerExtensions() != null) {
            List extensions = SwaggerExtensions.getExtensions();
            extensions.addAll(this.resolveSwaggerExtensions());
        }
    }

    public void toSwaggerDocuments(String uiDocBasePath, String outputFormats, String encoding) throws GenerateException {
        this.toSwaggerDocuments(uiDocBasePath, outputFormats, null, encoding);
    }

    public void toSwaggerDocuments(String uiDocBasePath, String outputFormats, String fileName, String encoding) throws GenerateException {
        File dir;
        this.mapper.configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, false);
        this.mapper = this.mapper.copy();
        if (this.jsonExampleValues) {
            this.mapper.addMixInAnnotations(Property.class, PropertyExampleMixIn.class);
        }
        if (this.swaggerPath == null) {
            return;
        }
        if (!this.isSorted) {
            Utils.sortSwagger(this.swagger);
            this.isSorted = true;
        }
        if ((dir = new File(this.swaggerPath)).isFile()) {
            throw new GenerateException(String.format("Swagger-outputDirectory[%s] must be a directory!", this.swaggerPath));
        }
        if (!dir.exists()) {
            try {
                FileUtils.forceMkdir((File)dir);
            }
            catch (IOException e) {
                throw new GenerateException(String.format("Create Swagger-outputDirectory[%s] failed.", this.swaggerPath));
            }
        }
        fileName = StringUtils.defaultString((String)fileName, (String)"swagger");
        for (String format : outputFormats.split(",")) {
            try {
                Output output = Output.valueOf(format.toLowerCase());
                switch (output) {
                    case json: {
                        ObjectWriter jsonWriter = this.mapper.writer((PrettyPrinter)new DefaultPrettyPrinter());
                        FileUtils.write((File)new File(dir, fileName + ".json"), (CharSequence)jsonWriter.writeValueAsString((Object)this.swagger), (String)encoding);
                        break;
                    }
                    case yaml: {
                        FileUtils.write((File)new File(dir, fileName + ".yaml"), (CharSequence)Yaml.pretty().writeValueAsString((Object)this.swagger), (String)encoding);
                    }
                }
            }
            catch (Exception e) {
                throw new GenerateException(String.format("Declared output format [%s] is not supported.", format));
            }
        }
    }

    public void loadModelModifier() throws GenerateException, IOException {
        ObjectMapper objectMapper = Json.mapper();
        if (this.apiSource.isUseJAXBAnnotationProcessor()) {
            JaxbAnnotationModule jaxbAnnotationModule = new JaxbAnnotationModule();
            if (this.apiSource.isUseJAXBAnnotationProcessorAsPrimary()) {
                jaxbAnnotationModule.setPriority(JaxbAnnotationModule.Priority.PRIMARY);
            } else {
                jaxbAnnotationModule.setPriority(JaxbAnnotationModule.Priority.SECONDARY);
            }
            objectMapper.registerModule((Module)jaxbAnnotationModule);
            objectMapper.registerModule((Module)new EnhancedSwaggerModule());
        }
        ModelModifier modelModifier = new ModelModifier(objectMapper);
        List<String> apiModelPropertyAccessExclusions = this.apiSource.getApiModelPropertyAccessExclusions();
        if (apiModelPropertyAccessExclusions != null && !apiModelPropertyAccessExclusions.isEmpty()) {
            modelModifier.setApiModelPropertyAccessExclusions(apiModelPropertyAccessExclusions);
        }
        if (this.modelSubstitute != null) {
            try (BufferedReader reader = null;){
                reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(this.modelSubstitute)));
                String line = reader.readLine();
                while (line != null) {
                    String[] classes = line.split(":");
                    if (classes.length != 2) {
                        throw new GenerateException("Bad format of override model file, it should be ${actualClassName}:${expectClassName}");
                    }
                    modelModifier.addModelSubstitute(classes[0].trim(), classes[1].trim());
                    line = reader.readLine();
                }
            }
        }
        ModelConverters.getInstance().addConverter((ModelConverter)modelModifier);
    }

    public void loadModelConverters() throws MojoExecutionException {
        List<String> modelConverters = this.apiSource.getModelConverters();
        if (modelConverters == null) {
            return;
        }
        for (String modelConverter : modelConverters) {
            try {
                Class<?> modelConverterClass = Class.forName(modelConverter);
                if (ModelConverter.class.isAssignableFrom(modelConverterClass)) {
                    ModelConverter modelConverterInstance = (ModelConverter)modelConverterClass.newInstance();
                    ModelConverters.getInstance().addConverter(modelConverterInstance);
                    continue;
                }
                throw new MojoExecutionException(String.format("Class %s has to be a subclass of %s", modelConverterClass.getName(), ModelConverter.class));
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException(String.format("Could not find custom model converter %s", modelConverter), (Exception)e);
            }
            catch (InstantiationException e) {
                throw new MojoExecutionException(String.format("Unable to instantiate custom model converter %s", modelConverter), (Exception)e);
            }
            catch (IllegalAccessException e) {
                throw new MojoExecutionException(String.format("Unable to instantiate custom model converter %s", modelConverter), (Exception)e);
            }
        }
    }

    public void loadTypesToSkip() throws GenerateException {
        List<String> typesToSkip = this.apiSource.getTypesToSkip();
        if (typesToSkip == null) {
            return;
        }
        for (String typeToSkip : typesToSkip) {
            try {
                Class<?> type = Class.forName(typeToSkip);
                this.typesToSkip.add(type);
            }
            catch (ClassNotFoundException e) {
                throw new GenerateException(e);
            }
        }
    }

    protected Swagger removeBasePathFromEndpoints(Swagger swagger, boolean removeBasePathFromEndpoints) {
        Swagger result = swagger;
        if (!removeBasePathFromEndpoints) {
            return result;
        }
        String basePath = swagger.getBasePath();
        if (StringUtils.isEmpty((CharSequence)basePath)) {
            return result;
        }
        Map oldPathMap = result.getPaths();
        HashMap<String, Path> newPathMap = new HashMap<String, Path>();
        for (Map.Entry entry : oldPathMap.entrySet()) {
            newPathMap.put(((String)entry.getKey()).replace(basePath, ""), (Path)entry.getValue());
        }
        result.setPaths(newPathMap);
        return result;
    }

    protected File createFile(File dir, String outputResourcePath) throws IOException {
        File serviceFile;
        int i = outputResourcePath.lastIndexOf("/");
        if (i != -1) {
            String fileName = outputResourcePath.substring(i + 1);
            String subDir = outputResourcePath.substring(0, i);
            File finalDirectory = new File(dir, subDir);
            finalDirectory.mkdirs();
            serviceFile = new File(finalDirectory, fileName);
        } else {
            serviceFile = new File(dir, outputResourcePath);
        }
        while (!serviceFile.createNewFile()) {
            serviceFile.delete();
        }
        this.LOG.info((CharSequence)("Creating file " + serviceFile.getAbsolutePath()));
        return serviceFile;
    }

    public void toDocuments() throws GenerateException {
        if (!this.isSorted) {
            Utils.sortSwagger(this.swagger);
            this.isSorted = true;
        }
        this.LOG.info((CharSequence)("Writing doc to " + this.outputPath + "..."));
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.outputPath);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8"));
            TemplatePath tp = Utils.parseTemplateUrl(this.templatePath);
            Handlebars handlebars = new Handlebars(tp.loader);
            this.initHandlebars(handlebars);
            Template template = handlebars.compile(tp.name);
            template.apply((Object)this.swagger, (Writer)writer);
            writer.close();
            this.LOG.info((CharSequence)"Done!");
        }
        catch (MalformedURLException e) {
            throw new GenerateException(e);
        }
        catch (IOException e) {
            throw new GenerateException(e);
        }
    }

    private void initHandlebars(Handlebars handlebars) {
        handlebars.registerHelper("ifeq", (Helper)new Helper<String>(){

            public CharSequence apply(String value, Options options) throws IOException {
                if (value == null || options.param(0) == null) {
                    return options.inverse();
                }
                if (value.equals(options.param(0))) {
                    return options.fn();
                }
                return options.inverse();
            }
        });
        handlebars.registerHelper("basename", (Helper)new Helper<String>(){

            public CharSequence apply(String value, Options options) throws IOException {
                if (value == null) {
                    return null;
                }
                int lastSlash = value.lastIndexOf("/");
                if (lastSlash == -1) {
                    return value;
                }
                return value.substring(lastSlash + 1);
            }
        });
        handlebars.registerHelper(StringHelpers.join.name(), (Helper)StringHelpers.join);
        handlebars.registerHelper(StringHelpers.lower.name(), (Helper)StringHelpers.lower);
    }

    protected ClassSwaggerReader resolveApiReader() throws GenerateException {
        String customReaderClassName = this.apiSource.getSwaggerApiReader();
        if (customReaderClassName == null) {
            D reader = this.createReader();
            ((AbstractReader)reader).setTypesToSkip(this.typesToSkip);
            ((AbstractReader)reader).setOperationIdFormat(this.apiSource.getOperationIdFormat());
            ((AbstractReader)reader).setResponseMessageOverrides(this.apiSource.getResponseMessageOverrides());
            return (ClassSwaggerReader)reader;
        }
        ClassSwaggerReader customApiReader = this.getCustomApiReader(customReaderClassName);
        if (customApiReader instanceof AbstractReader) {
            ((AbstractReader)((Object)customApiReader)).setOperationIdFormat(this.apiSource.getOperationIdFormat());
        }
        return customApiReader;
    }

    protected abstract D createReader();

    protected Set<Class<?>> getValidClasses() {
        return this.apiSource.getValidClasses(Api.class);
    }

    protected List<SwaggerExtension> resolveSwaggerExtensions() throws GenerateException {
        List<String> clazzes = this.apiSource.getSwaggerExtensions();
        ArrayList<SwaggerExtension> resolved = new ArrayList<SwaggerExtension>();
        if (clazzes != null) {
            for (String clazz : clazzes) {
                SwaggerExtension extension = null;
                try {
                    try {
                        Constructor<?> constructor = Class.forName(clazz).getConstructor(Log.class);
                        extension = (SwaggerExtension)constructor.newInstance(this.LOG);
                    }
                    catch (NoSuchMethodException nsme) {
                        extension = (SwaggerExtension)Class.forName(clazz).newInstance();
                    }
                }
                catch (Exception e) {
                    throw new GenerateException("Cannot load Swagger extension: " + clazz, e);
                }
                resolved.add(extension);
            }
        }
        return resolved;
    }

    protected ClassSwaggerReader getCustomApiReader(String customReaderClassName) throws GenerateException {
        try {
            this.LOG.info((CharSequence)("Reading custom API reader: " + customReaderClassName));
            Class<?> clazz = Class.forName(customReaderClassName);
            if (AbstractReader.class.isAssignableFrom(clazz)) {
                Constructor<?> constructor = clazz.getConstructor(Swagger.class, Log.class);
                return (ClassSwaggerReader)constructor.newInstance(this.swagger, this.LOG);
            }
            return (ClassSwaggerReader)clazz.newInstance();
        }
        catch (Exception e) {
            throw new GenerateException("Cannot load Swagger API reader: " + customReaderClassName, e);
        }
    }
}

