/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.jaxrs;

import com.google.common.base.Strings;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs.ext.AbstractSwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtension;
import io.swagger.models.parameters.CookieParameter;
import io.swagger.models.parameters.FormParameter;
import io.swagger.models.parameters.HeaderParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.PathParameter;
import io.swagger.models.parameters.QueryParameter;
import io.swagger.models.properties.Property;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class JaxrsParameterExtension
extends AbstractSwaggerExtension {
    public List<Parameter> extractParameters(List<Annotation> annotations, Type type, Set<Type> typesToSkip, Iterator<SwaggerExtension> chain) {
        if (this.shouldIgnoreType(type, typesToSkip)) {
            return new ArrayList<Parameter>();
        }
        ClassToInstanceMap<Annotation> annotationMap = this.toMap(annotations);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.addAll(this.extractParametersFromAnnotation(type, annotationMap));
        if (!parameters.isEmpty()) {
            return parameters;
        }
        return super.extractParameters(annotations, type, typesToSkip, chain);
    }

    private ClassToInstanceMap<Annotation> toMap(Collection<? extends Annotation> annotations) {
        MutableClassToInstanceMap annotationMap = MutableClassToInstanceMap.create();
        for (Annotation annotation : annotations) {
            if (annotation == null) continue;
            annotationMap.put(annotation.annotationType(), (Object)annotation);
        }
        return annotationMap;
    }

    private List<Parameter> extractParametersFromAnnotation(Type type, ClassToInstanceMap<Annotation> annotations) {
        String defaultValue = "";
        if (annotations.containsKey(DefaultValue.class)) {
            DefaultValue defaultValueAnnotation = (DefaultValue)annotations.getInstance(DefaultValue.class);
            defaultValue = defaultValueAnnotation.value();
        }
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (annotations.containsKey(QueryParam.class)) {
            QueryParam param = (QueryParam)annotations.getInstance(QueryParam.class);
            QueryParameter queryParameter = this.extractQueryParam(type, defaultValue, param);
            parameters.add((Parameter)queryParameter);
        } else if (annotations.containsKey(PathParam.class)) {
            PathParam param = (PathParam)annotations.getInstance(PathParam.class);
            PathParameter pathParameter = this.extractPathParam(type, defaultValue, param);
            parameters.add((Parameter)pathParameter);
        } else if (annotations.containsKey(HeaderParam.class)) {
            HeaderParam param = (HeaderParam)annotations.getInstance(HeaderParam.class);
            HeaderParameter headerParameter = this.extractHeaderParam(type, defaultValue, param);
            parameters.add((Parameter)headerParameter);
        } else if (annotations.containsKey(CookieParam.class)) {
            CookieParam param = (CookieParam)annotations.getInstance(CookieParam.class);
            CookieParameter cookieParameter = this.extractCookieParameter(type, defaultValue, param);
            parameters.add((Parameter)cookieParameter);
        } else if (annotations.containsKey(FormParam.class)) {
            FormParam param = (FormParam)annotations.getInstance(FormParam.class);
            FormParameter formParameter = this.extractFormParameter(type, defaultValue, param);
            parameters.add((Parameter)formParameter);
        }
        return parameters;
    }

    private QueryParameter extractQueryParam(Type type, String defaultValue, QueryParam param) {
        String parameterType;
        Property schema;
        QueryParameter queryParameter = (QueryParameter)new QueryParameter().name(param.value());
        if (!Strings.isNullOrEmpty((String)defaultValue)) {
            queryParameter.setDefaultValue(defaultValue);
        }
        if ((schema = ModelConverters.getInstance().readAsProperty(type)) != null) {
            queryParameter.setProperty(schema);
        }
        if ((parameterType = queryParameter.getType()) == null || parameterType.equals("ref")) {
            queryParameter.setType("string");
        }
        return queryParameter;
    }

    private PathParameter extractPathParam(Type type, String defaultValue, PathParam param) {
        String parameterType;
        Property schema;
        PathParameter pathParameter = (PathParameter)new PathParameter().name(param.value());
        if (!Strings.isNullOrEmpty((String)defaultValue)) {
            pathParameter.setDefaultValue(defaultValue);
        }
        if ((schema = ModelConverters.getInstance().readAsProperty(type)) != null) {
            pathParameter.setProperty(schema);
        }
        if ((parameterType = pathParameter.getType()) == null || parameterType.equals("ref")) {
            pathParameter.setType("string");
        }
        return pathParameter;
    }

    private HeaderParameter extractHeaderParam(Type type, String defaultValue, HeaderParam param) {
        String parameterType;
        Property schema;
        HeaderParameter headerParameter = (HeaderParameter)new HeaderParameter().name(param.value());
        if (!Strings.isNullOrEmpty((String)defaultValue)) {
            headerParameter.setDefaultValue(defaultValue);
        }
        if ((schema = ModelConverters.getInstance().readAsProperty(type)) != null) {
            headerParameter.setProperty(schema);
        }
        if ((parameterType = headerParameter.getType()) == null || parameterType.equals("ref") || parameterType.equals("array")) {
            headerParameter.setType("string");
        }
        return headerParameter;
    }

    private CookieParameter extractCookieParameter(Type type, String defaultValue, CookieParam param) {
        String parameterType;
        Property schema;
        CookieParameter cookieParameter = (CookieParameter)new CookieParameter().name(param.value());
        if (!Strings.isNullOrEmpty((String)defaultValue)) {
            cookieParameter.setDefaultValue(defaultValue);
        }
        if ((schema = ModelConverters.getInstance().readAsProperty(type)) != null) {
            cookieParameter.setProperty(schema);
        }
        if ((parameterType = cookieParameter.getType()) == null || parameterType.equals("ref") || parameterType.equals("array")) {
            cookieParameter.setType("string");
        }
        return cookieParameter;
    }

    private FormParameter extractFormParameter(Type type, String defaultValue, FormParam param) {
        String parameterType;
        Property schema;
        FormParameter formParameter = (FormParameter)new FormParameter().name(param.value());
        if (!Strings.isNullOrEmpty((String)defaultValue)) {
            formParameter.setDefaultValue(defaultValue);
        }
        if ((schema = ModelConverters.getInstance().readAsProperty(type)) != null) {
            formParameter.setProperty(schema);
        }
        if ((parameterType = formParameter.getType()) == null || parameterType.equals("ref") || parameterType.equals("array")) {
            formParameter.setType("string");
        }
        return formParameter;
    }
}

