/*
 * Decompiled with CFR 0.152.
 */
import com.bigchaindb.api.TransactionsApi;
import com.bigchaindb.builders.BigchainDbConfigBuilder;
import com.bigchaindb.builders.BigchainDbTransactionBuilder;
import com.bigchaindb.constants.Operations;
import com.bigchaindb.model.Connection;
import com.bigchaindb.model.FulFill;
import com.bigchaindb.model.GenericCallback;
import com.bigchaindb.model.MetaData;
import com.bigchaindb.model.Transaction;
import com.bigchaindb.util.Base58;
import java.io.IOException;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeoutException;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.KeyPairGenerator;
import okhttp3.Response;

public class BigchainDBJavaDriverUsageExample {
    public static void main(String[] args) throws Exception {
        String txId;
        BigchainDBJavaDriverUsageExample examples = new BigchainDBJavaDriverUsageExample();
        BigchainDBJavaDriverUsageExample.configureConnectionManager();
        KeyPair keys = BigchainDBJavaDriverUsageExample.getKeys();
        System.out.println(Base58.encode(keys.getPublic().getEncoded()));
        System.out.println(Base58.encode(keys.getPrivate().getEncoded()));
        TreeMap<String, String> assetData = new TreeMap<String, String>(){
            {
                this.put("name", "James Bond");
                this.put("age", "doesn't matter");
                this.put("purpose", "saving the world");
            }
        };
        System.out.println("(*) Assets Prepared..");
        MetaData metaData = new MetaData();
        metaData.setMetaData("where is he now?", "Thailand");
        System.out.println("(*) Metadata Prepared..");
        String assetId = txId = examples.doCreate((Map<String, String>)assetData, metaData, keys);
        Thread.sleep(2000L);
        for (int i = 0; i < 50; ++i) {
            MetaData transferMetadata = new MetaData();
            transferMetadata.setMetaData("where is he now?", "Japan - " + Math.random());
            System.out.println("(*) Transfer Metadata Prepared for i - " + i);
            Thread.sleep(2000L);
            txId = examples.doTransfer(assetId, txId, transferMetadata, keys);
            examples.doCreate((Map<String, String>)assetData, transferMetadata, keys);
        }
    }

    private void onSuccess(Response response) throws IOException {
        System.out.println("Success : ");
    }

    private void onFailure() {
        System.out.println("Transaction failed");
    }

    private GenericCallback handleServerResponse() {
        GenericCallback callback = new GenericCallback(){

            @Override
            public void transactionMalformed(Response response) {
                System.out.println("malformed - " + response.message());
                BigchainDBJavaDriverUsageExample.this.onFailure();
            }

            @Override
            public void pushedSuccessfully(Response response) {
                try {
                    System.out.println("pushedSuccessfully - " + response.body().string());
                    BigchainDBJavaDriverUsageExample.this.onSuccess(response);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public void otherError(Response response) {
                System.out.println("otherError" + response.message());
                BigchainDBJavaDriverUsageExample.this.onFailure();
            }
        };
        return callback;
    }

    public static void setConfig() {
        BigchainDbConfigBuilder.baseUrl("http://localhost:9984/").addToken("app_id", "").addToken("app_key", "").setTimeout(60000).setup();
    }

    public static void configureConnectionManager() throws TimeoutException {
        HashMap<String, Object> conn1Config = new HashMap<String, Object>();
        HashMap<String, Object> conn2Config = new HashMap<String, Object>();
        HashMap<String, String> headers1 = new HashMap<String, String>();
        HashMap<String, String> headers2 = new HashMap<String, String>();
        headers1.put("app_id", "");
        headers1.put("app_key", "");
        headers2.put("app_id", "8609ee17");
        headers2.put("app_key", "130a79938e5dcc6c7aa1166028f06e20");
        conn1Config.put("baseUrl", "http://localhost:9984");
        conn1Config.put("headers", headers1);
        Connection conn1 = new Connection(conn1Config);
        conn2Config.put("baseUrl", "https://test.bigchaindb.com/");
        conn2Config.put("headers", headers2);
        Connection conn2 = new Connection(conn2Config);
        ArrayList<Connection> connections = new ArrayList<Connection>();
        connections.add(conn1);
        BigchainDbConfigBuilder.addConnections(connections).setTimeout(60000).setup();
    }

    public static KeyPair getKeys() {
        KeyPairGenerator edDsaKpg = new KeyPairGenerator();
        KeyPair keyPair = edDsaKpg.generateKeyPair();
        System.out.println("(*) Keys Generated..");
        return keyPair;
    }

    public void getTransaction(String txId) throws IOException, InterruptedException {
        Transaction tx = TransactionsApi.getTransactionById(txId);
        System.out.println("********************");
        System.out.println(tx);
    }

    public String doCreate(Map<String, String> assetData, MetaData metaData, KeyPair keys) throws Exception {
        try {
            Transaction transaction = null;
            transaction = BigchainDbTransactionBuilder.init().addAssets(assetData, TreeMap.class).addMetaData(metaData).operation(Operations.CREATE).buildAndSign((EdDSAPublicKey)keys.getPublic(), (EdDSAPrivateKey)keys.getPrivate()).sendTransaction(this.handleServerResponse());
            System.out.println("(*) CREATE Transaction sent.. - " + transaction.getId());
            return transaction.getId();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String doTransfer(String assetId, String txId, MetaData metaData, KeyPair keys) throws Exception {
        try {
            FulFill fulfill = new FulFill();
            fulfill.setOutputIndex(0);
            fulfill.setTransactionId(txId);
            Transaction transaction = BigchainDbTransactionBuilder.init().addInput((String)null, fulfill, (EdDSAPublicKey)keys.getPublic()).addOutput("1", (EdDSAPublicKey)keys.getPublic()).addAssets(assetId, String.class).addMetaData(metaData).operation(Operations.TRANSFER).buildAndSign((EdDSAPublicKey)keys.getPublic(), (EdDSAPrivateKey)keys.getPrivate()).sendTransaction(this.handleServerResponse());
            System.out.println("(*) TRANSFER Transaction sent.. - " + transaction.getId());
            return transaction.getId();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

