/*
 * Decompiled with CFR 0.152.
 */
package com.bigchaindb.api;

import com.bigchaindb.api.AbstractApi;
import com.bigchaindb.model.Account;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.KeyPairGenerator;
import net.i2p.crypto.eddsa.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountApi
extends AbstractApi {
    private static final Logger log = LoggerFactory.getLogger(AccountApi.class);

    public static Account createAccount() {
        log.debug("createAccount Call");
        Account newAccount = new Account();
        KeyPairGenerator edDsaKpg = new KeyPairGenerator();
        KeyPair keyPair = edDsaKpg.generateKeyPair();
        newAccount.setPrivateKey(keyPair.getPrivate());
        newAccount.setPublicKey(keyPair.getPublic());
        log.debug("createAccount Call : " + newAccount.getPublicKey().toString());
        return newAccount;
    }

    public static Account loadAccount(String publicKey, String privateKey) throws InvalidKeySpecException {
        log.debug("loadAccount Call");
        Account newAccount = new Account();
        X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(Utils.hexToBytes((String)publicKey));
        EdDSAPublicKey pubKey = new EdDSAPublicKey(pubKeySpec);
        PKCS8EncodedKeySpec encoded = new PKCS8EncodedKeySpec(Utils.hexToBytes((String)privateKey));
        EdDSAPrivateKey privKey = new EdDSAPrivateKey(encoded);
        KeyPair keyPair = new KeyPair((PublicKey)pubKey, (PrivateKey)privKey);
        newAccount.setPrivateKey(keyPair.getPrivate());
        newAccount.setPublicKey(keyPair.getPublic());
        log.debug("loadAccount Call : " + newAccount.getPublicKey().toString());
        return newAccount;
    }
}

