/*
 * Decompiled with CFR 0.152.
 */
package com.bigchaindb.api;

import com.bigchaindb.constants.BigchainDbApi;
import com.bigchaindb.model.BigChainDBGlobals;
import com.bigchaindb.model.Block;
import com.bigchaindb.util.JsonUtils;
import com.bigchaindb.util.NetworkUtils;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.List;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlocksApi {
    private static final Logger log = LoggerFactory.getLogger(BlocksApi.class);

    public static Block getBlock(String blockId) throws IOException {
        log.debug("getBlock Call :" + blockId);
        Response response = NetworkUtils.sendGetRequest(BigChainDBGlobals.getBaseUrl() + (Object)((Object)BigchainDbApi.BLOCKS) + "/" + blockId);
        String body = response.body().string();
        response.close();
        return JsonUtils.fromJson(body, Block.class);
    }

    public static List<String> getBlocksByTransactionId(String transactionId) throws IOException {
        log.debug("getBlocks Call :" + transactionId);
        Response response = NetworkUtils.sendGetRequest(BigChainDBGlobals.getBaseUrl() + (Object)((Object)BigchainDbApi.BLOCKS) + "?transaction_id=" + transactionId);
        String body = response.body().string();
        response.close();
        return (List)JsonUtils.getGson().fromJson(body, new TypeToken<List<String>>(){}.getType());
    }
}

