/*
 * Decompiled with CFR 0.152.
 */
package com.bigchaindb.api;

import com.bigchaindb.api.AbstractApi;
import com.bigchaindb.constants.BigchainDbApi;
import com.bigchaindb.constants.Operations;
import com.bigchaindb.model.BigChainDBGlobals;
import com.bigchaindb.model.GenericCallback;
import com.bigchaindb.model.Transaction;
import com.bigchaindb.model.Transactions;
import com.bigchaindb.util.JsonUtils;
import com.bigchaindb.util.NetworkUtils;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionsApi
extends AbstractApi {
    private static final Logger log = LoggerFactory.getLogger(TransactionsApi.class);

    public static void sendTransaction(Transaction transaction, GenericCallback callback) {
        log.debug("sendTransaction Call :" + transaction);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)transaction.toString());
        NetworkUtils.sendPostRequest(BigChainDBGlobals.getBaseUrl() + (Object)((Object)BigchainDbApi.TRANSACTIONS), body, callback);
    }

    public static void sendTransaction(Transaction transaction) throws IOException {
        log.debug("sendTransaction Call :" + transaction);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)JsonUtils.toJson(transaction));
        Response response = NetworkUtils.sendPostRequest(BigChainDBGlobals.getBaseUrl() + (Object)((Object)BigchainDbApi.TRANSACTIONS), body);
        response.close();
    }

    public static Transaction getTransactionById(String id) throws IOException {
        log.debug("getTransactionById Call :" + id);
        Response response = NetworkUtils.sendGetRequest(BigChainDBGlobals.getBaseUrl() + (Object)((Object)BigchainDbApi.TRANSACTIONS) + "/" + id);
        String body = response.body().string();
        response.close();
        return JsonUtils.fromJson(body, Transaction.class);
    }

    public static Transactions getTransactionsByAssetId(String assetId, Operations operation) throws IOException {
        log.debug("getTransactionsByAssetId Call :" + assetId + " operation " + (Object)((Object)operation));
        Response response = NetworkUtils.sendGetRequest(BigChainDBGlobals.getBaseUrl() + (Object)((Object)BigchainDbApi.TRANSACTIONS) + "?asset_id=" + assetId + "&operation=" + (Object)((Object)operation));
        String body = response.body().string();
        response.close();
        return JsonUtils.fromJson(body, Transactions.class);
    }
}

