/*
 * Decompiled with CFR 0.152.
 */
package com.bigchaindb.builders;

import com.bigchaindb.constants.BigchainDbApi;
import com.bigchaindb.model.ApiEndpoints;
import com.bigchaindb.model.BigChainDBGlobals;
import com.bigchaindb.model.Connection;
import com.bigchaindb.util.JsonUtils;
import com.bigchaindb.util.NetworkUtils;
import com.bigchaindb.ws.BigchainDbWSSessionManager;
import com.bigchaindb.ws.MessageHandler;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigchainDbConfigBuilder {
    private static final Logger log = LoggerFactory.getLogger(BigchainDbConfigBuilder.class);
    public ConfigBuilder builder = new ConfigBuilder();

    private BigchainDbConfigBuilder() {
    }

    public static ITokens addConnections(List<Connection> connections) {
        return new ConfigBuilder(connections);
    }

    public static ITokens baseUrl(String baseUrl) {
        return new ConfigBuilder(baseUrl);
    }

    protected static class ConfigBuilder
    implements ITokens {
        String baseUrl;
        Map<String, String> tokens = new HashMap<String, String>();
        OkHttpClient httpClient;
        boolean setupWsockets = false;
        MessageHandler messageHandler = null;
        private Interceptor authInterceptor = new Interceptor(this){
            final /* synthetic */ ConfigBuilder this$0;
            {
                this.this$0 = this$0;
            }

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request originalRequest = chain.request();
                if (this.this$0.tokens == null) {
                    return chain.proceed(originalRequest);
                }
                Request.Builder authorisedRequest = originalRequest.newBuilder();
                for (String key : this.this$0.tokens.keySet()) {
                    authorisedRequest = authorisedRequest.addHeader(key, this.this$0.tokens.get(key));
                }
                return chain.proceed(authorisedRequest.build());
            }
        };

        public ConfigBuilder() {
        }

        public ConfigBuilder(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public ConfigBuilder(List<Connection> connections) {
            BigChainDBGlobals.setConnections(connections);
            BigChainDBGlobals.setHasMultipleNodes(true);
        }

        @Override
        public ITokens addToken(String key, String value) {
            this.tokens.put(key, value);
            return this;
        }

        @Override
        public void setup() {
            this.configureConnections();
            this.setMetaValuesToConnections();
            try {
                this.configure();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
        }

        private void setMetaValuesToConnections() {
            for (int i = 0; i < BigChainDBGlobals.getConnections().size(); ++i) {
                BigChainDBGlobals.getConnections().get(i).setRetryCount(0);
                BigChainDBGlobals.getConnections().get(i).setTimeToRetryForConnection(0L);
            }
        }

        public void configure() throws TimeoutException {
            BigChainDBGlobals.resetTimeTillTimeout();
            this.configureNodeToConnect();
        }

        public void configureNodeToConnect() throws TimeoutException {
            Connection nodeToConnect = null;
            try {
                if (System.currentTimeMillis() > BigChainDBGlobals.getTimeTillTimeout()) {
                    throw new TimeoutException();
                }
                nodeToConnect = BigChainDBGlobals.isHasMultipleNodes() ? this.getConnectionWithEarliestAvailability() : BigChainDBGlobals.getCurrentNode();
                this.prepareHeader(nodeToConnect);
                this.waitTillTimetoConnect(nodeToConnect.getTimeToRetryForConnection());
                boolean connected = this.connect(nodeToConnect);
                if (!connected) {
                    log.info("Couldn't connect to node - " + BigChainDBGlobals.getCurrentNode().getConnection().get("baseUrl") + " after " + BigChainDBGlobals.getCurrentNode().getRetryCount() + " retry(s)...");
                    this.processConnectionFailure(nodeToConnect);
                    this.configureNodeToConnect();
                } else {
                    log.info("Connected to node - " + BigChainDBGlobals.getCurrentNode().getConnection().get("baseUrl") + " after " + BigChainDBGlobals.getCurrentNode().getRetryCount() + " retry(s)...");
                    this.processConnectionSuccess(nodeToConnect);
                }
            }
            catch (Exception e) {
                if (e instanceof TimeoutException) {
                    throw new TimeoutException("Couldn't connect to any given nodes in " + BigChainDBGlobals.getTimeout() + " ms. Check if the nodes are up and running!");
                }
                log.info("Couldn't connect to node - " + BigChainDBGlobals.getCurrentNode().getConnection().get("baseUrl") + " after " + BigChainDBGlobals.getCurrentNode().getRetryCount() + " retry(s)...");
                this.processConnectionFailure(nodeToConnect);
                this.configureNodeToConnect();
            }
        }

        public void processConnectionFailure(Connection nodeToConnect) {
            long timeToRetryCap;
            int nodeIndex = BigChainDBGlobals.getConnections().indexOf(nodeToConnect);
            Connection conn = BigChainDBGlobals.getConnections().get(nodeIndex);
            long timeToRetryConnection = 500L * (long)Math.pow(2.0, conn.getRetryCount());
            timeToRetryConnection = timeToRetryConnection < (timeToRetryCap = (long)(BigChainDBGlobals.getTimeout() / 2)) ? timeToRetryConnection : timeToRetryCap;
            conn.setTimeToRetryForConnection(System.currentTimeMillis() + timeToRetryConnection);
            int retryCount = conn.getRetryCount();
            conn.setRetryCount(++retryCount);
            BigChainDBGlobals.getConnections().set(nodeIndex, conn);
        }

        public void processConnectionSuccess(Connection connectedNode) {
            int nodeIndex = BigChainDBGlobals.getConnections().indexOf(connectedNode);
            Connection conn = BigChainDBGlobals.getConnections().get(nodeIndex);
            conn.setTimeToRetryForConnection(0L);
            conn.setRetryCount(0);
            BigChainDBGlobals.resetTimeTillTimeout();
            BigChainDBGlobals.getConnections().set(nodeIndex, conn);
        }

        private Connection getConnectionWithEarliestAvailability() {
            BigChainDBGlobals.getConnections().sort(Comparator.comparingLong(Connection::getTimeToRetryForConnection));
            Connection nodeToConnect = BigChainDBGlobals.getConnections().get(0);
            BigChainDBGlobals.setCurrentNode(nodeToConnect);
            return nodeToConnect;
        }

        private void waitTillTimetoConnect(long timeToRetryToConnect) throws TimeoutException {
            long currentTimeInMs = System.currentTimeMillis();
            while (currentTimeInMs < timeToRetryToConnect) {
                if (System.currentTimeMillis() > BigChainDBGlobals.getTimeTillTimeout()) {
                    throw new TimeoutException();
                }
                currentTimeInMs = System.currentTimeMillis();
            }
        }

        public boolean connect(Connection connection) throws Exception {
            boolean isConnectionSuccessful = false;
            BigChainDBGlobals.setAuthorizationTokens(this.tokens);
            BigChainDBGlobals.setBaseUrl(connection.getConnection().get("baseUrl") + "/api" + (Object)((Object)BigchainDbApi.API_VERSION));
            BigChainDBGlobals.setWsSocketUrl(connection.getConnection().get("baseUrl") + "/api" + (Object)((Object)BigchainDbApi.API_VERSION) + (Object)((Object)BigchainDbApi.STREAMS));
            Response connectionResponse = null;
            if (!BigChainDBGlobals.isConnected() || this.httpClient == null && BigChainDBGlobals.getHttpClient() == null) {
                BigChainDBGlobals.setHttpClient(this.buildDefaultHttpClient());
            }
            try {
                connectionResponse = NetworkUtils.sendGetRequest(connection.getConnection().get("baseUrl") + "/api" + (Object)((Object)BigchainDbApi.API_VERSION));
                BigChainDBGlobals.setApiEndpoints(JsonUtils.fromJson(connectionResponse.body().string(), ApiEndpoints.class));
                if (connectionResponse.code() == 200) {
                    isConnectionSuccessful = true;
                }
                if (this.setupWsockets) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            new BigchainDbWSSessionManager(URI.create(BigChainDBGlobals.getApiEndpoints().getStreams()), messageHandler);
                        }
                    }).start();
                }
            }
            catch (ConnectException ex) {
                throw new ConnectException();
            }
            catch (Exception e) {
                throw new Exception();
            }
            return isConnectionSuccessful;
        }

        private OkHttpClient buildDefaultHttpClient() {
            long httpTimeout = BigChainDBGlobals.getTimeTillTimeout() - System.currentTimeMillis();
            return new OkHttpClient.Builder().connectTimeout(httpTimeout, TimeUnit.MILLISECONDS).writeTimeout(httpTimeout, TimeUnit.MILLISECONDS).readTimeout(httpTimeout, TimeUnit.MILLISECONDS).addInterceptor(this.authInterceptor).build();
        }

        private Map<String, String> prepareHeader(Connection connection) {
            this.tokens = (Map)connection.getConnection().get("headers");
            return this.tokens;
        }

        private void configureConnections() {
            if (!BigChainDBGlobals.isHasMultipleNodes()) {
                HashMap<String, Object> config = new HashMap<String, Object>();
                config.put("baseUrl", this.baseUrl);
                config.put("headers", this.tokens);
                Connection connection = new Connection(config);
                ArrayList<Connection> connections = new ArrayList<Connection>();
                connections.add(connection);
                BigChainDBGlobals.setConnections(connections);
                BigChainDBGlobals.setCurrentNode(connection);
            }
        }

        @Override
        public ITokens webSocketMonitor(MessageHandler messageHandler) {
            this.setupWsockets = true;
            this.messageHandler = messageHandler;
            return this;
        }

        @Override
        public ITokens setTimeout(int timeInMs) {
            BigChainDBGlobals.setTimeout(timeInMs);
            return this;
        }
    }

    public static interface ITokens {
        public ITokens addToken(String var1, String var2);

        public ITokens webSocketMonitor(MessageHandler var1);

        public ITokens setTimeout(int var1);

        public void setup();
    }
}

