/*
 * Decompiled with CFR 0.152.
 */
package com.bigchaindb.builders;

import com.bigchaindb.api.TransactionsApi;
import com.bigchaindb.builders.BigchainDbConfigBuilder;
import com.bigchaindb.constants.Operations;
import com.bigchaindb.cryptoconditions.types.Ed25519Sha256Condition;
import com.bigchaindb.cryptoconditions.types.Ed25519Sha256Fulfillment;
import com.bigchaindb.json.strategy.TransactionDeserializer;
import com.bigchaindb.json.strategy.TransactionsDeserializer;
import com.bigchaindb.model.Asset;
import com.bigchaindb.model.BigChainDBGlobals;
import com.bigchaindb.model.Condition;
import com.bigchaindb.model.Details;
import com.bigchaindb.model.FulFill;
import com.bigchaindb.model.GenericCallback;
import com.bigchaindb.model.Input;
import com.bigchaindb.model.Output;
import com.bigchaindb.model.Transaction;
import com.bigchaindb.util.DriverUtils;
import com.bigchaindb.util.JsonUtils;
import com.bigchaindb.util.KeyPairUtils;
import com.google.api.client.util.Base64;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigchainDbTransactionBuilder {
    private static final Logger log = LoggerFactory.getLogger(BigchainDbTransactionBuilder.class);

    private BigchainDbTransactionBuilder() {
    }

    public static Builder init() {
        return new Builder();
    }

    public static class Builder
    implements ITransactionAttributes,
    IBuild {
        private BigchainDbConfigBuilder.ConfigBuilder configBuilder = new BigchainDbConfigBuilder.ConfigBuilder();
        private Object metadata = null;
        private Object assets = null;
        private Class assetsDataClass = null;
        private List<Input> inputs = new ArrayList<Input>();
        private List<Output> outputs = new ArrayList<Output>();
        private EdDSAPublicKey publicKey;
        private Transaction transaction;
        private Operations operation;

        @Override
        public ITransactionAttributes addOutput(String amount) {
            return this.addOutput(amount, this.publicKey);
        }

        @Override
        public ITransactionAttributes addOutput(String amount, EdDSAPublicKey publicKey) {
            EdDSAPublicKey[] keys = new EdDSAPublicKey[]{publicKey};
            return this.addOutput(amount, keys);
        }

        @Override
        public ITransactionAttributes addOutput(String amount, EdDSAPublicKey ... publicKeys) {
            for (EdDSAPublicKey publicKey : publicKeys) {
                Output output = new Output();
                Ed25519Sha256Condition sha256Condition = new Ed25519Sha256Condition(publicKey);
                output.setAmount(amount);
                output.addPublicKey(KeyPairUtils.encodePublicKeyInBase58(publicKey));
                Details details = new Details();
                details.setPublicKey(KeyPairUtils.encodePublicKeyInBase58(publicKey));
                details.setType("ed25519-sha-256");
                output.setCondition(new Condition(details, sha256Condition.getUri().toString()));
                this.outputs.add(output);
            }
            return this;
        }

        @Override
        public ITransactionAttributes addInput(String fullfillment, FulFill fullFill) {
            return this.addInput(fullfillment, fullFill, this.publicKey);
        }

        @Override
        public ITransactionAttributes addInput(String fullfillment, FulFill fullFill, EdDSAPublicKey publicKey) {
            EdDSAPublicKey[] keys = new EdDSAPublicKey[]{publicKey};
            return this.addInput(fullfillment, fullFill, keys);
        }

        @Override
        public ITransactionAttributes addInput(String fullfillment, FulFill fullFill, EdDSAPublicKey ... publicKeys) {
            for (EdDSAPublicKey publicKey : publicKeys) {
                Input input = new Input();
                input.setFullFillment(fullfillment);
                input.setFulFills(fullFill);
                input.addOwner(KeyPairUtils.encodePublicKeyInBase58(publicKey));
                this.inputs.add(input);
            }
            return this;
        }

        @Override
        public ITransactionAttributes addInput(Details fullfillment, FulFill fullFill, EdDSAPublicKey ... publicKeys) {
            for (EdDSAPublicKey publicKey : publicKeys) {
                Input input = new Input();
                input.setFullFillment(fullfillment);
                input.setFulFills(fullFill);
                input.addOwner(KeyPairUtils.encodePublicKeyInBase58(publicKey));
                this.inputs.add(input);
            }
            return this;
        }

        @Override
        public ITransactionAttributes addAssetDataClass(Class assetDataClass, JsonDeserializer<?> jsonDeserializer) {
            return this;
        }

        @Override
        public ITransactionAttributes addMetaDataClassDeserializer(Class metaDataClass, JsonDeserializer<?> jsonDeserializer) {
            TransactionDeserializer.setMetaDataClass(metaDataClass);
            TransactionsDeserializer.setMetaDataClass(metaDataClass);
            JsonUtils.addTypeAdapterDeserializer(metaDataClass, jsonDeserializer);
            return this;
        }

        @Override
        public ITransactionAttributes addMetaDataClassSerializer(Class metaDataClass, JsonSerializer<?> jsonSerializer) {
            JsonUtils.addTypeAdapterSerializer(metaDataClass, jsonSerializer);
            return this;
        }

        @Override
        public ITransactionAttributes addMetaData(Object object) {
            this.metadata = object;
            return this;
        }

        @Override
        public IBuild build(EdDSAPublicKey publicKey) throws Exception {
            this.transaction = new Transaction();
            this.publicKey = publicKey;
            if (this.outputs.isEmpty()) {
                this.addOutput("1");
            }
            for (Output output : this.outputs) {
                this.transaction.addOutput(output);
            }
            if (this.inputs.isEmpty()) {
                this.addInput(null, null);
            }
            for (Input input : this.inputs) {
                this.transaction.addInput(input);
            }
            if (this.operation != Operations.CREATE && this.operation != Operations.TRANSFER) {
                throw new Exception("Invalid Operations value. Accepted values are [Operations.CREATE, Operations.TRANSFER]");
            }
            this.transaction.setOperation(this.operation.name());
            if (String.class.isAssignableFrom(this.assets.getClass())) {
                this.transaction.setAsset(new Asset((String)this.assets));
            } else {
                this.transaction.setAsset(new Asset(this.assets, this.assetsDataClass));
            }
            this.transaction.setMetaData(this.metadata);
            this.transaction.setVersion("2.0");
            this.transaction.setId(null);
            return this;
        }

        private void sign(EdDSAPrivateKey privateKey) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException {
            byte[] sha3Hash;
            String temp = this.transaction.toHashInput();
            JsonObject transactionJObject = DriverUtils.makeSelfSortingGson(temp);
            if (Operations.TRANSFER.name().equals(this.transaction.getOperation())) {
                StringBuilder preimage = new StringBuilder(transactionJObject.toString());
                for (Input in : this.transaction.getInputs()) {
                    if (in.getFulFills() == null) continue;
                    FulFill fulfill = in.getFulFills();
                    String txBlock = fulfill.getTransactionId() + String.valueOf(fulfill.getOutputIndex());
                    preimage.append(txBlock);
                }
                sha3Hash = DriverUtils.getSha3HashRaw(preimage.toString().getBytes());
            } else {
                sha3Hash = DriverUtils.getSha3HashRaw(transactionJObject.toString().getBytes());
            }
            EdDSAEngine edDsaSigner = new EdDSAEngine(MessageDigest.getInstance("SHA-512"));
            edDsaSigner.initSign((PrivateKey)privateKey);
            edDsaSigner.update(sha3Hash);
            byte[] signature = edDsaSigner.sign();
            Ed25519Sha256Fulfillment fulfillment = new Ed25519Sha256Fulfillment(this.publicKey, signature);
            this.transaction.getInputs().get(0).setFullFillment(Base64.encodeBase64URLSafeString((byte[])fulfillment.getEncoded()));
            this.transaction.setSigned(true);
            String id = DriverUtils.getSha3HashHex(DriverUtils.makeSelfSortingGson(this.transaction.toHashInput()).toString().getBytes());
            this.transaction.setId(id);
        }

        @Override
        public IBuild buildAndSign(EdDSAPublicKey publicKey, EdDSAPrivateKey privateKey) throws Exception {
            try {
                this.build(publicKey);
                this.sign(privateKey);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
                e.printStackTrace();
            }
            return this;
        }

        @Override
        public Transaction buildOnly(EdDSAPublicKey publicKey) throws Exception {
            this.build(publicKey);
            return this.transaction;
        }

        @Override
        public Transaction buildAndSignOnly(EdDSAPublicKey publicKey, EdDSAPrivateKey privateKey) throws Exception {
            this.buildAndSign(publicKey, privateKey);
            return this.transaction;
        }

        @Override
        public Transaction sendTransaction(GenericCallback callback) throws TimeoutException {
            if (!BigChainDBGlobals.isConnected()) {
                this.configBuilder.processConnectionFailure(BigChainDBGlobals.getCurrentNode());
                this.configBuilder.configureNodeToConnect();
            }
            TransactionsApi.sendTransaction(this.transaction, callback);
            this.configBuilder.processConnectionSuccess(BigChainDBGlobals.getCurrentNode());
            return this.transaction;
        }

        @Override
        public Transaction sendTransaction() throws TimeoutException {
            if (!BigChainDBGlobals.isConnected()) {
                this.configBuilder.processConnectionFailure(BigChainDBGlobals.getCurrentNode());
                this.configBuilder.configureNodeToConnect();
            }
            try {
                TransactionsApi.sendTransaction(this.transaction);
                this.configBuilder.processConnectionSuccess(BigChainDBGlobals.getCurrentNode());
            }
            catch (IOException e) {
                this.sendTransaction();
            }
            return this.transaction;
        }

        @Override
        public ITransactionAttributes addAssets(Object obj, Class assetsDataClass) {
            this.assets = obj;
            this.assetsDataClass = assetsDataClass;
            return this;
        }

        @Override
        public ITransactionAttributes operation(Operations operation) {
            this.operation = operation;
            return this;
        }
    }

    public static interface IBuild {
        public Transaction sendTransaction() throws TimeoutException;

        public Transaction sendTransaction(GenericCallback var1) throws TimeoutException;
    }

    public static interface ITransactionAttributes {
        public ITransactionAttributes operation(Operations var1);

        public ITransactionAttributes addAssetDataClass(Class var1, JsonDeserializer<?> var2);

        public ITransactionAttributes addOutput(String var1, EdDSAPublicKey ... var2);

        public ITransactionAttributes addOutput(String var1);

        public ITransactionAttributes addOutput(String var1, EdDSAPublicKey var2);

        public ITransactionAttributes addInput(String var1, FulFill var2, EdDSAPublicKey ... var3);

        public ITransactionAttributes addInput(String var1, FulFill var2);

        public ITransactionAttributes addInput(String var1, FulFill var2, EdDSAPublicKey var3);

        public ITransactionAttributes addInput(Details var1, FulFill var2, EdDSAPublicKey ... var3);

        public ITransactionAttributes addAssets(Object var1, Class var2);

        public ITransactionAttributes addMetaData(Object var1);

        public ITransactionAttributes addMetaDataClassDeserializer(Class var1, JsonDeserializer<?> var2);

        public ITransactionAttributes addMetaDataClassSerializer(Class var1, JsonSerializer<?> var2);

        public IBuild build(EdDSAPublicKey var1) throws Exception;

        public IBuild buildAndSign(EdDSAPublicKey var1, EdDSAPrivateKey var2) throws Exception;

        public Transaction buildOnly(EdDSAPublicKey var1) throws Exception;

        public Transaction buildAndSignOnly(EdDSAPublicKey var1, EdDSAPrivateKey var2) throws Exception;
    }
}

