/*
 * Decompiled with CFR 0.152.
 */
package com.bigchaindb.util;

import com.bigchaindb.model.BigChainDBGlobals;
import com.bigchaindb.model.GenericCallback;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;

public class NetworkUtils {
    private static String bodyToString(Request request) {
        try {
            Request copy = request.newBuilder().build();
            Buffer buffer = new Buffer();
            copy.body().writeTo((BufferedSink)buffer);
            return buffer.readUtf8();
        }
        catch (IOException e) {
            return "did not work";
        }
    }

    public static void sendPostRequest(String url, RequestBody body, final GenericCallback callback) {
        Request request = new Request.Builder().url(url).post(body).build();
        BigChainDBGlobals.getHttpClient().newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                BigChainDBGlobals.setConnected(false);
            }

            public void onResponse(Call call, Response response) {
                if (response.code() == 202) {
                    callback.pushedSuccessfully(response);
                } else if (response.code() == 400) {
                    callback.transactionMalformed(response);
                } else {
                    callback.otherError(response);
                }
                BigChainDBGlobals.setConnected(true);
                response.close();
            }
        });
    }

    public static Response sendPostRequest(String url, RequestBody body) throws IOException {
        Response response = null;
        try {
            Request request = new Request.Builder().url(url).post(body).build();
            response = BigChainDBGlobals.getHttpClient().newCall(request).execute();
            BigChainDBGlobals.setConnected(true);
        }
        catch (IOException e) {
            BigChainDBGlobals.setConnected(false);
            throw new IOException();
        }
        return response;
    }

    public static Response sendGetRequest(String url) throws IOException {
        Response response = null;
        try {
            Request request = new Request.Builder().url(url).get().build();
            response = BigChainDBGlobals.getHttpClient().newCall(request).execute();
            BigChainDBGlobals.setConnected(true);
        }
        catch (IOException e) {
            BigChainDBGlobals.setConnected(false);
            throw new IOException();
        }
        return response;
    }
}

