/*
 * Decompiled with CFR 0.152.
 */
package com.bigchaindb.cryptoconditions;

import com.bigchaindb.cryptoconditions.CompoundCondition;
import com.bigchaindb.cryptoconditions.Condition;
import com.bigchaindb.cryptoconditions.ConditionType;
import com.bigchaindb.cryptoconditions.der.DEROutputStream;
import com.bigchaindb.cryptoconditions.der.DERTags;
import com.google.api.client.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.util.Arrays;

public abstract class ConditionBase
implements Condition {
    private long cost;
    private URI uri;
    private byte[] encoded;

    protected ConditionBase(long cost) {
        this.cost = cost;
    }

    @Override
    public long getCost() {
        return this.cost;
    }

    @Override
    public byte[] getEncoded() {
        if (this.encoded == null) {
            try {
                byte[] buffer;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DEROutputStream out = new DEROutputStream(baos);
                out.writeTaggedObject(0, this.getFingerprint());
                out.writeTaggedObject(1, BigInteger.valueOf(this.getCost()).toByteArray());
                if (this instanceof CompoundCondition) {
                    buffer = ConditionType.getEnumOfTypesAsBitString(((CompoundCondition)((Object)this)).getSubtypes());
                    out.writeTaggedObject(2, buffer);
                }
                out.close();
                buffer = baos.toByteArray();
                baos = new ByteArrayOutputStream();
                out = new DEROutputStream(baos);
                out.writeEncoded(DERTags.CONSTRUCTED.getTag() + DERTags.TAGGED.getTag() + this.getType().getTypeCode(), buffer);
                out.close();
                return baos.toByteArray();
            }
            catch (IOException var4) {
                throw new RuntimeException("DER Encoding Error.", var4);
            }
        }
        byte[] returnVal = new byte[this.encoded.length];
        System.arraycopy(this.encoded, 0, returnVal, 0, this.encoded.length);
        return returnVal;
    }

    @Override
    public URI getUri() {
        if (this.uri == null) {
            CompoundCondition cc;
            StringBuilder sb = new StringBuilder();
            sb.append("ni:///").append("sha-256;").append(Base64.encodeBase64URLSafeString((byte[])this.getFingerprint())).append("?").append("fpt=").append(this.getType().toString().toLowerCase()).append("&cost=").append(this.getCost());
            if (this instanceof CompoundCondition && (cc = (CompoundCondition)((Object)this)).getSubtypes() != null && !cc.getSubtypes().isEmpty()) {
                sb.append("&subtypes=").append(ConditionType.getEnumOfTypesAsString(cc.getSubtypes()));
            }
            this.uri = URI.create(sb.toString());
        }
        return this.uri;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition other = (Condition)obj;
        if (this.getType() != other.getType()) {
            return false;
        }
        if (this.getCost() != other.getCost()) {
            return false;
        }
        return Arrays.equals(this.getFingerprint(), other.getFingerprint());
    }

    public String toString() {
        return this.getUri().toString();
    }
}

