/*
 * Decompiled with CFR 0.152.
 */
package com.bigchaindb.cryptoconditions.der;

import com.bigchaindb.cryptoconditions.Condition;
import com.bigchaindb.cryptoconditions.ConditionType;
import com.bigchaindb.cryptoconditions.Fulfillment;
import com.bigchaindb.cryptoconditions.der.DEREncodingException;
import com.bigchaindb.cryptoconditions.der.DERInputStream;
import com.bigchaindb.cryptoconditions.der.DERTags;
import com.bigchaindb.cryptoconditions.types.Ed25519Sha256Condition;
import com.bigchaindb.cryptoconditions.types.Ed25519Sha256Fulfillment;
import com.bigchaindb.cryptoconditions.types.PrefixSha256Condition;
import com.bigchaindb.cryptoconditions.types.PrefixSha256Fulfillment;
import com.bigchaindb.cryptoconditions.types.PreimageSha256Condition;
import com.bigchaindb.cryptoconditions.types.PreimageSha256Fulfillment;
import com.bigchaindb.cryptoconditions.types.RsaSha256Condition;
import com.bigchaindb.cryptoconditions.types.RsaSha256Fulfillment;
import com.bigchaindb.cryptoconditions.types.ThresholdSha256Condition;
import com.bigchaindb.cryptoconditions.types.ThresholdSha256Fulfillment;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;

public class CryptoConditionReader {
    public static Condition readCondition(byte[] buffer) throws DEREncodingException {
        return CryptoConditionReader.readCondition(buffer, 0, buffer.length);
    }

    public static Condition readCondition(byte[] buffer, int offset, int length) throws DEREncodingException {
        Condition var6;
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer, offset, length);
        DERInputStream in = new DERInputStream(bais);
        try {
            Condition c;
            var6 = c = CryptoConditionReader.readCondition(in);
        }
        catch (IOException var15) {
            throw new UncheckedIOException(var15);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException var14) {
                throw new UncheckedIOException(var14);
            }
        }
        return var6;
    }

    public static Condition readCondition(DERInputStream in) throws DEREncodingException, IOException {
        return CryptoConditionReader.readCondition(in, new AtomicInteger());
    }

    public static Condition readCondition(DERInputStream in, AtomicInteger bytesRead) throws DEREncodingException, IOException {
        int tag = in.readTag(bytesRead, DERTags.CONSTRUCTED, DERTags.TAGGED);
        ConditionType type = ConditionType.valueOf(tag);
        int length = in.readLength(bytesRead);
        AtomicInteger innerBytesRead = new AtomicInteger();
        byte[] fingerprint = in.readTaggedObject(0, length - innerBytesRead.get(), innerBytesRead).getValue();
        long cost = new BigInteger(in.readTaggedObject(1, length - innerBytesRead.get(), innerBytesRead).getValue()).longValue();
        EnumSet<ConditionType> subtypes = null;
        if (type == ConditionType.PREFIX_SHA256 || type == ConditionType.THRESHOLD_SHA256) {
            subtypes = ConditionType.getEnumOfTypesFromBitString(in.readTaggedObject(2, length - innerBytesRead.get(), innerBytesRead).getValue());
        }
        bytesRead.addAndGet(innerBytesRead.get());
        switch (type) {
            case PREIMAGE_SHA256: {
                return new PreimageSha256Condition(fingerprint, cost);
            }
            case PREFIX_SHA256: {
                return new PrefixSha256Condition(fingerprint, cost, subtypes);
            }
            case THRESHOLD_SHA256: {
                return new ThresholdSha256Condition(fingerprint, cost, subtypes);
            }
            case RSA_SHA256: {
                return new RsaSha256Condition(fingerprint, cost);
            }
            case ED25519_SHA256: {
                return new Ed25519Sha256Condition(fingerprint, cost);
            }
        }
        throw new DEREncodingException("Unrecogized tag: " + tag);
    }

    public static Fulfillment readFulfillment(byte[] buffer) throws DEREncodingException {
        return CryptoConditionReader.readFulfillment(buffer, 0, buffer.length);
    }

    public static Fulfillment readFulfillment(byte[] buffer, int offset, int length) throws DEREncodingException {
        Fulfillment var5;
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer, offset, length);
        DERInputStream in = new DERInputStream(bais);
        try {
            var5 = CryptoConditionReader.readFulfillment(in);
        }
        catch (IOException var14) {
            throw new UncheckedIOException(var14);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException var13) {
                throw new UncheckedIOException(var13);
            }
        }
        return var5;
    }

    public static Fulfillment readFulfillment(DERInputStream in) throws DEREncodingException, IOException {
        return CryptoConditionReader.readFulfillment(in, new AtomicInteger());
    }

    public static Fulfillment readFulfillment(DERInputStream in, AtomicInteger bytesRead) throws DEREncodingException, IOException {
        int tag = in.readTag(bytesRead, DERTags.CONSTRUCTED, DERTags.TAGGED);
        ConditionType type = ConditionType.valueOf(tag);
        int length = in.readLength(bytesRead);
        if (length == 0) {
            throw new DEREncodingException("Encountered an empty fulfillment.");
        }
        AtomicInteger innerBytesRead = new AtomicInteger();
        switch (type) {
            case PREIMAGE_SHA256: {
                byte[] preimage = in.readTaggedObject(0, length - innerBytesRead.get(), innerBytesRead).getValue();
                bytesRead.addAndGet(innerBytesRead.get());
                return new PreimageSha256Fulfillment(preimage);
            }
            case PREFIX_SHA256: {
                byte[] prefix = in.readTaggedObject(0, length - innerBytesRead.get(), innerBytesRead).getValue();
                long maxMessageLength = new BigInteger(in.readTaggedObject(1, length - innerBytesRead.get(), innerBytesRead).getValue()).longValue();
                in.readTag(2, innerBytesRead, DERTags.CONSTRUCTED, DERTags.TAGGED);
                in.readLength(innerBytesRead);
                Fulfillment subfulfillment = CryptoConditionReader.readFulfillment(in, innerBytesRead);
                bytesRead.addAndGet(innerBytesRead.get());
                return new PrefixSha256Fulfillment(prefix, maxMessageLength, subfulfillment);
            }
            case THRESHOLD_SHA256: {
                ArrayList<Fulfillment> subfulfillments = new ArrayList<Fulfillment>();
                tag = in.readTag(innerBytesRead, DERTags.CONSTRUCTED, DERTags.TAGGED);
                length = in.readLength(innerBytesRead);
                if (tag == 0) {
                    AtomicInteger subfulfillmentsBytesRead = new AtomicInteger();
                    while (subfulfillmentsBytesRead.get() < length) {
                        subfulfillments.add(CryptoConditionReader.readFulfillment(in, subfulfillmentsBytesRead));
                    }
                    innerBytesRead.addAndGet(subfulfillmentsBytesRead.get());
                    in.readTag(1, innerBytesRead, DERTags.CONSTRUCTED, DERTags.TAGGED);
                    length = in.readLength(innerBytesRead);
                } else if (tag != 1) {
                    throw new DEREncodingException("Expected tag: 1, got: " + tag);
                }
                ArrayList<Condition> subconditions = new ArrayList<Condition>();
                AtomicInteger subconditionsBytesRead = new AtomicInteger();
                while (subconditionsBytesRead.get() < length) {
                    subconditions.add(CryptoConditionReader.readCondition(in, subconditionsBytesRead));
                }
                innerBytesRead.addAndGet(subconditionsBytesRead.get());
                bytesRead.addAndGet(innerBytesRead.get());
                return new ThresholdSha256Fulfillment(subconditions.toArray(new Condition[subconditions.size()]), subfulfillments.toArray(new Fulfillment[subfulfillments.size()]));
            }
            case RSA_SHA256: {
                BigInteger modulus = new BigInteger(in.readTaggedObject(0, length - innerBytesRead.get(), innerBytesRead).getValue());
                byte[] rsaSignature = in.readTaggedObject(1, length - innerBytesRead.get(), innerBytesRead).getValue();
                bytesRead.addAndGet(innerBytesRead.get());
                RSAPublicKeySpec rsaSpec = new RSAPublicKeySpec(modulus, RsaSha256Fulfillment.PUBLIC_EXPONENT);
                try {
                    KeyFactory rsaKeyFactory = KeyFactory.getInstance("RSA");
                    PublicKey publicKey = rsaKeyFactory.generatePublic(rsaSpec);
                    return new RsaSha256Fulfillment((RSAPublicKey)publicKey, rsaSignature);
                }
                catch (NoSuchAlgorithmException | InvalidKeySpecException var21) {
                    throw new RuntimeException("Error creating RSA key.", var21);
                }
            }
            case ED25519_SHA256: {
                byte[] ed25519key = in.readTaggedObject(0, length - innerBytesRead.get(), innerBytesRead).getValue();
                byte[] ed25519Signature = in.readTaggedObject(1, length - innerBytesRead.get(), innerBytesRead).getValue();
                bytesRead.addAndGet(innerBytesRead.get());
                EdDSAPublicKeySpec ed25519spec = new EdDSAPublicKeySpec(ed25519key, (EdDSAParameterSpec)EdDSANamedCurveTable.getByName((String)"ed25519-sha-512"));
                EdDSAPublicKey ed25519PublicKey = new EdDSAPublicKey(ed25519spec);
                return new Ed25519Sha256Fulfillment(ed25519PublicKey, ed25519Signature);
            }
        }
        throw new DEREncodingException("Unrecogized tag: " + tag);
    }
}

