/*
 * Decompiled with CFR 0.152.
 */
package com.bigchaindb.cryptoconditions.types;

import com.bigchaindb.cryptoconditions.Condition;
import com.bigchaindb.cryptoconditions.ConditionType;
import com.bigchaindb.cryptoconditions.Fulfillment;
import com.bigchaindb.cryptoconditions.der.DEROutputStream;
import com.bigchaindb.cryptoconditions.types.Ed25519Sha256Condition;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSAPublicKey;

public class Ed25519Sha256Fulfillment
implements Fulfillment {
    private Ed25519Sha256Condition condition;
    private EdDSAPublicKey publicKey;
    private byte[] signature;
    private static MessageDigest _DIGEST;

    public Ed25519Sha256Fulfillment(EdDSAPublicKey publicKey, byte[] signature) {
        this.signature = new byte[signature.length];
        System.arraycopy(signature, 0, this.signature, 0, signature.length);
        this.publicKey = publicKey;
    }

    @Override
    public ConditionType getType() {
        return ConditionType.ED25519_SHA256;
    }

    public EdDSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] getSignature() {
        byte[] signature = new byte[this.signature.length];
        System.arraycopy(this.signature, 0, signature, 0, this.signature.length);
        return signature;
    }

    @Override
    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DEROutputStream out = new DEROutputStream(baos);
            out.writeTaggedObject(0, this.publicKey.getA().toByteArray());
            out.writeTaggedObject(1, this.signature);
            out.close();
            byte[] buffer = baos.toByteArray();
            baos = new ByteArrayOutputStream();
            out = new DEROutputStream(baos);
            out.writeTaggedConstructedObject(this.getType().getTypeCode(), buffer);
            out.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("DER Encoding Error", e);
        }
    }

    @Override
    public Ed25519Sha256Condition getCondition() {
        if (this.condition == null) {
            this.condition = new Ed25519Sha256Condition(this.publicKey);
        }
        return this.condition;
    }

    @Override
    public boolean verify(Condition condition, byte[] message) {
        if (condition == null) {
            throw new IllegalArgumentException("Can't verify a Ed25519Sha256Fulfillment against an null condition.");
        }
        if (!(condition instanceof Ed25519Sha256Condition)) {
            throw new IllegalArgumentException("Must verify a Ed25519Sha256Fulfillment against Ed25519Sha256Condition.");
        }
        if (!this.getCondition().equals(condition)) {
            return false;
        }
        try {
            EdDSAEngine edDsaSigner = new EdDSAEngine(Ed25519Sha256Fulfillment.getSha512Digest());
            edDsaSigner.initVerify((PublicKey)this.publicKey);
            edDsaSigner.update(message);
            return edDsaSigner.verify(this.signature);
        }
        catch (InvalidKeyException | SignatureException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static MessageDigest getSha512Digest() {
        if (_DIGEST == null) {
            try {
                _DIGEST = MessageDigest.getInstance("SHA-512");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return _DIGEST;
    }
}

