/*
 * Decompiled with CFR 0.152.
 */
package com.bigchaindb.cryptoconditions.types;

import com.bigchaindb.cryptoconditions.Condition;
import com.bigchaindb.cryptoconditions.ConditionType;
import com.bigchaindb.cryptoconditions.Fulfillment;
import com.bigchaindb.cryptoconditions.UnsignedBigInteger;
import com.bigchaindb.cryptoconditions.der.DEROutputStream;
import com.bigchaindb.cryptoconditions.types.RsaSha256Condition;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;

public class RsaSha256Fulfillment
implements Fulfillment {
    public static final BigInteger PUBLIC_EXPONENT = BigInteger.valueOf(65537L);
    private RsaSha256Condition condition;
    private RSAPublicKey publicKey;
    private byte[] signature;

    public RsaSha256Fulfillment(RSAPublicKey publicKey, byte[] signature) {
        this.signature = new byte[signature.length];
        System.arraycopy(signature, 0, this.signature, 0, signature.length);
        this.publicKey = publicKey;
    }

    @Override
    public ConditionType getType() {
        return ConditionType.RSA_SHA256;
    }

    public RSAPublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] getSignature() {
        byte[] signature = new byte[this.signature.length];
        System.arraycopy(this.signature, 0, signature, 0, this.signature.length);
        return signature;
    }

    @Override
    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DEROutputStream out = new DEROutputStream(baos);
            out.writeTaggedObject(0, UnsignedBigInteger.toUnsignedByteArray(this.publicKey.getModulus()));
            out.writeTaggedObject(1, this.signature);
            out.close();
            byte[] buffer = baos.toByteArray();
            baos = new ByteArrayOutputStream();
            out = new DEROutputStream(baos);
            out.writeTaggedConstructedObject(this.getType().getTypeCode(), buffer);
            out.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("DER Encoding Error", e);
        }
    }

    @Override
    public RsaSha256Condition getCondition() {
        if (this.condition == null) {
            this.condition = new RsaSha256Condition(this.publicKey);
        }
        return this.condition;
    }

    @Override
    public boolean verify(Condition condition, byte[] message) {
        if (condition == null) {
            throw new IllegalArgumentException("Can't verify a RsaSha256Fulfillment against an null condition.");
        }
        if (!(condition instanceof RsaSha256Condition)) {
            throw new IllegalArgumentException("Must verify a RsaSha256Fulfillment against RsaSha256Condition.");
        }
        if (!this.getCondition().equals(condition)) {
            return false;
        }
        try {
            Signature rsaSigner = Signature.getInstance("SHA256withRSA/PSS");
            rsaSigner.initVerify(this.publicKey);
            rsaSigner.update(message);
            return rsaSigner.verify(this.signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            e.printStackTrace();
            return false;
        }
    }
}

