/*
 * Decompiled with CFR 0.152.
 */
package com.bigdullrock.spring.boot.nifty;

import com.bigdullrock.spring.boot.nifty.NiftyHandler;
import com.bigdullrock.spring.boot.nifty.autoconfigure.NiftyAutoConfiguration;
import com.bigdullrock.spring.boot.nifty.autoconfigure.NiftyServerProperties;
import com.facebook.nifty.core.NettyServerTransport;
import com.facebook.nifty.core.ThriftServerDef;
import com.facebook.nifty.core.ThriftServerDefBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.thrift.TMultiplexedProcessor;
import org.apache.thrift.TProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.target.SingletonTargetSource;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;

@Configuration
public class NiftyServerRunner
implements ApplicationRunner,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(NiftyServerRunner.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private NiftyServerProperties niftyServerProperties;
    @Autowired
    private NiftyAutoConfiguration.NiftyConfigurer niftyConfigurer;
    private NettyServerTransport nettyServer;

    public void run(ApplicationArguments args) throws Exception {
        TMultiplexedProcessor multiplexedProcessor = new TMultiplexedProcessor();
        for (Map.Entry niftyHandler : this.applicationContext.getBeansWithAnnotation(NiftyHandler.class).entrySet()) {
            List<Class<?>> handlerInterfaces = this.findAllInterfaces(niftyHandler.getValue().getClass());
            Map<String, Class<?>> classes = this.getInterfaceAndProcessor(handlerInterfaces);
            Class<?> ifaceClass = classes.get("ifaceClass");
            Class<TProcessor> processorClass = classes.get("processorClass");
            Object wrappedHandler = this.wrapHandler(ifaceClass, niftyHandler.getValue());
            TProcessor tproc = this.createTProcessor(ifaceClass, processorClass, wrappedHandler);
            String processorName = ifaceClass.getEnclosingClass().getSimpleName();
            LOG.info("Registering Nifty processor {}: {}", (Object)processorName, (Object)tproc);
            multiplexedProcessor.registerProcessor(processorName, tproc);
        }
        ThriftServerDefBuilder thriftServerDefBuilder = (ThriftServerDefBuilder)new ThriftServerDefBuilder().withProcessor((TProcessor)multiplexedProcessor);
        if (this.niftyServerProperties != null) {
            if (this.niftyServerProperties.getPort() != null) {
                thriftServerDefBuilder.listen(this.niftyServerProperties.getPort().intValue());
            }
            thriftServerDefBuilder.protocol(this.niftyServerProperties.getProtocolType().getProtocolFactory());
        }
        ThriftServerDef serverDef = thriftServerDefBuilder.build();
        LOG.info("Starting Nifty Server on port {}", (Object)serverDef.getServerPort());
        if (this.nettyServer == null) {
            this.nettyServer = new NettyServerTransport(serverDef);
        }
        this.nettyServer.start();
    }

    private Map<String, Class<?>> getInterfaceAndProcessor(List<Class<?>> handlerInterfaces) throws NoSuchMethodException, ClassNotFoundException {
        HashMap classes = new HashMap();
        Class<?> ifaceClass = null;
        Class<?> processorClass = null;
        block0: for (Class<?> handlerInterfaceClass : handlerInterfaces) {
            if (!handlerInterfaceClass.getName().endsWith("$Iface") || handlerInterfaceClass.getDeclaringClass() == null) continue;
            for (Class<?> innerClass : handlerInterfaceClass.getDeclaringClass().getDeclaredClasses()) {
                if (!innerClass.getName().endsWith("$Processor") || !TProcessor.class.isAssignableFrom(innerClass)) continue;
                if (ifaceClass != null) {
                    throw new IllegalStateException("Multiple Thrift Ifaces defined on handler");
                }
                ifaceClass = handlerInterfaceClass;
                processorClass = innerClass;
                continue block0;
            }
        }
        if (ifaceClass == null) {
            throw new IllegalStateException("No Thrift Ifaces found on handler: " + ifaceClass);
        }
        classes.put("ifaceClass", ifaceClass);
        classes.put("processorClass", processorClass);
        return classes;
    }

    private <T> TProcessor createTProcessor(Class<?> iFaceClass, Class<TProcessor> processorClass, T wrappedHandler) throws BeanInstantiationException, NoSuchMethodException, SecurityException {
        return (TProcessor)BeanUtils.instantiateClass(processorClass.getConstructor(iFaceClass), (Object[])new Object[]{wrappedHandler});
    }

    private List<Class<?>> findAllInterfaces(Class<?> handlerClass) throws ClassNotFoundException {
        ArrayList handlerInterfaces = new ArrayList();
        handlerInterfaces.addAll(Arrays.asList(handlerClass.getInterfaces()));
        handlerInterfaces.addAll(Arrays.asList(Class.forName(handlerClass.getSuperclass().getName()).getInterfaces()));
        handlerInterfaces.add(handlerClass.getSuperclass());
        return handlerInterfaces;
    }

    private <T> T wrapHandler(Class<T> interfaceClass, T handler) {
        ProxyFactory proxyFactory = new ProxyFactory(interfaceClass, (TargetSource)new SingletonTargetSource(handler));
        this.niftyConfigurer.configureProxyFactory(proxyFactory);
        proxyFactory.setFrozen(true);
        return (T)proxyFactory.getProxy();
    }

    public void destroy() throws Exception {
        if (this.nettyServer != null) {
            this.nettyServer.stop();
        }
    }
}

