/*
 * Decompiled with CFR 0.152.
 */
package com.bigdullrock.spring.boot.nifty.autoconfigure;

import com.bigdullrock.spring.boot.nifty.NiftyHandler;
import com.bigdullrock.spring.boot.nifty.NiftyServerRunner;
import com.bigdullrock.spring.boot.nifty.aop.ExceptionsNiftyMethodInterceptor;
import com.bigdullrock.spring.boot.nifty.autoconfigure.NiftyServerProperties;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={NiftyHandler.class})
@EnableConfigurationProperties(value={NiftyServerProperties.class})
public class NiftyAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={NiftyConfigurer.class})
    public NiftyConfigurer niftyConfigurer() {
        return new DefaultNiftyConfigurer();
    }

    @Bean
    public NiftyServerRunner niftyServerRunner() {
        return new NiftyServerRunner();
    }

    public static class DefaultNiftyConfigurer
    implements NiftyConfigurer {
        @Override
        public void configureProxyFactory(ProxyFactory proxyFactory) {
            proxyFactory.setOptimize(true);
            proxyFactory.addAdvice((Advice)new ExceptionsNiftyMethodInterceptor());
        }
    }

    public static interface NiftyConfigurer {
        public void configureProxyFactory(ProxyFactory var1);
    }
}

