/*
 * Decompiled with CFR 0.152.
 */
package com.bignerdranch.expandablerecyclerview;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.bignerdranch.expandablerecyclerview.ChildViewHolder;
import com.bignerdranch.expandablerecyclerview.ParentViewHolder;
import com.bignerdranch.expandablerecyclerview.model.ExpandableWrapper;
import com.bignerdranch.expandablerecyclerview.model.Parent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ExpandableRecyclerAdapter<P extends Parent<C>, C, PVH extends ParentViewHolder, CVH extends ChildViewHolder>
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final String EXPANDED_STATE_MAP = "ExpandableRecyclerAdapter.ExpandedStateMap";
    public static final int TYPE_PARENT = 0;
    public static final int TYPE_CHILD = 1;
    public static final int TYPE_FIRST_USER = 2;
    private static final int INVALID_FLAT_POSITION = -1;
    @NonNull
    protected List<ExpandableWrapper<P, C>> mFlatItemList;
    @NonNull
    private List<P> mParentList;
    @Nullable
    private ExpandCollapseListener mExpandCollapseListener;
    @NonNull
    private List<RecyclerView> mAttachedRecyclerViewPool;
    private Map<P, Boolean> mExpansionStateMap;
    private ParentViewHolder.ParentViewHolderExpandCollapseListener mParentViewHolderExpandCollapseListener = new ParentViewHolder.ParentViewHolderExpandCollapseListener(){

        @Override
        @UiThread
        public void onParentExpanded(int flatParentPosition) {
            ExpandableRecyclerAdapter.this.parentExpandedFromViewHolder(flatParentPosition);
        }

        @Override
        @UiThread
        public void onParentCollapsed(int flatParentPosition) {
            ExpandableRecyclerAdapter.this.parentCollapsedFromViewHolder(flatParentPosition);
        }
    };

    public ExpandableRecyclerAdapter(@NonNull List<P> parentList) {
        this.mParentList = parentList;
        this.mFlatItemList = this.generateFlattenedParentChildList(parentList);
        this.mAttachedRecyclerViewPool = new ArrayList<RecyclerView>();
        this.mExpansionStateMap = new HashMap<P, Boolean>(this.mParentList.size());
    }

    @NonNull
    @UiThread
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int viewType) {
        if (this.isParentViewType(viewType)) {
            PVH pvh = this.onCreateParentViewHolder(viewGroup, viewType);
            ((ParentViewHolder)((Object)pvh)).setParentViewHolderExpandCollapseListener(this.mParentViewHolderExpandCollapseListener);
            ((ParentViewHolder)((Object)pvh)).mExpandableAdapter = this;
            return pvh;
        }
        CVH cvh = this.onCreateChildViewHolder(viewGroup, viewType);
        ((ChildViewHolder)((Object)cvh)).mExpandableAdapter = this;
        return cvh;
    }

    @UiThread
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int flatPosition) {
        if (flatPosition > this.mFlatItemList.size()) {
            throw new IllegalStateException("Trying to bind item out of bounds, size " + this.mFlatItemList.size() + " flatPosition " + flatPosition + ". Was the data changed without a call to notify...()?");
        }
        ExpandableWrapper<P, C> listItem = this.mFlatItemList.get(flatPosition);
        if (listItem.isParent()) {
            ParentViewHolder parentViewHolder = (ParentViewHolder)holder;
            if (parentViewHolder.shouldItemViewClickToggleExpansion()) {
                parentViewHolder.setMainItemClickToExpand();
            }
            parentViewHolder.setExpanded(listItem.isExpanded());
            parentViewHolder.mParent = listItem.getParent();
            this.onBindParentViewHolder(parentViewHolder, this.getNearestParentPosition(flatPosition), listItem.getParent());
        } else {
            ChildViewHolder childViewHolder = (ChildViewHolder)holder;
            childViewHolder.mChild = listItem.getChild();
            this.onBindChildViewHolder(childViewHolder, this.getNearestParentPosition(flatPosition), this.getChildPosition(flatPosition), listItem.getChild());
        }
    }

    @NonNull
    @UiThread
    public abstract PVH onCreateParentViewHolder(@NonNull ViewGroup var1, int var2);

    @NonNull
    @UiThread
    public abstract CVH onCreateChildViewHolder(@NonNull ViewGroup var1, int var2);

    @UiThread
    public abstract void onBindParentViewHolder(@NonNull PVH var1, int var2, @NonNull P var3);

    @UiThread
    public abstract void onBindChildViewHolder(@NonNull CVH var1, int var2, int var3, @NonNull C var4);

    @UiThread
    public int getItemCount() {
        return this.mFlatItemList.size();
    }

    @UiThread
    public int getItemViewType(int flatPosition) {
        ExpandableWrapper<P, C> listItem = this.mFlatItemList.get(flatPosition);
        if (listItem.isParent()) {
            return this.getParentViewType(this.getNearestParentPosition(flatPosition));
        }
        return this.getChildViewType(this.getNearestParentPosition(flatPosition), this.getChildPosition(flatPosition));
    }

    public int getParentViewType(int parentPosition) {
        return 0;
    }

    public int getChildViewType(int parentPosition, int childPosition) {
        return 1;
    }

    public boolean isParentViewType(int viewType) {
        return viewType == 0;
    }

    @NonNull
    @UiThread
    public List<P> getParentList() {
        return this.mParentList;
    }

    @UiThread
    public void setParentList(@NonNull List<P> parentList, boolean preserveExpansionState) {
        this.mParentList = parentList;
        this.notifyParentDataSetChanged(preserveExpansionState);
    }

    @UiThread
    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.mAttachedRecyclerViewPool.add(recyclerView);
    }

    @UiThread
    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        this.mAttachedRecyclerViewPool.remove(recyclerView);
    }

    @UiThread
    public void setExpandCollapseListener(@Nullable ExpandCollapseListener expandCollapseListener) {
        this.mExpandCollapseListener = expandCollapseListener;
    }

    @UiThread
    protected void parentExpandedFromViewHolder(int flatParentPosition) {
        ExpandableWrapper<P, C> parentWrapper = this.mFlatItemList.get(flatParentPosition);
        this.updateExpandedParent(parentWrapper, flatParentPosition, true);
    }

    @UiThread
    protected void parentCollapsedFromViewHolder(int flatParentPosition) {
        ExpandableWrapper<P, C> parentWrapper = this.mFlatItemList.get(flatParentPosition);
        this.updateCollapsedParent(parentWrapper, flatParentPosition, true);
    }

    @UiThread
    public void expandParent(@NonNull P parent) {
        ExpandableWrapper parentWrapper = new ExpandableWrapper(parent);
        int flatParentPosition = this.mFlatItemList.indexOf(parentWrapper);
        if (flatParentPosition == -1) {
            return;
        }
        this.expandViews(this.mFlatItemList.get(flatParentPosition), flatParentPosition);
    }

    @UiThread
    public void expandParent(int parentPosition) {
        this.expandParent((Parent)this.mParentList.get(parentPosition));
    }

    @UiThread
    public void expandParentRange(int startParentPosition, int parentCount) {
        int endParentPosition = startParentPosition + parentCount;
        for (int i = startParentPosition; i < endParentPosition; ++i) {
            this.expandParent(i);
        }
    }

    @UiThread
    public void expandAllParents() {
        for (Parent parent : this.mParentList) {
            this.expandParent(parent);
        }
    }

    @UiThread
    public void collapseParent(@NonNull P parent) {
        ExpandableWrapper parentWrapper = new ExpandableWrapper(parent);
        int flatParentPosition = this.mFlatItemList.indexOf(parentWrapper);
        if (flatParentPosition == -1) {
            return;
        }
        this.collapseViews(this.mFlatItemList.get(flatParentPosition), flatParentPosition);
    }

    @UiThread
    public void collapseParent(int parentPosition) {
        this.collapseParent((Parent)this.mParentList.get(parentPosition));
    }

    @UiThread
    public void collapseParentRange(int startParentPosition, int parentCount) {
        int endParentPosition = startParentPosition + parentCount;
        for (int i = startParentPosition; i < endParentPosition; ++i) {
            this.collapseParent(i);
        }
    }

    @UiThread
    public void collapseAllParents() {
        for (Parent parent : this.mParentList) {
            this.collapseParent(parent);
        }
    }

    @UiThread
    public void onSaveInstanceState(@NonNull Bundle savedInstanceState) {
        savedInstanceState.putSerializable(EXPANDED_STATE_MAP, this.generateExpandedStateMap());
    }

    @UiThread
    public void onRestoreInstanceState(@Nullable Bundle savedInstanceState) {
        if (savedInstanceState == null || !savedInstanceState.containsKey(EXPANDED_STATE_MAP)) {
            return;
        }
        HashMap expandedStateMap = (HashMap)savedInstanceState.getSerializable(EXPANDED_STATE_MAP);
        if (expandedStateMap == null) {
            return;
        }
        ArrayList<ExpandableWrapper<P, C>> itemList = new ArrayList<ExpandableWrapper<P, C>>();
        int parentsCount = this.mParentList.size();
        for (int i = 0; i < parentsCount; ++i) {
            ExpandableWrapper parentWrapper = new ExpandableWrapper((Parent)this.mParentList.get(i));
            itemList.add(parentWrapper);
            if (!expandedStateMap.containsKey(i)) continue;
            boolean expanded = (Boolean)expandedStateMap.get(i);
            parentWrapper.setExpanded(expanded);
            if (!expanded) continue;
            List wrappedChildList = parentWrapper.getWrappedChildList();
            int childrenCount = wrappedChildList.size();
            for (int j = 0; j < childrenCount; ++j) {
                ExpandableWrapper childWrapper = wrappedChildList.get(j);
                itemList.add(childWrapper);
            }
        }
        this.mFlatItemList = itemList;
        this.notifyDataSetChanged();
    }

    @UiThread
    private void expandViews(@NonNull ExpandableWrapper<P, C> parentWrapper, int flatParentPosition) {
        for (RecyclerView recyclerView : this.mAttachedRecyclerViewPool) {
            ParentViewHolder viewHolder = (ParentViewHolder)recyclerView.findViewHolderForAdapterPosition(flatParentPosition);
            if (viewHolder == null || viewHolder.isExpanded()) continue;
            viewHolder.setExpanded(true);
            viewHolder.onExpansionToggled(false);
        }
        this.updateExpandedParent(parentWrapper, flatParentPosition, false);
    }

    @UiThread
    private void collapseViews(@NonNull ExpandableWrapper<P, C> parentWrapper, int flatParentPosition) {
        for (RecyclerView recyclerView : this.mAttachedRecyclerViewPool) {
            ParentViewHolder viewHolder = (ParentViewHolder)recyclerView.findViewHolderForAdapterPosition(flatParentPosition);
            if (viewHolder == null || !viewHolder.isExpanded()) continue;
            viewHolder.setExpanded(false);
            viewHolder.onExpansionToggled(true);
        }
        this.updateCollapsedParent(parentWrapper, flatParentPosition, false);
    }

    @UiThread
    private void updateExpandedParent(@NonNull ExpandableWrapper<P, C> parentWrapper, int flatParentPosition, boolean expansionTriggeredByListItemClick) {
        if (parentWrapper.isExpanded()) {
            return;
        }
        parentWrapper.setExpanded(true);
        this.mExpansionStateMap.put(parentWrapper.getParent(), true);
        List<ExpandableWrapper<P, C>> wrappedChildList = parentWrapper.getWrappedChildList();
        if (wrappedChildList != null) {
            int childCount = wrappedChildList.size();
            for (int i = 0; i < childCount; ++i) {
                this.mFlatItemList.add(flatParentPosition + i + 1, wrappedChildList.get(i));
            }
            this.notifyItemRangeInserted(flatParentPosition + 1, childCount);
        }
        if (expansionTriggeredByListItemClick && this.mExpandCollapseListener != null) {
            this.mExpandCollapseListener.onParentExpanded(this.getNearestParentPosition(flatParentPosition));
        }
    }

    @UiThread
    private void updateCollapsedParent(@NonNull ExpandableWrapper<P, C> parentWrapper, int flatParentPosition, boolean collapseTriggeredByListItemClick) {
        if (!parentWrapper.isExpanded()) {
            return;
        }
        parentWrapper.setExpanded(false);
        this.mExpansionStateMap.put(parentWrapper.getParent(), false);
        List<ExpandableWrapper<P, C>> wrappedChildList = parentWrapper.getWrappedChildList();
        if (wrappedChildList != null) {
            int childCount = wrappedChildList.size();
            for (int i = childCount - 1; i >= 0; --i) {
                this.mFlatItemList.remove(flatParentPosition + i + 1);
            }
            this.notifyItemRangeRemoved(flatParentPosition + 1, childCount);
        }
        if (collapseTriggeredByListItemClick && this.mExpandCollapseListener != null) {
            this.mExpandCollapseListener.onParentCollapsed(this.getNearestParentPosition(flatParentPosition));
        }
    }

    @UiThread
    int getNearestParentPosition(int flatPosition) {
        if (flatPosition == 0) {
            return 0;
        }
        int parentCount = -1;
        for (int i = 0; i <= flatPosition; ++i) {
            ExpandableWrapper<P, C> listItem = this.mFlatItemList.get(i);
            if (!listItem.isParent()) continue;
            ++parentCount;
        }
        return parentCount;
    }

    @UiThread
    int getChildPosition(int flatPosition) {
        if (flatPosition == 0) {
            return 0;
        }
        int childCount = 0;
        for (int i = 0; i < flatPosition; ++i) {
            ExpandableWrapper<P, C> listItem = this.mFlatItemList.get(i);
            if (listItem.isParent()) {
                childCount = 0;
                continue;
            }
            ++childCount;
        }
        return childCount;
    }

    @UiThread
    public void notifyParentDataSetChanged(boolean preserveExpansionState) {
        this.mFlatItemList = preserveExpansionState ? this.generateFlattenedParentChildList(this.mParentList, this.mExpansionStateMap) : this.generateFlattenedParentChildList(this.mParentList);
        this.notifyDataSetChanged();
    }

    @UiThread
    public void notifyParentInserted(int parentPosition) {
        Parent parent = (Parent)this.mParentList.get(parentPosition);
        int flatParentPosition = parentPosition < this.mParentList.size() - 1 ? this.getFlatParentPosition(parentPosition) : this.mFlatItemList.size();
        int sizeChanged = this.addParentWrapper(flatParentPosition, parent);
        this.notifyItemRangeInserted(flatParentPosition, sizeChanged);
    }

    @UiThread
    public void notifyParentRangeInserted(int parentPositionStart, int itemCount) {
        int initialFlatParentPosition = parentPositionStart < this.mParentList.size() - itemCount ? this.getFlatParentPosition(parentPositionStart) : this.mFlatItemList.size();
        int sizeChanged = 0;
        int flatParentPosition = initialFlatParentPosition;
        int parentPositionEnd = parentPositionStart + itemCount;
        for (int i = parentPositionStart; i < parentPositionEnd; ++i) {
            Parent parent = (Parent)this.mParentList.get(i);
            int changed = this.addParentWrapper(flatParentPosition, parent);
            flatParentPosition += changed;
            sizeChanged += changed;
        }
        this.notifyItemRangeInserted(initialFlatParentPosition, sizeChanged);
    }

    @UiThread
    private int addParentWrapper(int flatParentPosition, P parent) {
        int sizeChanged = 1;
        ExpandableWrapper parentWrapper = new ExpandableWrapper(parent);
        this.mFlatItemList.add(flatParentPosition, parentWrapper);
        if (parentWrapper.isParentInitiallyExpanded()) {
            parentWrapper.setExpanded(true);
            List wrappedChildList = parentWrapper.getWrappedChildList();
            this.mFlatItemList.addAll(flatParentPosition + sizeChanged, wrappedChildList);
            sizeChanged += wrappedChildList.size();
        }
        return sizeChanged;
    }

    @UiThread
    public void notifyParentRemoved(int parentPosition) {
        int flatParentPosition = this.getFlatParentPosition(parentPosition);
        int sizeChanged = this.removeParentWrapper(flatParentPosition);
        this.notifyItemRangeRemoved(flatParentPosition, sizeChanged);
    }

    public void notifyParentRangeRemoved(int parentPositionStart, int itemCount) {
        int sizeChanged = 0;
        int flatParentPositionStart = this.getFlatParentPosition(parentPositionStart);
        for (int i = 0; i < itemCount; ++i) {
            sizeChanged += this.removeParentWrapper(flatParentPositionStart);
        }
        this.notifyItemRangeRemoved(flatParentPositionStart, sizeChanged);
    }

    @UiThread
    private int removeParentWrapper(int flatParentPosition) {
        int sizeChanged = 1;
        ExpandableWrapper<P, C> parentWrapper = this.mFlatItemList.remove(flatParentPosition);
        if (parentWrapper.isExpanded()) {
            int childListSize = parentWrapper.getWrappedChildList().size();
            for (int i = 0; i < childListSize; ++i) {
                this.mFlatItemList.remove(flatParentPosition);
                ++sizeChanged;
            }
        }
        return sizeChanged;
    }

    @UiThread
    public void notifyParentChanged(int parentPosition) {
        Parent parent = (Parent)this.mParentList.get(parentPosition);
        int flatParentPositionStart = this.getFlatParentPosition(parentPosition);
        int sizeChanged = this.changeParentWrapper(flatParentPositionStart, parent);
        this.notifyItemRangeChanged(flatParentPositionStart, sizeChanged);
    }

    @UiThread
    public void notifyParentRangeChanged(int parentPositionStart, int itemCount) {
        int flatParentPositionStart;
        int flatParentPosition = flatParentPositionStart = this.getFlatParentPosition(parentPositionStart);
        int sizeChanged = 0;
        for (int j = 0; j < itemCount; ++j) {
            Parent parent = (Parent)this.mParentList.get(parentPositionStart);
            int changed = this.changeParentWrapper(flatParentPosition, parent);
            sizeChanged += changed;
            flatParentPosition += changed;
            ++parentPositionStart;
        }
        this.notifyItemRangeChanged(flatParentPositionStart, sizeChanged);
    }

    private int changeParentWrapper(int flatParentPosition, P parent) {
        ExpandableWrapper<P, C> parentWrapper = this.mFlatItemList.get(flatParentPosition);
        parentWrapper.setParent(parent);
        int sizeChanged = 1;
        if (parentWrapper.isExpanded()) {
            List<ExpandableWrapper<P, C>> wrappedChildList = parentWrapper.getWrappedChildList();
            int childSize = wrappedChildList.size();
            for (int i = 0; i < childSize; ++i) {
                this.mFlatItemList.set(flatParentPosition + i + 1, wrappedChildList.get(i));
                ++sizeChanged;
            }
        }
        return sizeChanged;
    }

    @UiThread
    public void notifyParentMoved(int fromParentPosition, int toParentPosition) {
        boolean isExpandedNoChildren;
        int fromFlatParentPosition = this.getFlatParentPosition(fromParentPosition);
        ExpandableWrapper<P, C> fromParentWrapper = this.mFlatItemList.get(fromFlatParentPosition);
        boolean isCollapsed = !fromParentWrapper.isExpanded();
        boolean bl = isExpandedNoChildren = !isCollapsed && fromParentWrapper.getWrappedChildList().size() == 0;
        if (isCollapsed || isExpandedNoChildren) {
            int toFlatParentPosition = this.getFlatParentPosition(toParentPosition);
            ExpandableWrapper<P, C> toParentWrapper = this.mFlatItemList.get(toFlatParentPosition);
            this.mFlatItemList.remove(fromFlatParentPosition);
            int childOffset = 0;
            if (toParentWrapper.isExpanded()) {
                childOffset = toParentWrapper.getWrappedChildList().size();
            }
            this.mFlatItemList.add(toFlatParentPosition + childOffset, fromParentWrapper);
            this.notifyItemMoved(fromFlatParentPosition, toFlatParentPosition + childOffset);
        } else {
            int sizeChanged = 0;
            int childListSize = fromParentWrapper.getWrappedChildList().size();
            for (int i = 0; i < childListSize + 1; ++i) {
                this.mFlatItemList.remove(fromFlatParentPosition);
                ++sizeChanged;
            }
            this.notifyItemRangeRemoved(fromFlatParentPosition, sizeChanged);
            int toFlatParentPosition = this.getFlatParentPosition(toParentPosition);
            int childOffset = 0;
            if (toFlatParentPosition != -1) {
                ExpandableWrapper<P, C> toParentWrapper = this.mFlatItemList.get(toFlatParentPosition);
                if (toParentWrapper.isExpanded()) {
                    childOffset = toParentWrapper.getWrappedChildList().size();
                }
            } else {
                toFlatParentPosition = this.mFlatItemList.size();
            }
            this.mFlatItemList.add(toFlatParentPosition + childOffset, fromParentWrapper);
            List<ExpandableWrapper<P, C>> wrappedChildList = fromParentWrapper.getWrappedChildList();
            sizeChanged = wrappedChildList.size() + 1;
            this.mFlatItemList.addAll(toFlatParentPosition + childOffset + 1, wrappedChildList);
            this.notifyItemRangeInserted(toFlatParentPosition + childOffset, sizeChanged);
        }
    }

    @UiThread
    public void notifyChildInserted(int parentPosition, int childPosition) {
        int flatParentPosition = this.getFlatParentPosition(parentPosition);
        ExpandableWrapper<Parent, C> parentWrapper = this.mFlatItemList.get(flatParentPosition);
        parentWrapper.setParent((Parent)this.mParentList.get(parentPosition));
        if (parentWrapper.isExpanded()) {
            ExpandableWrapper<P, C> child = parentWrapper.getWrappedChildList().get(childPosition);
            this.mFlatItemList.add(flatParentPosition + childPosition + 1, child);
            this.notifyItemInserted(flatParentPosition + childPosition + 1);
        }
    }

    @UiThread
    public void notifyChildRangeInserted(int parentPosition, int childPositionStart, int itemCount) {
        int flatParentPosition = this.getFlatParentPosition(parentPosition);
        ExpandableWrapper<Parent, C> parentWrapper = this.mFlatItemList.get(flatParentPosition);
        parentWrapper.setParent((Parent)this.mParentList.get(parentPosition));
        if (parentWrapper.isExpanded()) {
            List<ExpandableWrapper<P, C>> wrappedChildList = parentWrapper.getWrappedChildList();
            for (int i = 0; i < itemCount; ++i) {
                ExpandableWrapper<P, C> child = wrappedChildList.get(childPositionStart + i);
                this.mFlatItemList.add(flatParentPosition + childPositionStart + i + 1, child);
            }
            this.notifyItemRangeInserted(flatParentPosition + childPositionStart + 1, itemCount);
        }
    }

    @UiThread
    public void notifyChildRemoved(int parentPosition, int childPosition) {
        int flatParentPosition = this.getFlatParentPosition(parentPosition);
        ExpandableWrapper<Parent, C> parentWrapper = this.mFlatItemList.get(flatParentPosition);
        parentWrapper.setParent((Parent)this.mParentList.get(parentPosition));
        if (parentWrapper.isExpanded()) {
            this.mFlatItemList.remove(flatParentPosition + childPosition + 1);
            this.notifyItemRemoved(flatParentPosition + childPosition + 1);
        }
    }

    @UiThread
    public void notifyChildRangeRemoved(int parentPosition, int childPositionStart, int itemCount) {
        int flatParentPosition = this.getFlatParentPosition(parentPosition);
        ExpandableWrapper<Parent, C> parentWrapper = this.mFlatItemList.get(flatParentPosition);
        parentWrapper.setParent((Parent)this.mParentList.get(parentPosition));
        if (parentWrapper.isExpanded()) {
            for (int i = 0; i < itemCount; ++i) {
                this.mFlatItemList.remove(flatParentPosition + childPositionStart + 1);
            }
            this.notifyItemRangeRemoved(flatParentPosition + childPositionStart + 1, itemCount);
        }
    }

    @UiThread
    public void notifyChildChanged(int parentPosition, int childPosition) {
        Parent parent = (Parent)this.mParentList.get(parentPosition);
        int flatParentPosition = this.getFlatParentPosition(parentPosition);
        ExpandableWrapper<Parent, C> parentWrapper = this.mFlatItemList.get(flatParentPosition);
        parentWrapper.setParent(parent);
        if (parentWrapper.isExpanded()) {
            int flatChildPosition = flatParentPosition + childPosition + 1;
            ExpandableWrapper<P, C> child = parentWrapper.getWrappedChildList().get(childPosition);
            this.mFlatItemList.set(flatChildPosition, child);
            this.notifyItemChanged(flatChildPosition);
        }
    }

    @UiThread
    public void notifyChildRangeChanged(int parentPosition, int childPositionStart, int itemCount) {
        Parent parent = (Parent)this.mParentList.get(parentPosition);
        int flatParentPosition = this.getFlatParentPosition(parentPosition);
        ExpandableWrapper<Parent, C> parentWrapper = this.mFlatItemList.get(flatParentPosition);
        parentWrapper.setParent(parent);
        if (parentWrapper.isExpanded()) {
            int flatChildPosition = flatParentPosition + childPositionStart + 1;
            for (int i = 0; i < itemCount; ++i) {
                ExpandableWrapper<P, C> child = parentWrapper.getWrappedChildList().get(childPositionStart + i);
                this.mFlatItemList.set(flatChildPosition + i, child);
            }
            this.notifyItemRangeChanged(flatChildPosition, itemCount);
        }
    }

    @UiThread
    public void notifyChildMoved(int parentPosition, int fromChildPosition, int toChildPosition) {
        Parent parent = (Parent)this.mParentList.get(parentPosition);
        int flatParentPosition = this.getFlatParentPosition(parentPosition);
        ExpandableWrapper<Parent, C> parentWrapper = this.mFlatItemList.get(flatParentPosition);
        parentWrapper.setParent(parent);
        if (parentWrapper.isExpanded()) {
            ExpandableWrapper<P, C> fromChild = this.mFlatItemList.remove(flatParentPosition + 1 + fromChildPosition);
            this.mFlatItemList.add(flatParentPosition + 1 + toChildPosition, fromChild);
            this.notifyItemMoved(flatParentPosition + 1 + fromChildPosition, flatParentPosition + 1 + toChildPosition);
        }
    }

    private List<ExpandableWrapper<P, C>> generateFlattenedParentChildList(List<P> parentList) {
        ArrayList<ExpandableWrapper<P, C>> flatItemList = new ArrayList<ExpandableWrapper<P, C>>();
        int parentCount = parentList.size();
        for (int i = 0; i < parentCount; ++i) {
            Parent parent = (Parent)parentList.get(i);
            this.generateParentWrapper(flatItemList, parent, parent.isInitiallyExpanded());
        }
        return flatItemList;
    }

    private List<ExpandableWrapper<P, C>> generateFlattenedParentChildList(List<P> parentList, Map<P, Boolean> savedLastExpansionState) {
        ArrayList<ExpandableWrapper<P, C>> flatItemList = new ArrayList<ExpandableWrapper<P, C>>();
        int parentCount = parentList.size();
        for (int i = 0; i < parentCount; ++i) {
            Parent parent = (Parent)parentList.get(i);
            Boolean lastExpandedState = savedLastExpansionState.get(parent);
            boolean shouldExpand = lastExpandedState == null ? parent.isInitiallyExpanded() : lastExpandedState.booleanValue();
            this.generateParentWrapper(flatItemList, parent, shouldExpand);
        }
        return flatItemList;
    }

    private void generateParentWrapper(List<ExpandableWrapper<P, C>> flatItemList, P parent, boolean shouldExpand) {
        ExpandableWrapper parentWrapper = new ExpandableWrapper(parent);
        flatItemList.add(parentWrapper);
        if (shouldExpand) {
            this.generateExpandedChildren(flatItemList, parentWrapper);
        }
    }

    private void generateExpandedChildren(List<ExpandableWrapper<P, C>> flatItemList, ExpandableWrapper<P, C> parentWrapper) {
        parentWrapper.setExpanded(true);
        List<ExpandableWrapper<P, C>> wrappedChildList = parentWrapper.getWrappedChildList();
        int childCount = wrappedChildList.size();
        for (int j = 0; j < childCount; ++j) {
            ExpandableWrapper<P, C> childWrapper = wrappedChildList.get(j);
            flatItemList.add(childWrapper);
        }
    }

    @NonNull
    @UiThread
    private HashMap<Integer, Boolean> generateExpandedStateMap() {
        HashMap<Integer, Boolean> parentHashMap = new HashMap<Integer, Boolean>();
        int childCount = 0;
        int listItemCount = this.mFlatItemList.size();
        for (int i = 0; i < listItemCount; ++i) {
            if (this.mFlatItemList.get(i) == null) continue;
            ExpandableWrapper<P, C> listItem = this.mFlatItemList.get(i);
            if (listItem.isParent()) {
                parentHashMap.put(i - childCount, listItem.isExpanded());
                continue;
            }
            ++childCount;
        }
        return parentHashMap;
    }

    @UiThread
    private int getFlatParentPosition(int parentPosition) {
        int parentCount = 0;
        int listItemCount = this.mFlatItemList.size();
        for (int i = 0; i < listItemCount; ++i) {
            if (!this.mFlatItemList.get(i).isParent() || ++parentCount <= parentPosition) continue;
            return i;
        }
        return -1;
    }

    public static interface ExpandCollapseListener {
        @UiThread
        public void onParentExpanded(int var1);

        @UiThread
        public void onParentCollapsed(int var1);
    }
}

