/*
 * Decompiled with CFR 0.152.
 */
package com.iab.omid.library.bigosg.adsession;

import android.support.annotation.Nullable;
import android.webkit.WebView;
import com.iab.omid.library.bigosg.adsession.AdSessionContextType;
import com.iab.omid.library.bigosg.adsession.Partner;
import com.iab.omid.library.bigosg.adsession.VerificationScriptResource;
import com.iab.omid.library.bigosg.d.e;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public final class AdSessionContext {
    private final Partner partner;
    private final WebView webView;
    private final List<VerificationScriptResource> verificationScriptResources = new ArrayList<VerificationScriptResource>();
    private final Map<String, VerificationScriptResource> injectedResourcesMap = new HashMap<String, VerificationScriptResource>();
    private final String omidJsScriptContent;
    private final String customReferenceData;
    @Nullable
    private final String contentUrl;
    private final AdSessionContextType adSessionContextType;

    /*
     * WARNING - void declaration
     */
    private AdSessionContext(Partner object, WebView object22, String string2, List<VerificationScriptResource> list, @Nullable String string3, String string4, AdSessionContextType adSessionContextType) {
        void var6_8;
        void var5_7;
        void var4_6;
        void var7_9;
        String string5;
        this.partner = object;
        this.webView = object22;
        this.omidJsScriptContent = string5;
        this.adSessionContextType = var7_9;
        if (var4_6 != null) {
            this.verificationScriptResources.addAll((Collection<VerificationScriptResource>)var4_6);
            for (VerificationScriptResource verificationScriptResource : var4_6) {
                string5 = UUID.randomUUID().toString();
                this.injectedResourcesMap.put(string5, verificationScriptResource);
            }
        }
        this.contentUrl = var5_7;
        this.customReferenceData = var6_8;
    }

    public static AdSessionContext createHtmlAdSessionContext(Partner partner, WebView webView, String string2) {
        e.a(partner, "Partner is null");
        e.a(webView, "WebView is null");
        if (string2 != null) {
            e.a(string2, 256, "CustomReferenceData is greater than 256 characters");
        }
        return new AdSessionContext(partner, webView, null, null, null, string2, AdSessionContextType.HTML);
    }

    public static AdSessionContext createHtmlAdSessionContext(Partner partner, WebView webView, @Nullable String string2, String string3) {
        e.a(partner, "Partner is null");
        e.a(webView, "WebView is null");
        if (string3 != null) {
            e.a(string3, 256, "CustomReferenceData is greater than 256 characters");
        }
        return new AdSessionContext(partner, webView, null, null, string2, string3, AdSessionContextType.HTML);
    }

    public static AdSessionContext createJavascriptAdSessionContext(Partner partner, WebView webView, @Nullable String string2, String string3) {
        e.a(partner, "Partner is null");
        e.a(webView, "WebView is null");
        if (string3 != null) {
            e.a(string3, 256, "CustomReferenceData is greater than 256 characters");
        }
        return new AdSessionContext(partner, webView, null, null, string2, string3, AdSessionContextType.JAVASCRIPT);
    }

    public static AdSessionContext createNativeAdSessionContext(Partner partner, String string2, List<VerificationScriptResource> list, String string3) {
        e.a(partner, "Partner is null");
        e.a((Object)string2, "OM SDK JS script content is null");
        e.a(list, "VerificationScriptResources is null");
        if (string3 != null) {
            e.a(string3, 256, "CustomReferenceData is greater than 256 characters");
        }
        return new AdSessionContext(partner, null, string2, list, null, string3, AdSessionContextType.NATIVE);
    }

    public static AdSessionContext createNativeAdSessionContext(Partner partner, String string2, List<VerificationScriptResource> list, @Nullable String string3, String string4) {
        e.a(partner, "Partner is null");
        e.a((Object)string2, "OM SDK JS script content is null");
        e.a(list, "VerificationScriptResources is null");
        if (string4 != null) {
            e.a(string4, 256, "CustomReferenceData is greater than 256 characters");
        }
        return new AdSessionContext(partner, null, string2, list, string3, string4, AdSessionContextType.NATIVE);
    }

    public final Partner getPartner() {
        return this.partner;
    }

    public final List<VerificationScriptResource> getVerificationScriptResources() {
        return Collections.unmodifiableList(this.verificationScriptResources);
    }

    public final Map<String, VerificationScriptResource> getInjectedResourcesMap() {
        return Collections.unmodifiableMap(this.injectedResourcesMap);
    }

    public final WebView getWebView() {
        return this.webView;
    }

    @Nullable
    public final String getContentUrl() {
        return this.contentUrl;
    }

    public final String getCustomReferenceData() {
        return this.customReferenceData;
    }

    public final String getOmidJsScriptContent() {
        return this.omidJsScriptContent;
    }

    public final AdSessionContextType getAdSessionContextType() {
        return this.adSessionContextType;
    }
}

