/*
 * Decompiled with CFR 0.152.
 */
package sg.bigo.ads.common.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.ViewOutlineProvider;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import sg.bigo.ads.common.view.b.a;
import sg.bigo.ads.common.view.b.b;

public class RoundedImageView
extends ImageView
implements a {
    private float a = Float.NaN;
    private float b = Float.NaN;
    private float c = Float.NaN;
    private float d = Float.NaN;
    private float e;
    private int f = -1;

    public RoundedImageView(Context context) {
        this(context, null);
    }

    public RoundedImageView(Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public RoundedImageView(Context context, @Nullable AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
    }

    public void setCornerRadius(float f2) {
        float f3 = f2;
        RoundedImageView roundedImageView = this;
        this.a = f3;
        roundedImageView.b = f3;
        roundedImageView.c = f3;
        roundedImageView.d = f3;
        roundedImageView.invalidate();
    }

    public void setOutlineProvider(ViewOutlineProvider viewOutlineProvider) {
    }

    private void a() {
        if (Build.VERSION.SDK_INT >= 21) {
            if (this.getOutlineProvider() instanceof b) {
                return;
            }
            super.setOutlineProvider((ViewOutlineProvider)new b());
        }
    }

    public void setElevation(float f2) {
        super.setElevation(f2);
        this.a();
    }

    public void setTranslationZ(float f2) {
        super.setTranslationZ(f2);
        this.a();
    }

    public void setStrokeWidth(float f2) {
        this.e = f2;
        this.invalidate();
    }

    public void setStrokeColor(@ColorInt int n2) {
        this.f = n2;
        this.invalidate();
    }

    public void draw(Canvas canvas) {
        int n2 = canvas.save();
        Path path = this.getClipPath();
        if (path != null) {
            canvas.clipPath(path);
        }
        super.draw(canvas);
        path = this.getImageRectF();
        if (this.e > 0.0f && !path.isEmpty()) {
            Paint paint = new Paint();
            paint.setColor(this.f);
            paint.setStyle(Paint.Style.STROKE);
            paint.setStrokeWidth(this.e);
            paint.setAntiAlias(true);
            canvas.drawRoundRect((RectF)path, this.a, this.a, paint);
        }
        canvas.restoreToCount(n2);
    }

    private RectF getImageRectF() {
        float f2;
        float f3;
        float f4;
        float f5;
        int n2 = this.getMeasuredWidth();
        int n3 = this.getMeasuredHeight();
        Object object = this.getDrawable();
        if (object != null) {
            int n4 = object.getIntrinsicWidth();
            int n5 = object.getIntrinsicHeight();
            object = new float[9];
            Matrix matrix = this.getImageMatrix();
            if (matrix != null && !matrix.isIdentity()) {
                matrix.getValues((float[])object);
            }
            f5 = (float)object[2];
            Drawable drawable2 = object[5];
            Drawable drawable3 = object[0];
            Drawable drawable4 = object[4];
            f4 = Float.isNaN(f5) ? 0.0f : Math.max(0.0f, f5);
            f5 = Float.isNaN((float)drawable2) ? 0.0f : Math.max(0.0f, (float)drawable2);
            f3 = Float.isNaN((float)drawable3) || drawable3 <= 0.0f ? Math.min(f4 + (float)n4, (float)n2) : Math.min(f4 + (float)n4 * drawable3, (float)n2);
            f2 = Float.isNaN((float)drawable4) || drawable4 <= 0.0f ? Math.min(f5 + (float)n5, (float)n3) : Math.min(f5 + (float)n5 * drawable4, (float)n3);
        } else {
            f4 = 0.0f;
            f5 = 0.0f;
            f3 = n2;
            f2 = n3;
        }
        return new RectF(f4, f5, f3, f2);
    }

    @Override
    public Path getClipPath() {
        RectF rectF = this.getImageRectF();
        if (!(Float.isNaN(this.a) || Float.isNaN(this.b) || Float.isNaN(this.d) || Float.isNaN(this.c) || rectF == null || rectF.isEmpty())) {
            Path path = new Path();
            float[] fArray = new float[8];
            float[] fArray2 = fArray;
            fArray[0] = Float.isNaN(this.a) ? 0.0f : this.a;
            fArray2[1] = fArray2[0];
            fArray2[2] = Float.isNaN(this.b) ? 0.0f : this.b;
            fArray2[3] = fArray2[2];
            fArray2[4] = Float.isNaN(this.d) ? 0.0f : this.d;
            fArray2[5] = fArray2[4];
            fArray2[6] = Float.isNaN(this.c) ? 0.0f : this.c;
            fArray2[7] = fArray2[6];
            path.addRoundRect(rectF, fArray2, Path.Direction.CW);
            return path;
        }
        return null;
    }
}

