/*
 * Decompiled with CFR 0.152.
 */
package com.biqasoft.microservice.communicator;

import com.biqasoft.microservice.communicator.exceptions.CannotResolveHostException;
import com.biqasoft.microservice.communicator.exceptions.InternalSeverErrorProcessingRequestException;
import com.biqasoft.microservice.communicator.exceptions.InvalidRequestException;
import com.biqasoft.microservice.communicator.exceptions.InvalidStateException;
import com.biqasoft.microservice.communicator.http.MicroserviceRestTemplate;
import com.biqasoft.microservice.communicator.interfaceimpl.MicroserviceRequestInterceptor;
import com.biqasoft.microservice.communicator.servicediscovery.MicroserviceHelper;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;

@Component
public class MicroserviceRequestMaker {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(MicroserviceRequestMaker.class);
    public static final String DEFAULT_INTERFACE_PROXY_METHOD = "DEFAULT_INTERFACE_PROXY_METHOD";
    public static final String INTERFACE_IMPLEMENTED = "INTERFACE_IMPLEMENTED";
    public static final String METHOD_PARAMS = "METHOD_PARAMS";
    private static MicroserviceHelper microserviceHelper;
    public static final ThreadLocal<Map<String, String>> httpHeadersThreadLocal;
    private static boolean RETURN_NULL_ON_EMPTY_RESPONSE_BODY;
    public static Field body;
    private static List<MicroserviceRequestInterceptor> microserviceRequestInterceptors;
    private static Map<String, Object> defaultObjectImplProxy;

    @Autowired
    public void setMicroserviceHelper(MicroserviceHelper microserviceHelper) {
        MicroserviceRequestMaker.microserviceHelper = microserviceHelper;
    }

    @Autowired(required=false)
    public void setMicroserviceRequestInterceptors(List<MicroserviceRequestInterceptor> microserviceRequestInterceptors) {
        MicroserviceRequestMaker.microserviceRequestInterceptors = microserviceRequestInterceptors;
    }

    public static void beforeProcessRequest(MicroserviceRestTemplate restTemplate, HttpHeaders httpHeaders) {
        if (microserviceRequestInterceptors != null) {
            microserviceRequestInterceptors.forEach(x -> x.beforeProcessRequest(restTemplate, httpHeaders));
        }
    }

    public static Object onBeforeReturnResultProcessor(Object returnObjectOriginal, Object payload, Class returnType, MicroserviceRestTemplate restTemplate, Class[] returnGenericType, Map<String, Object> params) {
        if (microserviceRequestInterceptors == null) {
            return returnObjectOriginal;
        }
        Object returnObject = returnObjectOriginal;
        for (MicroserviceRequestInterceptor microserviceRequestInterceptor : microserviceRequestInterceptors) {
            returnObject = microserviceRequestInterceptor.onBeforeReturnResult(returnObject, returnObjectOriginal, payload, returnType, restTemplate, returnGenericType, params);
        }
        return returnObject;
    }

    public static Object makeRequestToMicroservice(Object payload, Class returnType, MicroserviceRestTemplate restTemplate, Class[] returnGenericType, Map<String, Object> params, HttpHeaders httpHeaders) {
        HttpMethod httpMethod = restTemplate.getMethod();
        try {
            ResponseEntity responseEntity;
            for (Map.Entry<String, String> entry : httpHeadersThreadLocal.get().entrySet()) {
                httpHeaders.add(entry.getKey(), entry.getValue());
            }
            if (!(payload instanceof byte[])) {
                httpHeaders.setContentType(MediaType.APPLICATION_JSON);
            }
            if (microserviceRequestInterceptors != null) {
                microserviceRequestInterceptors.forEach(x -> x.beforeCreateHttpEntity(restTemplate, returnType, returnGenericType, httpHeaders));
            }
            HttpEntity request = payload == null ? new HttpEntity((MultiValueMap)httpHeaders) : new HttpEntity(payload, (MultiValueMap)httpHeaders);
            if (microserviceRequestInterceptors != null) {
                microserviceRequestInterceptors.forEach(x -> x.beforeRequest(restTemplate, (HttpEntity<Object>)request, returnType, returnGenericType));
            }
            try {
                responseEntity = restTemplate.exchange(null, restTemplate.getMethod(), request, byte[].class);
            }
            catch (InvalidRequestException e) {
                ClientHttpResponse clientHttpResponse;
                if (returnType.equals(ResponseEntity.class) && e.getClientHttpResponse() != null && (clientHttpResponse = e.getClientHttpResponse()).getBody() != null) {
                    String body = null;
                    Scanner s = new Scanner(clientHttpResponse.getBody()).useDelimiter("\\A");
                    String string = body = s.hasNext() ? s.next() : "";
                    if (body == null) {
                        return ResponseEntity.status((int)clientHttpResponse.getRawStatusCode()).headers(clientHttpResponse.getHeaders());
                    }
                    return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)clientHttpResponse.getRawStatusCode()).headers(clientHttpResponse.getHeaders())).body((Object)body);
                }
                throw e;
            }
            if (microserviceRequestInterceptors != null) {
                microserviceRequestInterceptors.forEach(x -> x.afterRequest(restTemplate, (HttpEntity<Object>)request, (ResponseEntity<byte[]>)responseEntity, returnType, returnGenericType));
            }
            logger.debug("Request to microservice {}", (Object)restTemplate.getLastURI().toString());
            if (returnType.equals(Void.TYPE)) {
                return Void.TYPE;
            }
            if (returnType.equals(Optional.class)) {
                Object object;
                if (!responseEntity.hasBody()) {
                    return Optional.empty();
                }
                if (Collection.class.isAssignableFrom(returnGenericType[0])) {
                    CollectionType type = objectMapper.getTypeFactory().constructCollectionType(returnGenericType[0], returnGenericType[1]);
                    object = objectMapper.readValue((byte[])responseEntity.getBody(), (JavaType)type);
                } else {
                    object = objectMapper.readValue((byte[])responseEntity.getBody(), returnGenericType[0]);
                }
                return Optional.of(object);
            }
            if (!responseEntity.hasBody() && RETURN_NULL_ON_EMPTY_RESPONSE_BODY && !returnType.equals(ResponseEntity.class)) {
                return null;
            }
            if (returnType.equals(CompletableFuture.class)) {
                if (returnGenericType.length == 0) {
                    return Void.TYPE;
                }
                if (Collection.class.isAssignableFrom(returnGenericType[0])) {
                    CollectionType type = objectMapper.getTypeFactory().constructCollectionType(returnGenericType[0], returnGenericType[1]);
                    return objectMapper.readValue((byte[])responseEntity.getBody(), (JavaType)type);
                }
                return objectMapper.readValue((byte[])responseEntity.getBody(), returnGenericType[0]);
            }
            if (returnType.equals(byte[].class)) {
                return responseEntity.getBody();
            }
            if (returnGenericType == null) {
                return objectMapper.readValue((byte[])responseEntity.getBody(), returnType);
            }
            if (returnType.equals(ResponseEntity.class)) {
                if (!responseEntity.hasBody()) {
                    return responseEntity;
                }
                ReflectionUtils.setField((Field)body, (Object)responseEntity, (Object)objectMapper.readValue((byte[])responseEntity.getBody(), returnGenericType[0]));
                return responseEntity;
            }
            if (returnType.equals(Map.class) && returnGenericType.length == 2 && returnGenericType[0].equals(String.class) && returnGenericType[1].equals(Object.class) && params != null && Boolean.TRUE.equals(params.get("convertResponseToMap"))) {
                JsonNode jsonNode = objectMapper.readTree((byte[])responseEntity.getBody());
                Map map = (Map)objectMapper.convertValue((Object)jsonNode, Map.class);
                return map;
            }
            if (Collection.class.isAssignableFrom(returnType)) {
                CollectionType type = objectMapper.getTypeFactory().constructCollectionType(returnType, returnGenericType[0]);
                return objectMapper.readValue((byte[])responseEntity.getBody(), (JavaType)type);
            }
            throw new InvalidStateException("Internal error processing. Retry later");
        }
        catch (Throwable e) {
            Object defaultValue;
            if (params != null && (defaultValue = params.get("HAVE_DEFAULT_VALUE")) == Boolean.TRUE) {
                return MicroserviceRequestMaker.getDefaultValue(params);
            }
            if (e instanceof InvalidRequestException) {
                throw (InvalidRequestException)e;
            }
            if (e instanceof CannotResolveHostException) {
                logger.error(e.getMessage(), e);
            }
            logger.error("Can not get bytes from microservice {} {}", new Object[]{httpMethod.toString(), restTemplate.getLastURI() == null ? "NULL_URL" : restTemplate.getLastURI().toString(), e});
            throw new InternalSeverErrorProcessingRequestException("Internal error processing. Retry later");
        }
    }

    private static Object getDefaultValue(Map<String, Object> params) {
        Method method = (Method)params.get(DEFAULT_INTERFACE_PROXY_METHOD);
        Class interfaceToExtend = (Class)params.get(INTERFACE_IMPLEMENTED);
        Object[] methodParams = (Object[])params.get(METHOD_PARAMS);
        Object defaultInterfaceProxy = defaultObjectImplProxy.computeIfAbsent(interfaceToExtend.toString(), x -> Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{interfaceToExtend}, (proxy2, method2, arguments2) -> null));
        try {
            Method defaultJava8Method = interfaceToExtend.getMethod(method.getName(), method.getParameterTypes());
            Field field = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            field.setAccessible(true);
            MethodHandles.Lookup lookup = (MethodHandles.Lookup)field.get(null);
            return lookup.unreflectSpecial(defaultJava8Method, defaultJava8Method.getDeclaringClass()).bindTo(defaultInterfaceProxy).invokeWithArguments(methodParams);
        }
        catch (Throwable throwable) {
            logger.error("Can not execute java 8 default interface method", throwable);
            throw new InternalSeverErrorProcessingRequestException("Internal error processing. Retry later");
        }
    }

    public List<MicroserviceRequestInterceptor> getMicroserviceRequestInterceptors() {
        if (microserviceRequestInterceptors == null) {
            microserviceRequestInterceptors = new ArrayList<MicroserviceRequestInterceptor>();
        }
        return microserviceRequestInterceptors;
    }

    public static boolean isReturnNullOnEmptyResponseBody() {
        return RETURN_NULL_ON_EMPTY_RESPONSE_BODY;
    }

    public static void setReturnNullOnEmptyResponseBody(boolean returnNullOnEmptyResponseBody) {
        RETURN_NULL_ON_EMPTY_RESPONSE_BODY = returnNullOnEmptyResponseBody;
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static MicroserviceHelper getMicroserviceHelper() {
        return microserviceHelper;
    }

    static {
        httpHeadersThreadLocal = new ThreadLocal<Map<String, String>>(){

            @Override
            protected Map<String, String> initialValue() {
                return new ConcurrentHashMap<String, String>();
            }
        };
        RETURN_NULL_ON_EMPTY_RESPONSE_BODY = true;
        body = null;
        try {
            body = HttpEntity.class.getDeclaredField("body");
            body.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        microserviceRequestInterceptors = null;
        defaultObjectImplProxy = new ConcurrentHashMap<String, Object>();
    }
}

