/*
 * Decompiled with CFR 0.152.
 */
package com.biqasoft.microservice.communicator.http;

import com.biqasoft.microservice.communicator.exceptions.InternalSeverErrorProcessingRequestException;
import com.biqasoft.microservice.communicator.exceptions.InvalidRequestException;
import com.biqasoft.microservice.communicator.http.ResponseErrorHandler;
import com.biqasoft.microservice.communicator.http.SpringInjectorHelper;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class MicroserviceRestTemplate
extends RestTemplate {
    private URI lastURI = null;
    private final HttpMethod method;
    private RequestCallback requestCallback;
    private ClientHttpRequest clientHttpRequest;
    private ResponseExtractor responseExtractor;
    private static final Logger logger = LoggerFactory.getLogger(MicroserviceRestTemplate.class);
    private final Boolean tryToReconnect;
    private int triedTimes = 0;
    private final int tryToReconnectTimes;
    private final int sleepTimeBetweenTrying;
    private final String microserviceName;
    private final String pathToApiResource;
    private static final int DEFAULT_TRY_TO_RECONNECT_TIMES = 11;
    private static final int DEFAULT_SLEEP_TIME_BETWEEN_TRYING = 1000;
    private static final Set<Integer> defaultInvalidRequestStatusCode = new HashSet<Integer>();
    private static ResponseErrorHandler responseErrorHandler;

    public MicroserviceRestTemplate(String microserviceName, String pathToApiResource, HttpMethod httpMethod) throws URISyntaxException {
        super((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory());
        this.tryToReconnect = true;
        this.tryToReconnectTimes = 11;
        this.sleepTimeBetweenTrying = 1000;
        this.microserviceName = microserviceName;
        this.pathToApiResource = pathToApiResource;
        this.method = httpMethod;
        this.setErrorHandler((org.springframework.web.client.ResponseErrorHandler)responseErrorHandler);
    }

    public MicroserviceRestTemplate(Boolean tryToReconnect, int tryToReconnectTimes, int sleepTimeBetweenTrying, String microserviceName, String pathToApiResource, HttpMethod httpMethod) throws URISyntaxException {
        super((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory());
        this.tryToReconnect = tryToReconnect;
        this.tryToReconnectTimes = tryToReconnectTimes;
        this.sleepTimeBetweenTrying = sleepTimeBetweenTrying;
        this.microserviceName = microserviceName;
        this.pathToApiResource = pathToApiResource;
        this.method = httpMethod;
        this.setErrorHandler((org.springframework.web.client.ResponseErrorHandler)responseErrorHandler);
    }

    private URI getLoadBalanceUrlForMe() {
        return SpringInjectorHelper.getMicroserviceHelper().getLoadBalancedURIByMicroservice(this.microserviceName, this.pathToApiResource, this.sleepTimeBetweenTrying, this.tryToReconnect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T doExecute(URI urlFake, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        T t;
        ClientHttpResponse response;
        URI url;
        block8: {
            this.responseExtractor = responseExtractor;
            this.lastURI = url = SpringInjectorHelper.getMicroserviceHelper().getLoadBalancedURIByMicroservice(this.microserviceName, this.pathToApiResource, this.sleepTimeBetweenTrying, this.tryToReconnect);
            Assert.notNull((Object)url, (String)"'url' must not be null");
            Assert.notNull((Object)method, (String)"'method' must not be null");
            response = null;
            ClientHttpRequest request = this.createRequest(url, method);
            if (requestCallback != null) {
                requestCallback.doWithRequest(request);
            }
            response = request.execute();
            this.handleResponse(url, method, response);
            if (responseExtractor == null) break block8;
            Object object = responseExtractor.extractData(response);
            return (T)object;
        }
        try {
            t = null;
        }
        catch (IOException | RestClientException ex) {
            block9: {
                try {
                    this.processInvalidRequest(response);
                }
                catch (IOException e) {
                    logger.error("I/O error on {} request for {} {}", new Object[]{method.name(), url.toString(), ex.getMessage(), ex.getCause()});
                    if (response == null) break block9;
                    response.close();
                }
            }
            T t2 = this.doExecuteOnError(method, requestCallback, responseExtractor);
            return t2;
        }
        return t;
    }

    private void processInvalidRequest(ClientHttpResponse response) throws IOException {
        if (response != null && response.getStatusCode() != null && defaultInvalidRequestStatusCode.contains(response.getRawStatusCode())) {
            throw new InvalidRequestException(response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doExecuteOnError(HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        boolean exitLoop = false;
        ClientHttpResponse response = null;
        ClientHttpRequest request = null;
        while (!exitLoop) {
            ++this.triedTimes;
            if (this.tryToReconnect == null || !this.tryToReconnect.booleanValue()) {
                exitLoop = true;
            }
            if (this.triedTimes > this.tryToReconnectTimes && this.tryToReconnect.booleanValue()) {
                logger.error("Failed request {} {} tried={}", new Object[]{method.toString(), this.lastURI.toString(), this.triedTimes});
                throw new InternalSeverErrorProcessingRequestException("Failed request, tried=" + this.triedTimes);
            }
            try {
                URI url = this.getLoadBalanceUrlForMe();
                request = this.createRequest(url, method);
                if (requestCallback != null) {
                    requestCallback.doWithRequest(request);
                }
                response = request.execute();
                this.processInvalidRequest(response);
                this.handleResponse(url, method, response);
                if (responseExtractor != null) {
                    return (T)responseExtractor.extractData(response);
                }
                return null;
            }
            catch (IOException | RestClientException e) {
                try {
                    logger.info("Can not make http request {} {} {} times={}", new Object[]{request.getMethod().toString(), request.getURI().toString(), response.getStatusText(), this.triedTimes});
                }
                catch (Exception exception) {
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
                try {
                    Thread.sleep(this.sleepTimeBetweenTrying);
                }
                catch (InterruptedException e2) {
                    exitLoop = true;
                }
            }
        }
        throw new InternalSeverErrorProcessingRequestException("Failed request");
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public RequestCallback getRequestCallback() {
        return this.requestCallback;
    }

    public void setRequestCallback(RequestCallback requestCallback) {
        this.requestCallback = requestCallback;
    }

    public ClientHttpRequest getClientHttpRequest() {
        return this.clientHttpRequest;
    }

    public void setClientHttpRequest(ClientHttpRequest clientHttpRequest) {
        this.clientHttpRequest = clientHttpRequest;
    }

    public ResponseExtractor getResponseExtractor() {
        return this.responseExtractor;
    }

    public void setResponseExtractor(ResponseExtractor responseExtractor) {
        this.responseExtractor = responseExtractor;
    }

    public String getMicroserviceName() {
        return this.microserviceName;
    }

    public String getPathToApiResource() {
        return this.pathToApiResource;
    }

    public URI getLastURI() {
        return this.lastURI;
    }

    static {
        defaultInvalidRequestStatusCode.add(422);
        defaultInvalidRequestStatusCode.add(401);
        defaultInvalidRequestStatusCode.add(403);
        responseErrorHandler = new ResponseErrorHandler();
    }
}

