/*
 * Decompiled with CFR 0.152.
 */
package com.biqasoft.microservice.communicator.interfaceimpl;

import com.biqasoft.microservice.communicator.interfaceimpl.MicroserviceInterfaceImpFactory;
import com.biqasoft.microservice.communicator.interfaceimpl.SpecialLanguageNotation;
import com.biqasoft.microservice.communicator.interfaceimpl.annotation.MicroMapping;
import com.biqasoft.microservice.communicator.interfaceimpl.annotation.MicroPayloadVar;
import com.biqasoft.microservice.communicator.interfaceimpl.annotation.Microservice;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeBindings;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;

public class MicroserviceCachedParsedAnnotationInterface {
    private static final Logger logger = LoggerFactory.getLogger(MicroserviceCachedParsedAnnotationInterface.class);
    private static final Map<Integer, MicroserviceInterfaceImpFactory.CachedMicroserviceCall> cachedMicroserviceCallMap = new ConcurrentHashMap<Integer, MicroserviceInterfaceImpFactory.CachedMicroserviceCall>();

    static MicroserviceInterfaceImpFactory.CachedMicroserviceCall processMicroserviceSignature(Method method, Object o) {
        MicroserviceInterfaceImpFactory.CachedMicroserviceCall cachedMicroserviceCall = cachedMicroserviceCallMap.get(method.hashCode());
        if (cachedMicroserviceCall != null) {
            return cachedMicroserviceCall;
        }
        return MicroserviceCachedParsedAnnotationInterface.computeMicroserviceSignature(method, o);
    }

    private static MicroserviceInterfaceImpFactory.CachedMicroserviceCall computeMicroserviceSignature(Method method, Object o) {
        logger.info("Create microservice impl of method {}", (Object)method.getName());
        MicroserviceInterfaceImpFactory.CachedMicroserviceCall cachedMicroserviceCall = new MicroserviceInterfaceImpFactory.CachedMicroserviceCall();
        SpecialLanguageNotation.SpecialLanguage specialLanguage = SpecialLanguageNotation.isProcessSpecialLanguageNotation(method);
        MicroMapping microMapping = (MicroMapping)AnnotationUtils.findAnnotation((Method)method, MicroMapping.class);
        Class[] returnGenericType = null;
        Class<?> microserviceReturnType = null;
        String microserviceName = null;
        try {
            Class[] allInterfaces;
            Class aClass = null;
            Annotation declaredAnnotation = null;
            for (Class c : allInterfaces = ClassUtils.getAllInterfaces((Object)o)) {
                declaredAnnotation = AnnotationUtils.findAnnotation((Class)c, Microservice.class);
                if (declaredAnnotation == null) continue;
                aClass = c;
                break;
            }
            microserviceName = (String)AnnotationUtils.getValue(declaredAnnotation, (String)"microservice");
            microserviceReturnType = method.getReturnType();
            try {
                Type returnType = Type.of(aClass).getMethod(method.getName(), new Type[0]).getReturnType();
                if (returnType.isGenericType() && returnType.getGenericTypeParameters().size() > 0) {
                    int genericsParamNumber = returnType.getGenericTypeParameters().size();
                    returnGenericType = new Class[genericsParamNumber];
                    Method allGenericsMethod = returnType.getClass().getDeclaredMethod("getTypeBindings", new Class[0]);
                    allGenericsMethod.setAccessible(true);
                    TypeBindings typeBindings = (TypeBindings)allGenericsMethod.invoke((Object)returnType, new Object[0]);
                    for (int i = 0; i < genericsParamNumber; ++i) {
                        Type boundType = typeBindings.getBoundType(i);
                        if (boundType.isGenericType()) {
                            if (!boundType.getErasedClass().equals(List.class)) continue;
                            returnGenericType[i] = boundType.getErasedClass();
                            Method allGenericsMethod2 = boundType.getClass().getDeclaredMethod("getTypeBindings", new Class[0]);
                            allGenericsMethod2.setAccessible(true);
                            TypeBindings typeBindings2 = (TypeBindings)allGenericsMethod2.invoke((Object)boundType, new Object[0]);
                            returnGenericType = Arrays.copyOf(returnGenericType, returnGenericType.length + 1);
                            returnGenericType[i + 1] = Class.forName(typeBindings2.getBoundType(0).getFullName());
                            continue;
                        }
                        returnGenericType[i] = Class.forName(boundType.getTypeName());
                    }
                }
            }
            catch (Exception e) {
                returnGenericType = null;
                logger.error("can not get generic info ", (Throwable)e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (specialLanguage == null) {
            cachedMicroserviceCall.annotatedPath = microMapping.path();
            cachedMicroserviceCall.httpMethod = microMapping.method();
            cachedMicroserviceCall.tryToReconnect = microMapping.tryToReconnect();
            cachedMicroserviceCall.tryToReconnectTimes = microMapping.tryToReconnectTimes();
            cachedMicroserviceCall.sleepTimeBetweenTrying = microMapping.sleepTimeBetweenTrying();
            cachedMicroserviceCall.convertResponseToMap = microMapping.convertResponseToMap();
            if (method.getParameterAnnotations().length > 0) {
                Annotation[][] annotationArray = method.getParameterAnnotations();
                int n = annotationArray.length;
                block6: for (int i = 0; i < n; ++i) {
                    Annotation[] annotations;
                    for (Annotation annotation : annotations = annotationArray[i]) {
                        if (!annotation.annotationType().equals(MicroPayloadVar.class)) continue;
                        cachedMicroserviceCall.mergePayloadToObject = true;
                        continue block6;
                    }
                }
            }
        } else {
            SpecialLanguageNotation.processSpecialLanguageNotation(cachedMicroserviceCall, method, o, specialLanguage);
        }
        cachedMicroserviceCall.microserviceName = microserviceName;
        cachedMicroserviceCall.microserviceReturnType = microserviceReturnType;
        cachedMicroserviceCall.returnGenericType = returnGenericType;
        cachedMicroserviceCallMap.put(method.hashCode(), cachedMicroserviceCall);
        return cachedMicroserviceCall;
    }
}

