/*
 * Decompiled with CFR 0.152.
 */
package com.biqasoft.microservice.communicator.interfaceimpl;

import com.biqasoft.microservice.communicator.MicroserviceRequestMaker;
import com.biqasoft.microservice.communicator.exceptions.InvalidStateException;
import com.biqasoft.microservice.communicator.http.HttpClientsHelpers;
import com.biqasoft.microservice.communicator.http.MicroserviceRestTemplate;
import com.biqasoft.microservice.communicator.interfaceimpl.MicroserviceCachedParsedAnnotationInterface;
import com.biqasoft.microservice.communicator.interfaceimpl.UserMicroserviceRequestSuperService;
import com.biqasoft.microservice.communicator.interfaceimpl.annotation.MicroPathVar;
import com.biqasoft.microservice.communicator.interfaceimpl.annotation.MicroPayloadVar;
import com.biqasoft.microservice.communicator.interfaceimpl.annotation.Microservice;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class MicroserviceInterfaceImpFactory {
    private static final Logger logger = LoggerFactory.getLogger(MicroserviceInterfaceImpFactory.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final JsonNodeFactory factory = JsonNodeFactory.instance;

    public static Object create(final Class<?> interfaceToExtend) {
        if (interfaceToExtend.isInterface()) {
            Microservice declaredAnnotation = interfaceToExtend.getDeclaredAnnotation(Microservice.class);
            if (declaredAnnotation == null) {
                throw new InvalidStateException(interfaceToExtend.toString() + " must be annotated with " + Microservice.class.toString() + " annotation");
            }
            ArrayList extendInterfaces = new ArrayList();
            extendInterfaces.add(interfaceToExtend);
            extendInterfaces.addAll(Arrays.asList(interfaceToExtend.getInterfaces()));
            Object extendedInterface = Enhancer.create(UserMicroserviceRequestSuperService.class, (Class[])extendInterfaces.toArray(new Class[extendInterfaces.size()]), (Callback)new MethodInterceptor(){

                /*
                 * WARNING - void declaration
                 */
                public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
                    void var18_25;
                    if (method.getName().equals("toString") || method.getName().equals("hashCode")) {
                        return methodProxy.invokeSuper(o, objects);
                    }
                    logger.debug("Start microservice method {} in {}", (Object)method.getName(), (Object)o.toString());
                    CachedMicroserviceCall microserviceCall = MicroserviceCachedParsedAnnotationInterface.processMicroserviceSignature(method, o);
                    String annotatedPath = microserviceCall.annotatedPath;
                    HttpMethod httpMethod = microserviceCall.httpMethod;
                    Class[] returnGenericType = microserviceCall.returnGenericType;
                    Class<?> microserviceReturnType = microserviceCall.microserviceReturnType;
                    String microserviceName = microserviceCall.microserviceName;
                    boolean convertJsonToMap = microserviceCall.convertResponseToMap;
                    boolean mergePayloadToObject = microserviceCall.mergePayloadToObject;
                    boolean haveDefaultValue = method.isDefault();
                    Object payload = null;
                    List<Parameter> parameters = Arrays.asList(method.getParameters());
                    int paramsForMappingUrl = 0;
                    for (Parameter parameter : parameters) {
                        MicroPathVar param;
                        if (!parameter.getType().equals(String.class) || (param = (MicroPathVar)AnnotationUtils.findAnnotation((AnnotatedElement)parameter, MicroPathVar.class)) == null || StringUtils.isEmpty((Object)param.param()) || StringUtils.isEmpty((Object)param.param())) continue;
                        String paramValue = (String)objects[parameters.indexOf(parameter)];
                        paramValue = URLEncoder.encode(paramValue, "UTF-8");
                        annotatedPath = annotatedPath.replace("{" + param.param() + "}", paramValue);
                        ++paramsForMappingUrl;
                    }
                    if (mergePayloadToObject) {
                        ObjectNode rootNode;
                        payload = rootNode = factory.objectNode();
                        for (Parameter parameter : parameters) {
                            String jsonName;
                            MicroPayloadVar param = (MicroPayloadVar)AnnotationUtils.findAnnotation((AnnotatedElement)parameter, MicroPayloadVar.class);
                            if (param == null) continue;
                            String delimiter = ".";
                            if (!StringUtils.isEmpty((Object)param.path())) {
                                jsonName = param.path();
                            } else {
                                if (!parameter.isNamePresent()) {
                                    throw new InvalidStateException("You try to use java 8 param name extract via reflection, but looks like, not compile javac with -parameters");
                                }
                                jsonName = parameter.getName();
                                delimiter = "_";
                            }
                            ObjectNode latestNode = rootNode;
                            if (jsonName.contains(delimiter)) {
                                String[] split = jsonName.split(delimiter.equals(".") ? "\\." : "_");
                                int i = 0;
                                for (String s : split) {
                                    if (i + 1 == split.length) break;
                                    if (latestNode.path(s).isObject()) {
                                        latestNode = (ObjectNode)latestNode.path(s);
                                    } else {
                                        ObjectNode newNode = factory.objectNode();
                                        latestNode.set(s, (JsonNode)newNode);
                                        latestNode = newNode;
                                    }
                                    ++i;
                                }
                                jsonName = split[split.length - 1];
                            }
                            JsonNode node = (JsonNode)objectMapper.convertValue(objects[parameters.indexOf(parameter)], JsonNode.class);
                            latestNode.set(jsonName, node);
                        }
                    }
                    if ((httpMethod.equals((Object)HttpMethod.POST) || httpMethod.equals((Object)HttpMethod.PUT)) && payload == null) {
                        if (objects.length >= 1) {
                            if (paramsForMappingUrl + 1 != objects.length) {
                                throw new InvalidStateException("You must pass EXACTLY ONE payload to POST or PUT method");
                            }
                        } else {
                            throw new InvalidStateException("You must pass EXACTLY ONE payload to POST or PUT method, have 0");
                        }
                        payload = objects[0];
                    }
                    MicroserviceRestTemplate restTemplate = HttpClientsHelpers.getRestTemplate(microserviceCall.tryToReconnect, microserviceCall.tryToReconnectTimes, microserviceCall.sleepTimeBetweenTrying, microserviceName, annotatedPath, httpMethod);
                    Object var18_21 = null;
                    if (convertJsonToMap) {
                        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                        hashMap.put("convertResponseToMap", true);
                    }
                    if (haveDefaultValue) {
                        void var18_23;
                        if (var18_23 == null) {
                            HashMap hashMap = new HashMap();
                        }
                        var18_25.put("HAVE_DEFAULT_VALUE", true);
                        var18_25.put("DEFAULT_INTERFACE_PROXY_METHOD", method);
                        var18_25.put("INTERFACE_IMPLEMENTED", interfaceToExtend);
                        var18_25.put("METHOD_PARAMS", objects);
                    }
                    HttpHeaders httpHeaders = new HttpHeaders();
                    MicroserviceRequestMaker.beforeProcessRequest(restTemplate, httpHeaders);
                    if (microserviceReturnType.equals(CompletableFuture.class)) {
                        Object finalPayload = payload;
                        void finalParam = var18_25;
                        return CompletableFuture.supplyAsync(() -> 1.lambda$intercept$0(finalPayload, microserviceReturnType, restTemplate, returnGenericType, (Map)finalParam, httpHeaders));
                    }
                    Object result = MicroserviceRequestMaker.makeRequestToMicroservice(payload, microserviceReturnType, restTemplate, returnGenericType, (Map<String, Object>)var18_25, httpHeaders);
                    result = MicroserviceRequestMaker.onBeforeReturnResultProcessor(result, payload, microserviceReturnType, restTemplate, returnGenericType, (Map<String, Object>)var18_25);
                    logger.debug("End microservice method {} in {}", (Object)method.getName(), (Object)o.toString());
                    return result;
                }
            });
            return extendedInterface;
        }
        logger.error("Interface expected {}", (Object)interfaceToExtend.getName());
        return null;
    }

    static class CachedMicroserviceCall {
        Class<?> microserviceReturnType = null;
        Class[] returnGenericType = null;
        HttpMethod httpMethod = null;
        String annotatedPath = null;
        String microserviceName = null;
        boolean convertResponseToMap = false;
        boolean mergePayloadToObject = false;
        boolean tryToReconnect;
        int tryToReconnectTimes;
        int sleepTimeBetweenTrying;

        CachedMicroserviceCall() {
        }
    }
}

