/*
 * Decompiled with CFR 0.152.
 */
package com.biqasoft.microservice.communicator.interfaceimpl;

import com.biqasoft.microservice.communicator.interfaceimpl.ClassPathScanningCandidateComponentMicroserviceInterfaceProvider;
import com.biqasoft.microservice.communicator.interfaceimpl.MicroserviceInterfaceImpFactory;
import com.biqasoft.microservice.communicator.interfaceimpl.annotation.EnableMicroserviceCommunicator;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.stereotype.Component;

@Component
public class MicroserviceInterfaceImplBeanDefinition
implements BeanDefinitionRegistryPostProcessor,
Condition {
    private static final Logger logger = LoggerFactory.getLogger(MicroserviceInterfaceImplBeanDefinition.class);
    private volatile boolean enabled;
    private final Map<String, Object> objectMap = new HashMap<String, Object>();

    private void scanPackage(String basePackage) {
        ClassPathScanningCandidateComponentMicroserviceInterfaceProvider provider = new ClassPathScanningCandidateComponentMicroserviceInterfaceProvider();
        Set components = provider.findCandidateComponents(basePackage);
        for (BeanDefinition component : components) {
            String interfaceClassName = component.getBeanClassName();
            try {
                Class<?> interfaceClass = Class.forName(interfaceClassName);
                Object beanSignature = MicroserviceInterfaceImpFactory.create(interfaceClass);
                this.objectMap.put(interfaceClass.getName(), beanSignature);
                logger.info("Find microservice interface {}", (Object)interfaceClassName);
            }
            catch (Exception e) {
                logger.error("Error init dynamic microservice {}", (Object)interfaceClassName, (Object)e);
            }
        }
    }

    private String[] tryToExtractComponentScanAnnotationFromConfigurationClasses(List<Class> classes) {
        for (Class aClass : classes) {
            Annotation annotation = AnnotationUtils.getAnnotation((AnnotatedElement)aClass, ComponentScan.class);
            String[] basePackage = (String[])AnnotationUtils.getValue((Annotation)annotation, (String)"basePackage");
            if (basePackage != null && basePackage.length > 0) {
                return basePackage;
            }
            basePackage = (String[])AnnotationUtils.getValue((Annotation)annotation, (String)"value");
            if (basePackage == null || basePackage.length <= 0) continue;
            return basePackage;
        }
        return null;
    }

    private List<Class> getSpringConfigurationClassesByBeanNames(String[] strings, BeanDefinitionRegistry beanDefinitionRegistry) {
        ArrayList<Class> classes = new ArrayList<Class>();
        for (String beanDefinitionName : strings) {
            BeanDefinition beanDefinition = beanDefinitionRegistry.getBeanDefinition(beanDefinitionName);
            if (!"full".equals(beanDefinition.getAttribute("org.springframework.context.annotation.ConfigurationClassPostProcessor.configurationClass"))) continue;
            logger.debug("Find configuration file {}", (Object)beanDefinitionName);
            try {
                Class<?> aClass = Class.forName(beanDefinition.getBeanClassName());
                classes.add(aClass);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return classes;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
        String[] strings;
        boolean findRequireAnnotation = false;
        boolean resolveBasePackage = false;
        List<Class> configurationClasses = this.getSpringConfigurationClassesByBeanNames(beanDefinitionRegistry.getBeanDefinitionNames(), beanDefinitionRegistry);
        for (Class aClass : configurationClasses) {
            EnableMicroserviceCommunicator declaredAnnotation = aClass.getDeclaredAnnotation(EnableMicroserviceCommunicator.class);
            if (declaredAnnotation == null) continue;
            findRequireAnnotation = true;
            String[] basePackages = declaredAnnotation.basePackages();
            if (basePackages.length > 0) {
                if (basePackages.length < 1 || basePackages[0].equals("")) break;
                for (String basePackage : basePackages) {
                    resolveBasePackage = true;
                    this.scanPackage(basePackage);
                }
                break;
            }
            logger.warn("Found @EnableMicroserviceCommunicator but not found basePackage attribute");
            break;
        }
        if (!resolveBasePackage & findRequireAnnotation && (strings = this.tryToExtractComponentScanAnnotationFromConfigurationClasses(configurationClasses)) != null) {
            for (String basePackage : strings) {
                this.scanPackage(basePackage);
            }
        }
        if (!findRequireAnnotation) {
            logger.info("Not find @EnableMicroserviceCommunicator annotation on configuration class. Skipping scanning interfaces");
        }
        this.enabled = findRequireAnnotation;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        for (Map.Entry<String, Object> stringObjectEntry : this.objectMap.entrySet()) {
            configurableListableBeanFactory.registerSingleton(stringObjectEntry.getKey(), stringObjectEntry.getValue());
        }
    }

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        return this.enabled;
    }
}

