/*
 * Decompiled with CFR 0.152.
 */
package com.biqasoft.microservice.communicator.interfaceimpl;

import com.biqasoft.microservice.communicator.exceptions.InvalidStateException;
import com.biqasoft.microservice.communicator.interfaceimpl.MicroserviceInterfaceImpFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.http.HttpMethod;

public class SpecialLanguageNotation {
    static SpecialLanguage isProcessSpecialLanguageNotation(Method method) {
        if (method.getName().startsWith("buildMe")) {
            return SpecialLanguage.EN;
        }
        if (method.getName().startsWith("\u043f\u043e\u0441\u0442\u0440\u043e\u0438\u0442\u044c")) {
            return SpecialLanguage.RU;
        }
        return null;
    }

    static void processSpecialLanguageNotation(MicroserviceInterfaceImpFactory.CachedMicroserviceCall cachedMicroserviceCall, Method method, Object o, SpecialLanguage specialLanguage) {
        String methodName = method.getName();
        if (specialLanguage == SpecialLanguage.RU) {
            ArrayList<String> split = new ArrayList<String>(Arrays.asList(methodName.split("(?<!(^|[\u0410-\u042f]))(?=[\u0410-\u042f])|(?<!^)(?=[\u0410-\u042f][\u0430-\u044f])")));
            split.remove(0);
            String httpMethod = (String)split.get(0);
            if (httpMethod.startsWith("\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c")) {
                cachedMicroserviceCall.httpMethod = HttpMethod.GET;
            } else if (httpMethod.startsWith("\u0423\u0434\u0430\u043b\u0438\u0442\u044c")) {
                cachedMicroserviceCall.httpMethod = HttpMethod.DELETE;
            } else if (httpMethod.startsWith("\u041f\u043e\u043b\u043e\u0436\u0438\u0442\u044c")) {
                cachedMicroserviceCall.httpMethod = HttpMethod.PUT;
            } else if (httpMethod.startsWith("\u041e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c")) {
                cachedMicroserviceCall.httpMethod = HttpMethod.POST;
            }
            split.remove(0);
            if (cachedMicroserviceCall.httpMethod == null) {
                throw new InvalidStateException("NULL httpMethod");
            }
            boolean onPath = false;
            for (String s : split) {
                if (s.startsWith("\u041c\u0435\u0441\u0442\u043e")) {
                    onPath = true;
                    cachedMicroserviceCall.annotatedPath = "/" + s.replace("\u041c\u0435\u0441\u0442\u043e", "").toLowerCase();
                }
                if (!onPath || !s.contains("\u0413\u0434\u0435")) continue;
                cachedMicroserviceCall.annotatedPath = cachedMicroserviceCall.annotatedPath + s.replace("\u0413\u0434\u0435", "/").toLowerCase();
            }
        } else if (specialLanguage == SpecialLanguage.EN) {
            throw new UnsupportedOperationException("English is not supported yet");
        }
    }

    static enum SpecialLanguage {
        EN,
        RU;

    }
}

