/*
 * Decompiled with CFR 0.152.
 */
package com.biqasoft.microservice.communicator.servicediscovery;

import com.biqasoft.microservice.communicator.exceptions.CannotResolveHostException;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.stereotype.Service;

@Service
public class MicroserviceHelper {
    @Autowired
    private LoadBalancerClient loadBalancerClient;
    private static final Logger logger = LoggerFactory.getLogger(MicroserviceHelper.class);
    private final int FAIL_AFTER_UNSUCCESS_TIMES = 4;
    private final int DEFAULT_SLEEP_TIME_BETWEEN_TRYING = 1200;

    public URI getLoadBalancedURIByMicroservice(String microserviceName, String pathToApiResource) {
        return this.getLoadBalancedURIByMicroservice(microserviceName, pathToApiResource, 1200, true);
    }

    public URI getLoadBalancedURIByMicroservice(String microserviceName, String pathToApiResource, Integer sleepMilliseconds, Boolean tryToReconnect) {
        int sleepTimeBetweenTrying;
        ServiceInstance instance = null;
        boolean exitLoop = false;
        int triedTimes = 0;
        int n = sleepTimeBetweenTrying = sleepMilliseconds == null ? 1200 : sleepMilliseconds;
        while (!exitLoop) {
            instance = this.loadBalancerClient.choose(microserviceName);
            if (instance != null) {
                exitLoop = true;
                continue;
            }
            if (tryToReconnect == null || !tryToReconnect.booleanValue()) {
                exitLoop = true;
            }
            if (triedTimes > 4) {
                throw new CannotResolveHostException("Can not resolve hostname for microservice name: " + microserviceName);
            }
            ++triedTimes;
            try {
                Thread.sleep(sleepTimeBetweenTrying);
                logger.info("Can not resolve hostname for microservice name: " + microserviceName + " and times: " + triedTimes);
            }
            catch (InterruptedException e) {
                exitLoop = true;
                e.printStackTrace();
            }
        }
        URI storesUri = URI.create(String.format("http://%s:%s", instance.getHost(), instance.getPort()) + pathToApiResource);
        return storesUri;
    }
}

