/*
 * Decompiled with CFR 0.152.
 */
package com.bisna.util;

import com.bisna.util.Base62;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;

public final class KSUID
implements Serializable,
Comparable<KSUID> {
    static final int EPOCH = 1400000000;
    static final int TIMESTAMP_LENGTH = 4;
    static final int PAYLOAD_LENGTH = 16;
    static final int MAX_ENCODED_LENGTH = 27;
    private final String value;
    private final byte[] buffer;
    private Integer timestamp;
    private byte[] payload;

    private KSUID(String value) {
        this(value, Holder.base62.decode(value.getBytes(StandardCharsets.UTF_8)));
    }

    private KSUID(byte[] buffer) {
        this(new String(Holder.base62.encode(buffer), 0, 27), buffer);
    }

    private KSUID(String value, byte[] buffer) {
        if (value.length() != 27) {
            throw new RuntimeException(String.format("Valid encoded KSUIDs are %s characters.", 27));
        }
        int byteLength = 20;
        if (buffer.length != 20) {
            throw new RuntimeException(String.format("Valid KSUIDs are %s bytes, but found %s bytes.", 20, buffer.length));
        }
        this.value = value;
        this.buffer = buffer;
    }

    public static KSUID fromString(String value) {
        return new KSUID(value);
    }

    public static KSUID randomKSUID() {
        int timestamp = (int)ZonedDateTime.now(ZoneOffset.UTC).toInstant().toEpochMilli() / 1000;
        return KSUID.randomKSUIDFromTimestamp(timestamp);
    }

    public static KSUID randomKSUIDFromTimestamp(int timestamp) {
        byte[] timestampBytes = ByteBuffer.allocate(4).putInt(timestamp - 1400000000).array();
        byte[] payloadBytes = new byte[16];
        Holder.numberGenerator.nextBytes(payloadBytes);
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            output.write(timestampBytes);
            output.write(payloadBytes);
            return new KSUID(output.toByteArray());
        }
        catch (IOException exception) {
            throw new RuntimeException("Unable to generate KSUID.");
        }
    }

    public int timestamp() {
        if (this.timestamp == null) {
            byte[] timestampBytes = new byte[4];
            System.arraycopy(this.buffer, 0, timestampBytes, 0, 4);
            this.timestamp = ByteBuffer.wrap(timestampBytes).getInt() + 1400000000;
        }
        return this.timestamp;
    }

    public byte[] payload() {
        if (this.payload == null) {
            byte[] payloadBytes = new byte[16];
            int length = this.buffer.length - 4;
            System.arraycopy(this.buffer, 4, payloadBytes, 0, length);
            this.payload = payloadBytes;
        }
        return this.payload;
    }

    public KSUID nextKSUID() {
        return KSUID.randomKSUIDFromTimestamp(this.timestamp());
    }

    @Override
    public int compareTo(KSUID that) {
        return Integer.compare(this.timestamp(), that.timestamp());
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.payload());
        return 31 * result + this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (null == obj || obj.getClass() != KSUID.class) {
            return false;
        }
        KSUID that = (KSUID)obj;
        return this.value.equals(that.value);
    }

    public String toString() {
        return this.value;
    }

    static class Holder {
        static final SecureRandom numberGenerator = new SecureRandom();
        static final Base62 base62 = Base62.createInstance();

        Holder() {
        }
    }
}

