/*
 * Decompiled with CFR 0.152.
 */
package com.bisnode.opa.testformats.junit;

import com.bisnode.opa.OpaTestCase;
import com.bisnode.opa.OpaTestResults;
import com.bisnode.opa.testformats.junit.Suite;
import com.bisnode.opa.testformats.junit.TestCase;
import com.bisnode.opa.testformats.junit.TimeFormatter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JacksonXmlRootElement(localName="testsuites")
public class JUnitXml {
    private static final XmlMapper XML_MAPPER = (XmlMapper)((XmlMapper.Builder)((XmlMapper.Builder)XmlMapper.builder().defaultUseWrapper(false).enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).serializationInclusion(JsonInclude.Include.NON_NULL)).build();
    private final List<Suite> suites;

    public static JUnitXml from(OpaTestResults opaTestResults) {
        return new JUnitXml(JUnitXml.toSuites(opaTestResults));
    }

    private static List<Suite> toSuites(OpaTestResults opaTestResults) {
        return JUnitXml.groupBySuite(opaTestResults).entrySet().stream().map(entry -> new Suite((String)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
    }

    private static Map<String, List<TestCase>> groupBySuite(OpaTestResults opaTestResults) {
        return opaTestResults.getTestCases().stream().collect(Collectors.groupingBy(OpaTestCase::getPackage, Collectors.mapping(TestCase::fromOpaTestCase, Collectors.toList())));
    }

    private JUnitXml(List<Suite> suites) {
        this.suites = suites;
    }

    public String asXmlString() throws JsonProcessingException {
        return XML_MAPPER.writeValueAsString((Object)this);
    }

    @JacksonXmlProperty(localName="testsuite")
    List<Suite> getSuites() {
        return this.suites;
    }

    @JacksonXmlProperty(isAttribute=true)
    long getFailures() {
        return this.suites.stream().map(Suite::getFailures).reduce(0L, Long::sum);
    }

    @JacksonXmlProperty(isAttribute=true)
    long getErrors() {
        return this.suites.stream().map(Suite::getErrors).reduce(0L, Long::sum);
    }

    @JacksonXmlProperty(isAttribute=true)
    long getTests() {
        return this.suites.stream().map(Suite::getTests).reduce(0L, Long::sum);
    }

    @JacksonXmlProperty(isAttribute=true)
    String getTime() {
        return TimeFormatter.nanosToSeconds(this.suites.stream().map(Suite::getTimeNanos).reduce(0L, Long::sum));
    }
}

