/*
 * Decompiled with CFR 0.152.
 */
package com.bisnode.opa.testformats.junit;

import com.bisnode.opa.testformats.junit.TestCase;
import com.bisnode.opa.testformats.junit.TimeFormatter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.List;
import java.util.Objects;

class Suite {
    private final String name;
    private final List<TestCase> testCases;

    Suite(String name, List<TestCase> testCases) {
        this.name = name;
        this.testCases = testCases;
    }

    @JacksonXmlProperty(isAttribute=true)
    String getName() {
        return this.name;
    }

    @JacksonXmlProperty(localName="testcase")
    List<TestCase> getTestCases() {
        return this.testCases;
    }

    @JacksonXmlProperty(isAttribute=true)
    long getTests() {
        return this.testCases.size();
    }

    @JacksonXmlProperty(isAttribute=true)
    long getErrors() {
        return this.testCases.stream().map(TestCase::getError).filter(Objects::nonNull).count();
    }

    @JacksonXmlProperty(isAttribute=true)
    long getFailures() {
        return this.testCases.stream().filter(TestCase::isFailure).count();
    }

    @JacksonXmlProperty(isAttribute=true)
    String getTime() {
        return TimeFormatter.nanosToSeconds(this.testCases.stream().map(TestCase::getTimeNanos).reduce(0L, Long::sum));
    }

    @JsonIgnore
    long getTimeNanos() {
        return this.testCases.stream().map(TestCase::getTimeNanos).reduce(0L, Long::sum);
    }
}

