/*
 * Decompiled with CFR 0.152.
 */
package com.bisnode.opa.testformats.junit;

import com.bisnode.opa.OpaTestCase;
import com.bisnode.opa.testformats.junit.Error;
import com.bisnode.opa.testformats.junit.TimeFormatter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.Optional;

class TestCase {
    private final String name;
    private final String className;
    private final long time;
    private final boolean failure;
    private final Error error;

    static TestCase fromOpaTestCase(OpaTestCase opaTestCase) {
        return new TestCase(opaTestCase.getName(), opaTestCase.getLocation().getFile(), opaTestCase.getDuration(), Optional.ofNullable(opaTestCase.getFail()).orElse(false), Optional.ofNullable(opaTestCase.getError()).map(Error::fromOpaError).orElse(null));
    }

    private TestCase(String name, String className, long time, boolean failure, Error error) {
        this.name = name;
        this.className = className;
        this.time = time;
        this.failure = failure;
        this.error = error;
    }

    @JacksonXmlProperty(isAttribute=true)
    String getName() {
        return this.name;
    }

    @JacksonXmlProperty(isAttribute=true, localName="classname")
    String getClassName() {
        return this.className;
    }

    @JacksonXmlProperty(isAttribute=true)
    String getTime() {
        return TimeFormatter.nanosToSeconds(this.time);
    }

    @JsonIgnore
    long getTimeNanos() {
        return this.time;
    }

    @JsonIgnore
    boolean isFailure() {
        return this.failure;
    }

    @JacksonXmlProperty(localName="failure")
    String getFailure() {
        return this.isFailure() ? "" : null;
    }

    @JacksonXmlProperty(localName="error")
    Error getError() {
        return this.error;
    }
}

